/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IServerConnection;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.core.streams.PollingInputStream;
import org.eclipse.team.internal.core.streams.PollingOutputStream;
import org.eclipse.team.internal.core.streams.TimeoutInputStream;
import org.eclipse.team.internal.core.streams.TimeoutOutputStream;

public class ExtConnection
implements IServerConnection {
    private ICVSRepositoryLocation location;
    private String password;
    InputStream inputStream;
    OutputStream outputStream;
    Process process;

    protected ExtConnection(ICVSRepositoryLocation location, String password) {
        this.location = location;
        this.password = password;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        finally {
            this.inputStream = null;
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
            finally {
                this.outputStream = null;
                if (this.process != null) {
                    this.process.destroy();
                }
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void open(IProgressMonitor monitor) throws IOException {
        String[] command = ((CVSRepositoryLocation)this.location).getExtCommand(this.password);
        boolean connected = false;
        try {
            this.process = Util.createProcess(command, monitor);
            this.inputStream = new PollingInputStream((InputStream)new TimeoutInputStream(this.process.getInputStream(), 8192, 1000L, -1L), this.location.getTimeout(), monitor);
            this.outputStream = new PollingOutputStream((OutputStream)new TimeoutOutputStream(this.process.getOutputStream(), 8192, 1000L, 1000L), this.location.getTimeout(), monitor);
            connected = true;
        }
        finally {
            if (!connected) {
                this.close();
            }
        }
    }
}

