/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.gtest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.testsrunner.internal.gtest.GoogleTestsRunnerMessages;
import org.eclipse.cdt.testsrunner.internal.gtest.GoogleTestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.cdt.testsrunner.model.ITestMessage;
import org.eclipse.cdt.testsrunner.model.ITestModelUpdater;
import org.eclipse.cdt.testsrunner.model.TestingException;

public class OutputHandler {
    private static final String DEFAULT_LOCATION_FILE = null;
    private static final int DEFAULT_LOCATION_LINE = 1;
    private static String regexTestSuiteName = "([^, ]+)";
    private static String regexParameterInstantiation = "(\\s*,\\s+where\\s+TypeParam\\s*=(.+))?";
    private static String regexTestName = String.valueOf(regexTestSuiteName) + "\\.([^,]+)";
    private static String regexTestCount = "\\d+\\s+tests?";
    private static String regexTestTime = "(\\d+)\\s+ms";
    private static String regexLocation = "((.*)(:(\\d+)|\\((\\d+)\\))|(.*[^):])):";
    private static String testStatusOk = "OK";
    private static String testStatusFailed = "FAILED";
    private State stateInitial = new State("");
    private State stateInitialized = new State(".*Global test environment set-up.*");
    private TestSuiteStart stateTestSuiteStart = new TestSuiteStart("\\[-*\\]\\s+" + regexTestCount + "\\s+from\\s+" + regexTestSuiteName + regexParameterInstantiation, 3);
    private State stateTestCaseStart = new TestCaseStart("\\[\\s*RUN\\s*\\]\\s+" + regexTestName, 2);
    private ErrorMessageLocation stateErrorMessageLocation = new ErrorMessageLocation(String.valueOf(regexLocation) + "\\s+(Failure|error: (.*))", 8);
    private State stateErrorMessage = new ErrorMessage("(.*)", 1);
    private State stateTestTraceStart = new State(".*Google Test trace.*");
    private State stateTestTrace = new TestTrace(String.valueOf(regexLocation) + "\\s+((.*))", 8);
    private State stateTestCaseEnd = new TestCaseEnd("\\[\\s*(" + testStatusOk + "|" + testStatusFailed + ")\\s*\\]\\s+" + regexTestName + regexParameterInstantiation + "(\\s*,\\s+where\\s+GetParam\\s*\\(\\s*\\)\\s*=\\s*(.+))?\\s+\\(" + regexTestTime + "\\)", 8);
    private State stateTestSuiteEnd = new TestSuiteEnd("\\[-*\\]\\s+" + regexTestCount + "\\s+from\\s+" + regexTestSuiteName + "\\s+\\(" + regexTestTime + "\\s+total\\)", 2);
    private State stateFinal = new State(".*Global test environment tear-down.*");
    private State stateEmptyTestModuleFinal = new State(".*\\[\\s*PASSED\\s*\\]\\s+0\\s+tests.*");
    private Map<State, State[]> transitions = new HashMap<State, State[]>();
    private State currentState;
    private ITestModelUpdater modelUpdater;

    OutputHandler(ITestModelUpdater modelUpdater) {
        this.transitions.put(this.from(this.stateInitial), this.to(this.stateInitialized, this.stateEmptyTestModuleFinal));
        this.transitions.put(this.from(this.stateInitialized), this.to(this.stateTestSuiteStart));
        this.transitions.put(this.from(this.stateTestSuiteStart), this.to(this.stateTestCaseStart));
        this.transitions.put(this.from(this.stateTestCaseStart), this.to(this.stateTestCaseEnd, this.stateErrorMessageLocation));
        this.transitions.put(this.from(this.stateErrorMessageLocation), this.to(this.stateTestTraceStart, this.stateTestCaseEnd, this.stateErrorMessageLocation, this.stateErrorMessage));
        this.transitions.put(this.from(this.stateErrorMessage), this.to(this.stateTestTraceStart, this.stateTestCaseEnd, this.stateErrorMessageLocation, this.stateErrorMessage));
        this.transitions.put(this.from(this.stateTestTraceStart), this.to(this.stateTestTrace));
        this.transitions.put(this.from(this.stateTestTrace), this.to(this.stateTestCaseEnd, this.stateErrorMessageLocation, this.stateTestTrace));
        this.transitions.put(this.from(this.stateTestCaseEnd), this.to(this.stateTestCaseStart, this.stateTestSuiteEnd));
        this.transitions.put(this.from(this.stateTestSuiteEnd), this.to(this.stateTestSuiteStart, this.stateFinal));
        this.modelUpdater = modelUpdater;
    }

    public void run(InputStream inputStream) throws IOException, TestingException {
        String line;
        InputStreamReader streamReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(streamReader);
        boolean finalizedProperly = false;
        this.currentState = this.stateInitial;
        block0: while ((line = reader.readLine()) != null) {
            State[] possibleNextStates = this.transitions.get(this.currentState);
            if (possibleNextStates == null) {
                finalizedProperly = true;
                break;
            }
            State[] stateArray = possibleNextStates;
            int n = possibleNextStates.length;
            int n2 = 0;
            while (n2 < n) {
                State nextState = stateArray[n2];
                if (nextState.match(line)) {
                    this.currentState.onExit(nextState);
                    State previousState = this.currentState;
                    this.currentState = nextState;
                    nextState.onEnter(previousState);
                    continue block0;
                }
                ++n2;
            }
        }
        if (this.transitions.get(this.currentState) == null) {
            finalizedProperly = true;
        }
        if (!finalizedProperly) {
            this.generateInternalError(GoogleTestsRunnerMessages.OutputHandler_unexpected_output);
        }
    }

    private void generateInternalError(String additionalInfo) throws TestingException {
        TestingException e = new TestingException(String.valueOf(GoogleTestsRunnerMessages.OutputHandler_unknown_error_prefix) + additionalInfo);
        GoogleTestsRunnerPlugin.log((Throwable)e);
        throw e;
    }

    private State from(State fromState) {
        return fromState;
    }

    private State[] to(State ... toStates) {
        return toStates;
    }

    class ErrorMessage
    extends State {
        private StringBuilder messagePart;

        ErrorMessage(String enterRegex, int groupCount) {
            super(enterRegex, groupCount);
            this.messagePart = new StringBuilder();
        }

        @Override
        public void onEnter(State previousState) {
            String firstMessagePart;
            boolean needEndOfLine;
            boolean bl = needEndOfLine = this == previousState;
            if (this != previousState && (firstMessagePart = OutputHandler.this.stateErrorMessageLocation.getMessagePart()) != null) {
                this.messagePart.append(firstMessagePart);
                needEndOfLine = true;
            }
            if (needEndOfLine) {
                this.messagePart.append(System.getProperty("line.separator"));
            }
            this.messagePart.append(this.group(1));
        }

        @Override
        public void onExit(State nextState) {
            if (this != nextState) {
                OutputHandler.this.modelUpdater.addTestMessage(OutputHandler.this.stateErrorMessageLocation.getMessageFileName(), OutputHandler.this.stateErrorMessageLocation.getMessageLineNumber(), ITestMessage.Level.Error, this.messagePart.toString());
                this.messagePart.setLength(0);
            }
        }
    }

    class ErrorMessageLocation
    extends State {
        private String messageFileName;
        private int messageLineNumber;
        private String messagePart;

        ErrorMessageLocation(String enterRegex, int groupCount) {
            super(enterRegex, groupCount);
        }

        @Override
        public void onEnter(State previousState) throws TestingException {
            String fileNameIfLinePresent = this.group(2);
            String fileNameIfLineAbsent = this.group(6);
            String lineNumberCommon = this.group(4);
            String lineNumberVS = this.group(5);
            if (fileNameIfLinePresent != null) {
                if (lineNumberCommon != null) {
                    this.messageFileName = fileNameIfLinePresent;
                    this.messageLineNumber = Integer.parseInt(lineNumberCommon.trim());
                } else if (lineNumberVS != null) {
                    this.messageFileName = fileNameIfLinePresent;
                    this.messageLineNumber = Integer.parseInt(lineNumberVS.trim());
                } else if (!OutputHandler.this.modelUpdater.currentTestSuite().getName().equals(this.group(1))) {
                    OutputHandler.this.generateInternalError(GoogleTestsRunnerMessages.OutputHandler_unknown_location_format);
                }
            } else if (fileNameIfLineAbsent != null) {
                if (lineNumberCommon == null && lineNumberVS == null) {
                    this.messageFileName = fileNameIfLineAbsent;
                    this.messageLineNumber = 1;
                } else {
                    OutputHandler.this.generateInternalError(GoogleTestsRunnerMessages.OutputHandler_unknown_location_format);
                }
            }
            if (this.messageFileName.equals("unknown file")) {
                this.messageFileName = DEFAULT_LOCATION_FILE;
            }
            this.messagePart = this.group(8);
        }

        public String getMessageFileName() {
            return this.messageFileName;
        }

        public int getMessageLineNumber() {
            return this.messageLineNumber;
        }

        public String getMessagePart() {
            return this.messagePart;
        }
    }

    class State {
        private Pattern enterPattern;
        private Matcher matcher;
        private int groupCount;

        State(String enterRegex) {
            this(enterRegex, -1);
        }

        State(String enterRegex, int groupCount) {
            this.enterPattern = Pattern.compile(enterRegex);
            this.groupCount = groupCount;
        }

        public boolean match(String line) throws TestingException {
            boolean matches;
            boolean groupsCountOk;
            this.matcher = this.enterPattern.matcher(line);
            boolean bl = groupsCountOk = this.groupCount == -1 || this.matcher.groupCount() == this.groupCount;
            if (!groupsCountOk) {
                OutputHandler.this.generateInternalError(MessageFormat.format(GoogleTestsRunnerMessages.OutputHandler_wrong_groups_count, this.enterPattern.pattern(), this.matcher.groupCount(), this.groupCount));
            }
            if (!(matches = this.matcher.matches()) || !groupsCountOk) {
                this.matcher = null;
            }
            return matches;
        }

        protected String group(int groupNumber) {
            return this.matcher.group(groupNumber);
        }

        public void onEnter(State previousState) throws TestingException {
        }

        public void onExit(State nextState) {
        }

        protected String getTestSuiteName(String name, String typeParameter) {
            return typeParameter != null ? MessageFormat.format("{0}({1})", name, typeParameter.trim()) : name;
        }
    }

    class TestCaseEnd
    extends State {
        TestCaseEnd(String enterRegex, int groupCount) {
            super(enterRegex, groupCount);
        }

        @Override
        public void onEnter(State previousState) throws TestingException {
            String lastTestCaseName;
            String lastTestSuiteName = OutputHandler.this.modelUpdater.currentTestSuite().getName();
            String explicitTypeParameter = this.group(5);
            String typeParameter = explicitTypeParameter != null ? explicitTypeParameter : OutputHandler.this.stateTestSuiteStart.getTypeParameter();
            String currTestSuiteName = this.getTestSuiteName(this.group(2), typeParameter);
            if (!lastTestSuiteName.equals(currTestSuiteName)) {
                OutputHandler.this.generateInternalError(MessageFormat.format(GoogleTestsRunnerMessages.OutputHandler_wrong_suite_name, this.group(2), currTestSuiteName, lastTestSuiteName));
            }
            if (!(lastTestCaseName = OutputHandler.this.modelUpdater.currentTestCase().getName()).equals(this.group(3))) {
                OutputHandler.this.generateInternalError(MessageFormat.format(GoogleTestsRunnerMessages.OutputHandler_unexpected_case_end, this.group(3), lastTestCaseName));
            }
            String testStatusStr = this.group(1);
            ITestItem.Status testStatus = ITestItem.Status.Skipped;
            if (testStatusStr.equals(testStatusOk)) {
                testStatus = ITestItem.Status.Passed;
            } else if (testStatusStr.equals(testStatusFailed)) {
                testStatus = ITestItem.Status.Failed;
            } else {
                OutputHandler.this.generateInternalError(MessageFormat.format(GoogleTestsRunnerMessages.OutputHandler_unknown_test_status, testStatusStr));
            }
            String getParamValue = this.group(7);
            if (getParamValue != null) {
                OutputHandler.this.modelUpdater.addTestMessage(DEFAULT_LOCATION_FILE, 1, ITestMessage.Level.Info, MessageFormat.format(GoogleTestsRunnerMessages.OutputHandler_getparam_message, getParamValue));
            }
            OutputHandler.this.modelUpdater.setTestingTime(Integer.parseInt(this.group(8)));
            OutputHandler.this.modelUpdater.setTestStatus(testStatus);
            OutputHandler.this.modelUpdater.exitTestCase();
        }
    }

    class TestCaseStart
    extends State {
        TestCaseStart(String enterRegex, int groupCount) {
            super(enterRegex, groupCount);
        }

        @Override
        public void onEnter(State previousState) throws TestingException {
            String currTestSuiteName;
            String testCaseName = this.group(2);
            String lastTestSuiteName = OutputHandler.this.modelUpdater.currentTestSuite().getName();
            if (!lastTestSuiteName.equals(currTestSuiteName = this.getTestSuiteName(this.group(1), OutputHandler.this.stateTestSuiteStart.getTypeParameter()))) {
                OutputHandler.this.generateInternalError(MessageFormat.format(GoogleTestsRunnerMessages.OutputHandler_wrong_suite_name, testCaseName, currTestSuiteName, lastTestSuiteName));
            }
            OutputHandler.this.modelUpdater.enterTestCase(testCaseName);
        }
    }

    class TestSuiteEnd
    extends State {
        TestSuiteEnd(String enterRegex, int groupCount) {
            super(enterRegex, groupCount);
        }

        @Override
        public void onEnter(State previousState) throws TestingException {
            String currTestSuiteName;
            String lastTestSuiteName = OutputHandler.this.modelUpdater.currentTestSuite().getName();
            if (!lastTestSuiteName.equals(currTestSuiteName = this.getTestSuiteName(this.group(1), OutputHandler.this.stateTestSuiteStart.getTypeParameter()))) {
                OutputHandler.this.generateInternalError(MessageFormat.format(GoogleTestsRunnerMessages.OutputHandler_unexpected_suite_end, currTestSuiteName, lastTestSuiteName));
            }
            OutputHandler.this.modelUpdater.exitTestSuite();
        }
    }

    class TestSuiteStart
    extends State {
        private String typeParameter;

        TestSuiteStart(String enterRegex, int groupCount) {
            super(enterRegex, groupCount);
        }

        @Override
        public void onEnter(State previousState) {
            this.typeParameter = this.group(3);
            OutputHandler.this.modelUpdater.enterTestSuite(this.getTestSuiteName(this.group(1), this.typeParameter));
        }

        public String getTypeParameter() {
            return this.typeParameter;
        }
    }

    class TestTrace
    extends ErrorMessageLocation {
        TestTrace(String enterRegex, int groupCount) {
            super(enterRegex, groupCount);
        }

        @Override
        public void onEnter(State previousState) throws TestingException {
            super.onEnter(previousState);
            OutputHandler.this.modelUpdater.addTestMessage(this.getMessageFileName(), this.getMessageLineNumber(), ITestMessage.Level.Info, this.getMessagePart());
        }
    }
}

