/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;

public class GenericXMLWriter
extends PrintWriter {
    private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private int tab = 0;
    private String lineSeparator;

    private static void appendEscapedChar(StringBuilder buffer, char c) {
        String replacement = GenericXMLWriter.getReplacement(c);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else {
            buffer.append(c);
        }
    }

    private static String getEscaped(String s) {
        StringBuilder result = new StringBuilder(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            GenericXMLWriter.appendEscapedChar(result, s.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    public GenericXMLWriter(OutputStream stream, String lineSeparator, boolean printXmlVersion) {
        this(new PrintWriter(stream), lineSeparator, printXmlVersion);
    }

    public GenericXMLWriter(Writer writer, String lineSeparator, boolean printXmlVersion) {
        super(writer);
        this.lineSeparator = lineSeparator;
        if (printXmlVersion) {
            this.print(XML_VERSION);
            this.print(this.lineSeparator);
        }
    }

    public void endTag(String name, boolean insertTab, boolean insertNewLine) {
        --this.tab;
        this.printTag(String.valueOf('/') + name, null, insertTab, insertNewLine, false);
    }

    private void printTabulation() {
        int i = 0;
        while (i < this.tab) {
            super.print('\t');
            ++i;
        }
    }

    public void printTag(String name, Map<String, String> parameters, boolean insertTab, boolean insertNewLine, boolean closeTag) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(name);
        if (parameters != null) {
            int length = parameters.size();
            Object[] keys = new String[length];
            parameters.keySet().toArray(keys);
            Arrays.sort(keys);
            int i = 0;
            while (i < length) {
                sb.append(" ");
                sb.append((String)keys[i]);
                sb.append("=\"");
                sb.append(GenericXMLWriter.getEscaped(String.valueOf(parameters.get(keys[i]))));
                sb.append("\"");
                ++i;
            }
        }
        if (closeTag) {
            sb.append("/>");
        } else {
            sb.append(">");
        }
        this.printString(sb.toString(), insertTab, insertNewLine);
        if (parameters != null && !closeTag) {
            ++this.tab;
        }
    }

    public void printString(String string, boolean insertTab, boolean insertNewLine) {
        if (insertTab) {
            this.printTabulation();
        }
        this.print(string);
        if (insertNewLine) {
            this.print(this.lineSeparator);
        }
    }

    public void startTag(String name, boolean insertTab) {
        this.printTag(name, null, insertTab, true, false);
        ++this.tab;
    }
}

