/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphing.ui.charts;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.GraphingUIPlugin;
import org.eclipse.linuxtools.systemtap.graphing.core.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.graphing.ui.charts.listeners.AbstractChartMouseMoveListener;
import org.eclipse.linuxtools.systemtap.structures.listeners.IUpdateListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ITitle;
import org.eclipse.swtchart.extensions.charts.InteractiveChart;

public abstract class AbstractChartBuilder
extends Composite
implements IUpdateListener {
    protected static final String FONT_NAME = "MS Sans Serif";
    protected int maxItems;
    protected double scale = 1.0;
    protected double scaleY = 1.0;
    protected double scroll = 1.0;
    protected double scrollY = 1.0;
    protected IAdapter adapter = null;
    protected static final Color WHITE = Display.getDefault().getSystemColor(1);
    protected static final Color BLACK = Display.getDefault().getSystemColor(2);
    protected static final Color RED = Display.getDefault().getSystemColor(3);
    protected static final Color[] COLORS = new Color[]{RED, Display.getDefault().getSystemColor(5), Display.getDefault().getSystemColor(9), Display.getDefault().getSystemColor(7), Display.getDefault().getSystemColor(11), Display.getDefault().getSystemColor(13), BLACK, new Color((Device)Display.getDefault(), 64, 128, 128), new Color((Device)Display.getDefault(), 255, 165, 0), new Color((Device)Display.getDefault(), 128, 128, 128)};
    protected InteractiveChart chart = null;
    protected String title = null;
    private List<IUpdateListener> listeners = new ArrayList<IUpdateListener>();
    protected AbstractChartMouseMoveListener chartMouseMoveListener = null;
    protected IPreferenceStore store;
    private IPropertyChangeListener propertyChangeListener;

    public String getMouseMessage() {
        return this.chartMouseMoveListener != null ? this.chartMouseMoveListener.getMouseMessage() : null;
    }

    protected void updateProperties(PropertyChangeEvent event) {
        if (event.getProperty().equals("ViewableDataItems") || event.getProperty().equals("MaxDataItems")) {
            this.maxItems = Math.min(this.store.getInt("ViewableDataItems"), this.store.getInt("MaxDataItems"));
            this.updateDataSet();
        }
    }

    public AbstractChartBuilder(IAdapter adapter, Composite parent, int style, String title) {
        super(parent, style);
        this.adapter = adapter;
        this.title = title;
        this.setLayout((Layout)new FillLayout());
        this.store = GraphingUIPlugin.getDefault().getPreferenceStore();
        this.maxItems = Math.min(this.store.getInt("ViewableDataItems"), this.store.getInt("MaxDataItems"));
        this.propertyChangeListener = event -> this.updateProperties(event);
        this.store.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void dispose() {
        this.store.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        super.dispose();
    }

    public void build() {
        this.createChart();
        this.buildPlot();
        this.buildLegend();
        this.buildTitle();
        this.buildXAxis();
        this.buildYAxis();
        this.buildXSeries();
        this.buildYSeries();
        this.updateDataSet();
    }

    protected void createChart() {
        this.chart = new InteractiveChart((Composite)this, this.getStyle());
    }

    private void buildPlot() {
        this.chart.setBackground(WHITE);
        this.chart.getPlotArea().setBackground(WHITE);
    }

    protected abstract void buildXAxis();

    protected abstract void buildYAxis();

    protected abstract void buildXSeries();

    protected abstract void buildYSeries();

    public abstract void updateDataSet();

    private void buildLegend() {
        this.chart.getLegend().setPosition(131072);
    }

    private void buildTitle() {
        ITitle ctitle = this.chart.getTitle();
        ctitle.setForeground(BLACK);
        ctitle.setText(this.title);
        this.chart.setProposedSaveAsFilename(this.title);
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setScale(double scale) {
        this.scale = scale < 0.0 ? 0.0 : (scale > 1.0 ? 1.0 : scale);
        this.handleUpdateEvent();
    }

    public double getScale() {
        return this.scale;
    }

    public void setScaleY(double scale) {
        this.scaleY = scale < 0.0 ? 0.0 : (scale > 1.0 ? 1.0 : scale);
        this.handleUpdateEvent();
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void setScroll(double scroll) {
        this.scroll = scroll < 0.0 ? 0.0 : (scroll > 1.0 ? 1.0 : scroll);
        this.handleUpdateEvent();
    }

    public double getScroll() {
        return this.scroll;
    }

    public void setScrollY(double scroll) {
        this.scrollY = scroll < 0.0 ? 0.0 : (scroll > 1.0 ? 1.0 : scroll);
        this.handleUpdateEvent();
    }

    public double getScrollY() {
        return this.scrollY;
    }

    protected Double getDoubleOrNullValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        try {
            return Double.valueOf(o.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void handleUpdateEvent() {
        if (this.chart != null && !this.chart.isDisposed()) {
            this.repaint();
        }
    }

    public void addUpdateListener(IUpdateListener l) {
        this.listeners.add(l);
    }

    public boolean removeUpdateListener(IUpdateListener l) {
        return this.listeners.remove(l);
    }

    private void repaint() {
        this.getDisplay().asyncExec(() -> {
            if (!this.chart.isDisposed()) {
                this.updateDataSet();
                for (IUpdateListener l : this.listeners) {
                    l.handleUpdateEvent();
                }
            }
        });
    }

    protected String[] getUniqueNames(String[] labels) {
        LinkedHashSet<String> labelsUnique = new LinkedHashSet<String>();
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            int count = 1;
            while (!labelsUnique.add(this.makeCountedLabel(label, count))) {
                ++count;
            }
            ++n2;
        }
        return labelsUnique.toArray(new String[labels.length]);
    }

    private String makeCountedLabel(String original, int count) {
        return count <= 1 ? original : original.concat(String.format(" (%d)", count));
    }
}

