/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.model.edit.pom.translators;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2e.model.edit.pom.PomFactory;
import org.eclipse.m2e.model.edit.pom.translators.ModelObjectAdapter;
import org.eclipse.m2e.model.edit.pom.translators.SSESyncResource;
import org.eclipse.m2e.model.edit.pom.translators.TranslatorAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ListAdapter
extends TranslatorAdapter {
    protected List list;
    private final EClass elementType;

    public ListAdapter(SSESyncResource resc, Element containerNode, List<?> list, EClass elementType) {
        super(resc);
        this.node = containerNode;
        this.elementType = elementType;
        this.list = list;
        this.resource = resc;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this.resource.isProcessEvents()) {
            try {
                this.resource.setProcessEvents(false);
                if (2 == eventType && newValue instanceof Element) {
                    if (notifier == this.node) {
                        IDOMElement addedElement = (IDOMElement)newValue;
                        int idx = this.absoluteIndexOf(this.node, (Element)addedElement);
                        if (idx == -1) {
                            idx = 0;
                        }
                        this.list.add(idx, this.getObject((Element)addedElement, true));
                    }
                } else if (3 == eventType && oldValue instanceof Element) {
                    if (notifier == this.node) {
                        Object o = this.getObject((Element)oldValue, false);
                        if (o instanceof String && o.toString().length() == 0) {
                            NodeList lst = this.node.getChildNodes();
                            this.list.clear();
                            int i = 0;
                            while (i < lst.getLength()) {
                                Node nd = lst.item(i);
                                if (nd instanceof Element) {
                                    this.list.add(ListAdapter.getElementText((Element)nd));
                                }
                                ++i;
                            }
                        } else if (o != null) {
                            this.list.remove(o);
                        }
                    }
                } else if (changedFeature instanceof Text && this.elementType == null && notifier != this.node && notifier instanceof Element) {
                    Element e = (Element)notifier;
                    int idx = this.absoluteIndexOf(this.node, e);
                    if (idx < 0) {
                        idx = 0;
                    }
                    this.list.remove(idx);
                    this.list.add(idx, this.getObject(e, true));
                }
            }
            finally {
                this.resource.setProcessEvents(true);
            }
        }
    }

    public void add(Object newValue, int position) {
        Object value = this.getElementValue(newValue);
        if (value instanceof EObject) {
            EObject eo = (EObject)value;
            if (EcoreUtil.getAdapter((List)eo.eAdapters(), ModelObjectAdapter.class) == null) {
                String tagName = this.getElementName(newValue);
                Element newElement = this.node.getOwnerDocument().createElement(tagName);
                Element before = this.getNthChildWithName(this.node, "*", position);
                if (before != null) {
                    this.node.insertBefore(newElement, before);
                } else {
                    this.node.appendChild(newElement);
                }
                ModelObjectAdapter newAdapter = new ModelObjectAdapter(this.resource, eo, newElement);
                eo.eAdapters().add((Object)newAdapter);
                this.formatNode(newElement);
                ((IDOMNode)newElement).addAdapter((INodeAdapter)newAdapter);
                newAdapter.save();
            }
        } else {
            String tagName = this.getElementName(newValue);
            Element newElement = this.node.getOwnerDocument().createElement(tagName);
            Text text = this.node.getOwnerDocument().createTextNode(value.toString());
            newElement.appendChild(text);
            Element before = this.getNthChildWithName(this.node, "*", position);
            if (before != null) {
                this.node.insertBefore(newElement, before);
            } else {
                this.node.appendChild(newElement);
            }
            this.formatNode(newElement);
            ((IDOMNode)newElement).addAdapter((INodeAdapter)this);
        }
    }

    public void remove(Object oldValue, int position) {
        Element n;
        if (position == -1) {
            position = 0;
        }
        if ((n = this.getNthChildWithName(this.node, "*", position)) != null) {
            this.removeChildElement(n);
        }
    }

    @Override
    public void update(Object oldValue, Object newValue, int index) {
        this.remove(oldValue, index);
        this.add(newValue, index);
    }

    protected String getElementName(Object o) {
        String name = this.node.getLocalName();
        name = name.endsWith("ies") ? name.replaceAll("ies$", "y") : name.replaceAll("s$", "");
        return name;
    }

    protected Object getElementValue(Object o) {
        return o;
    }

    protected Object getObject(Element childElement, boolean createIfNeeded) {
        if (this.elementType == null) {
            ListAdapter existing = (ListAdapter)((IDOMNode)childElement).getExistingAdapter(ListAdapter.class);
            if (existing == null) {
                ((IDOMNode)childElement).addAdapter((INodeAdapter)this);
            }
            return ListAdapter.getElementText(childElement);
        }
        ModelObjectAdapter existing = (ModelObjectAdapter)((IDOMNode)childElement).getExistingAdapter(ModelObjectAdapter.class);
        if (existing == null) {
            if (createIfNeeded) {
                EObject eo = PomFactory.eINSTANCE.create(this.elementType);
                existing = new ModelObjectAdapter(this.resource, eo, childElement);
                eo.eAdapters().add((Object)existing);
                ((IDOMNode)childElement).addAdapter((INodeAdapter)existing);
                existing.load();
                return eo;
            }
            return null;
        }
        return existing.getTarget();
    }

    public boolean isAdapterForType(Object type) {
        return ListAdapter.class.equals(type);
    }

    @Override
    public void load() {
        this.list.clear();
        NodeList children = this.node.getChildNodes();
        int nChildren = children.getLength();
        int i = 0;
        while (i < nChildren) {
            Node child = children.item(i);
            if (child instanceof Element) {
                this.list.add(this.getObject((Element)child, true));
            }
            ++i;
        }
    }

    @Override
    public void save() {
        for (Object o : this.list) {
            this.add(o, -1);
        }
    }
}

