/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.visitor;

import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceNode;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.core.compiler.ast.nodes.AnonymousClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ArrayCreation;
import org.eclipse.php.core.compiler.ast.nodes.ArrayVariableReference;
import org.eclipse.php.core.compiler.ast.nodes.BreakStatement;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.compiler.ast.nodes.ConstantDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ContinueStatement;
import org.eclipse.php.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.InfixExpression;
import org.eclipse.php.core.compiler.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.PHPFieldDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.Quote;
import org.eclipse.php.core.compiler.ast.nodes.ReflectionArrayVariableReference;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.core.compiler.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.compiler.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.TraitUseStatement;
import org.eclipse.php.core.compiler.ast.nodes.UnaryOperation;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.compiler.ast.nodes.VarComment;
import org.eclipse.php.core.compiler.ast.validator.IValidatorExtension;
import org.eclipse.php.core.compiler.ast.validator.IValidatorVisitor;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.core.util.INamespaceResolver;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.strategies.SimpleProposal;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.compiler.ast.parser.Messages;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPProblemIdentifier;
import org.eclipse.php.internal.core.language.PHPVariables;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPEvaluationUtils;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;

public class ValidatorVisitor
extends PHPASTVisitor
implements IValidatorVisitor {
    private static final String EXTENSION_POINT = "org.eclipse.php.core.validatorExtension";
    private static final String ATTR_CLASS = "class";
    private static final String EMPTY = "";
    private static final String PAAMAYIM_NEKUDOTAIM = "::";
    private static final String NAMESPACE_RESOLVER = "NAMESPACE_RESOLVER";
    private static final List<String> TYPE_SKIP = new ArrayList<String>();
    private static final List<String> COMMENT_TYPE_SKIP = new ArrayList<String>();
    private static final List<SimpleProposal> RESERVED_WORDS = new ArrayList<SimpleProposal>();
    private Map<String, UsePartInfo> usePartInfo = new LinkedHashMap<String, UsePartInfo>();
    private Map<String, Boolean> elementExists = new HashMap<String, Boolean>();
    private NamespaceDeclaration currentNamespace;
    private IPHPDocAwareDeclaration currentDeclaration;
    private Set<String> typeDeclared = new HashSet<String>();
    private ArrayList<VarComment> varComments = new ArrayList();
    private ArrayList<PHPDocBlock> docBlocks = new ArrayList();
    private boolean hasNamespace;
    private String expectedNamespace;
    private String expectedTypeName;
    private boolean isFirstType = true;
    private ISourceModule sourceModule;
    private PHPVersion version;
    private IBuildContext context;
    private IValidatorExtension[] extensions;
    private Deque<Map<String, ISourceNode>> declarationScope;
    private Deque<ISourceNode> typeDeclarations;
    private Stack<NamespaceDeclaration> fNamespaceDeclarations = new Stack();

    static {
        RESERVED_WORDS.add(new SimpleProposal("bool", PHPVersion.PHP7_0));
        RESERVED_WORDS.add(new SimpleProposal("float", PHPVersion.PHP7_0));
        RESERVED_WORDS.add(new SimpleProposal("int", PHPVersion.PHP7_0));
        RESERVED_WORDS.add(new SimpleProposal("string", PHPVersion.PHP7_0));
        RESERVED_WORDS.add(new SimpleProposal("iterable", PHPVersion.PHP7_1));
        RESERVED_WORDS.add(new SimpleProposal("object", PHPVersion.PHP7_2));
        RESERVED_WORDS.add(new SimpleProposal("self"));
        RESERVED_WORDS.add(new SimpleProposal("parent"));
        RESERVED_WORDS.add(new SimpleProposal("void", PHPVersion.PHP7_1));
        RESERVED_WORDS.add(new SimpleProposal("null", PHPVersion.PHP7_0));
        RESERVED_WORDS.add(new SimpleProposal("true", PHPVersion.PHP7_0));
        RESERVED_WORDS.add(new SimpleProposal("false", PHPVersion.PHP7_0));
        TYPE_SKIP.add("parent");
        TYPE_SKIP.add("self");
        TYPE_SKIP.add("static");
        TYPE_SKIP.add("null");
        COMMENT_TYPE_SKIP.add("true");
        COMMENT_TYPE_SKIP.add("false");
    }

    public ValidatorVisitor(IBuildContext context) {
        this.context = context;
        this.sourceModule = context.getSourceModule();
        this.version = ProjectOptions.getPHPVersion((IModelElement)this.sourceModule);
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        ArrayList<IValidatorExtension> list = new ArrayList<IValidatorExtension>(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            try {
                IValidatorExtension tmp;
                Object ext = el.createExecutableExtension(ATTR_CLASS);
                if (ext != null && ext instanceof IValidatorExtension && (tmp = (IValidatorExtension)ext).isSupported(context)) {
                    tmp.init(context, this);
                    list.add(tmp);
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        this.extensions = list.toArray(new IValidatorExtension[0]);
    }

    public boolean visit(ModuleDeclaration s) throws Exception {
        if (s instanceof PHPModuleDeclaration) {
            this.varComments.addAll(((PHPModuleDeclaration)s).getVarComments());
            this.docBlocks.addAll(((PHPModuleDeclaration)s).getPHPDocBlocks());
            this.declarationScope = new ArrayDeque<Map<String, ISourceNode>>();
            this.typeDeclarations = new ArrayDeque<ISourceNode>();
            this.typeDeclarations.addLast((ISourceNode)s);
            this.declarationScope.addLast(new HashMap());
        }
        boolean res = super.visit(s);
        INamespaceResolver resolver = (INamespaceResolver)this.context.get(NAMESPACE_RESOLVER);
        if (resolver == null) {
            resolver = PHPToolkitUtil.getNamespaceResolver(this.sourceModule.getScriptProject().getProject());
            this.context.set(NAMESPACE_RESOLVER, (Object)resolver);
        }
        this.expectedNamespace = resolver.resolveNamespace(this.sourceModule.getParent().getPath());
        this.expectedTypeName = PHPModelUtils.getTypeNameByFileName(this.sourceModule);
        return res;
    }

    public boolean endvisit(ModuleDeclaration s) throws Exception {
        boolean res = super.endvisit(s);
        if (!this.hasNamespace) {
            this.checkUnusedImport();
        }
        this.declarationScope = null;
        this.typeDeclarations = null;
        if (!this.expectedNamespace.equals(EMPTY) && !this.hasNamespace) {
            this.reportProblem(null, Messages.UnexpectedNamespaceDeclaration, (IProblemIdentifier)PHPProblemIdentifier.UnexpectedNamespaceDeclaration, new String[]{EMPTY, this.expectedNamespace}, ProblemSeverities.Warning);
        }
        return res;
    }

    @Override
    public boolean visit(NamespaceDeclaration s) throws Exception {
        this.currentDeclaration = s;
        this.hasNamespace = true;
        this.currentNamespace = s;
        this.fNamespaceDeclarations.push(s);
        this.checkReservedWord(s, "namespace");
        if (this.fNamespaceDeclarations.size() > 1) {
            this.reportProblem((ASTNode)s, Messages.NestedNamespaceDeclarations, PHPProblemIdentifier.NestedNamespaceDeclarations, ProblemSeverities.Error);
        }
        super.visit(s);
        if (!s.getName().equals(this.expectedNamespace)) {
            this.reportProblem((ASTNode)s.getRef(), Messages.UnexpectedNamespaceDeclaration, (IProblemIdentifier)PHPProblemIdentifier.UnexpectedNamespaceDeclaration, new String[]{s.getName(), this.expectedNamespace}, ProblemSeverities.Warning);
        }
        return true;
    }

    @Override
    public boolean endvisit(NamespaceDeclaration s) throws Exception {
        boolean res = super.endvisit(s);
        this.checkUnusedImport();
        this.fNamespaceDeclarations.pop();
        return res;
    }

    @Override
    public boolean visit(PHPMethodDeclaration s) throws Exception {
        this.currentDeclaration = s;
        if (s.getPHPDoc() != null) {
            s.getPHPDoc().traverse(this);
        }
        String id = "m" + s.getName().toLowerCase();
        Map<String, ISourceNode> childs = this.declarationScope.peekLast();
        ISourceNode parentType = this.typeDeclarations.peekLast();
        if (childs.containsKey(id) && !(parentType instanceof NamespaceDeclaration) && !(parentType instanceof IModuleDeclaration)) {
            this.reportProblem(s.getNameStart(), s.getNameEnd(), Messages.DuplicateMethodDeclaration, PHPProblemIdentifier.DuplicateMethodDeclaration, new String[]{s.getName()}, ProblemSeverities.Error);
        } else {
            childs.put(id, (ISourceNode)s);
        }
        return super.visit(s);
    }

    @Override
    public boolean visit(PHPFieldDeclaration s) throws Exception {
        this.currentDeclaration = s;
        if (s.getPHPDoc() != null) {
            s.getPHPDoc().traverse(this);
        }
        String id = "f" + s.getName();
        Map<String, ISourceNode> childs = this.declarationScope.peekLast();
        ISourceNode parentType = this.typeDeclarations.peekLast();
        if (childs.containsKey(id) && !(parentType instanceof NamespaceDeclaration) && !(parentType instanceof IModuleDeclaration)) {
            this.reportProblem(s.getNameStart(), s.getNameEnd(), Messages.DuplicateFieldDeclaration, PHPProblemIdentifier.DuplicateFieldDeclaration, new String[]{s.getName()}, ProblemSeverities.Error);
        } else {
            childs.put(id, (ISourceNode)s);
        }
        return super.visit(s);
    }

    @Override
    public boolean visit(PHPCallExpression node) throws Exception {
        if (node.getReceiver() != null) {
            node.getReceiver().traverse((ASTVisitor)this);
        }
        if (node.getArgs() != null) {
            node.getArgs().traverse((ASTVisitor)this);
        }
        super.visit(node);
        return false;
    }

    @Override
    public boolean visit(FullyQualifiedReference node) throws Exception {
        if (node.getElementType() == 1) {
            return this.visit((TypeReference)node);
        }
        this.visit(node.getNamespace(), ProblemSeverities.Error, false);
        return super.visit(node);
    }

    @Override
    public boolean visit(TypeReference node) throws Exception {
        return this.visit(node, ProblemSeverities.Error, false);
    }

    private boolean visit(TypeReference node, ProblemSeverity severity, boolean isInDoc) throws Exception {
        boolean isFound;
        boolean skip = false;
        skip = isInDoc ? PHPSimpleTypes.isSimpleType(node.getName()) : PHPSimpleTypes.isHintable(node.getName(), this.version);
        if (skip || TYPE_SKIP.contains(node.getName().toLowerCase())) {
            super.visit(node);
            return true;
        }
        TypeReferenceInfo tri = new TypeReferenceInfo(node, false);
        String nodeName = tri.getTypeName();
        String key = null;
        key = this.getFirstSegmentOfTypeName(nodeName);
        UsePartInfo info = this.usePartInfo.get(key.toLowerCase());
        if (info != null) {
            info.increaseRefCount();
        }
        if (!(isFound = this.findElement(tri))) {
            this.reportProblem((ASTNode)node, Messages.UndefinedType, (IProblemIdentifier)PHPProblemIdentifier.UndefinedType, node.getName(), severity);
        }
        super.visit(node);
        return false;
    }

    @Override
    public boolean visit(AnonymousClassDeclaration s) throws Exception {
        List<TypeReference> interfaces;
        int end = s.start();
        int start = end - 1;
        this.declarationScope.addLast(new HashMap());
        this.typeDeclarations.addLast((ISourceNode)s);
        while (this.sourceModule.getSource().charAt(start) != ' ') {
            --start;
        }
        this.checkUnimplementedMethods((Statement)s, start + 1, end);
        IModelElement element = this.sourceModule.getElementAt(s.start());
        if (s.getSuperClass() != null && element != null) {
            this.checkSuperclass(s.getSuperClass(), false, element.getElementName());
        }
        if ((interfaces = s.getInterfaceList()) != null && element != null) {
            for (TypeReference itf : interfaces) {
                this.checkSuperclass(itf, true, element.getElementName());
            }
        }
        return super.visit(s);
    }

    @Override
    public boolean endvisit(AnonymousClassDeclaration s) throws Exception {
        this.declarationScope.pollLast();
        this.typeDeclarations.pollLast();
        return super.endvisit(s);
    }

    @Override
    public boolean visit(ClassDeclaration s) throws Exception {
        Collection<TypeReference> interfaces;
        this.currentDeclaration = s;
        this.checkReservedWord(s, ATTR_CLASS);
        this.checkUnimplementedMethods((Statement)s, (ASTNode)s.getRef());
        if (s.getSuperClass() != null) {
            this.checkSuperclass(s.getSuperClass(), false, s.getName());
        }
        if ((interfaces = s.getInterfaceList()) != null && interfaces.size() > 0) {
            for (TypeReference itf : interfaces) {
                this.checkSuperclass(itf, true, s.getName());
            }
        }
        return super.visit(s);
    }

    @Override
    public boolean visit(ClassInstanceCreation s) throws Exception {
        if (s.getClassName() instanceof TypeReference) {
            IType[] types;
            TypeReferenceInfo tri = new TypeReferenceInfo((TypeReference)s.getClassName(), false);
            IType[] iTypeArray = types = this.getAllTypes(tri.getFullyQualifiedName(), this.sourceModule, s.getClassName().sourceStart());
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (PHPFlags.isTrait(type.getFlags()) || PHPFlags.isInterface((int)type.getFlags()) || PHPFlags.isAbstract((int)type.getFlags())) {
                    this.reportProblem((ASTNode)s.getClassName(), Messages.CannotInstantiateType, (IProblemIdentifier)PHPProblemIdentifier.CannotInstantiateType, type.getElementName(), ProblemSeverities.Error);
                    break;
                }
                ++n2;
            }
        }
        return super.visit(s);
    }

    @Override
    public boolean visit(InterfaceDeclaration s) throws Exception {
        this.currentDeclaration = s;
        this.checkReservedWord(s, "interface");
        if (s.getSuperClasses() == null) {
            return super.visit(s);
        }
        for (ASTNode node : s.getSuperClasses().getChilds()) {
            this.checkSuperclass((TypeReference)node, true, s.getName());
        }
        return super.visit(s);
    }

    @Override
    public boolean visit(TypeDeclaration s) throws Exception {
        this.declarationScope.addLast(new HashMap());
        this.typeDeclarations.addLast((ISourceNode)s);
        if (s instanceof TraitDeclaration) {
            this.checkReservedWord(s, "trait");
        }
        if (!(s instanceof NamespaceDeclaration)) {
            this.checkDuplicateTypeDeclaration(s);
            if (this.isFirstType) {
                this.checkTypeName(s);
                this.isFirstType = false;
            }
        }
        return super.visit(s);
    }

    @Override
    public boolean endvisit(TypeDeclaration s) throws Exception {
        this.declarationScope.pollLast();
        this.typeDeclarations.pollLast();
        return super.endvisit(s);
    }

    @Override
    public boolean visit(UsePart part) throws Exception {
        int elementType;
        UsePartInfo info = new UsePartInfo(part);
        TypeReferenceInfo tri = info.getTypeReferenceInfo();
        if (tri.getTypeReference() instanceof FullyQualifiedReference && ((elementType = ((FullyQualifiedReference)tri.getTypeReference()).getElementType()) == 3 || elementType == 2)) {
            super.visit(part);
            return false;
        }
        String name = tri.getTypeName();
        String currentNamespaceName = this.currentNamespace == null ? EMPTY : this.addLeadingSeparator(this.currentNamespace.getName());
        String lcName = info.getRealName().toLowerCase();
        if (!this.findElement(tri)) {
            info.isProblemReported = true;
            this.reportProblem((ASTNode)tri.getTypeReference(), Messages.ImportNotFound, (IProblemIdentifier)PHPProblemIdentifier.ImportNotFound, name, ProblemSeverities.Error);
        } else if (this.usePartInfo.get(lcName) != null) {
            info.isProblemReported = true;
            this.reportProblem((ASTNode)tri.getTypeReference(), Messages.DuplicateImport, (IProblemIdentifier)PHPProblemIdentifier.DuplicateImport, new String[]{name, info.getRealName()}, ProblemSeverities.Error);
        } else if (!info.isAlias && info.getNamespaceName().equals(currentNamespaceName)) {
            info.isProblemReported = true;
            this.reportProblem((ASTNode)tri.getTypeReference(), Messages.UnnecessaryImport, (IProblemIdentifier)PHPProblemIdentifier.UnnecessaryImport, new String[]{name}, ProblemSeverities.Warning);
        }
        this.usePartInfo.put(lcName, info);
        super.visit(part);
        return false;
    }

    @Override
    public boolean visit(TraitUseStatement s) throws Exception {
        List<TypeReference> traits = s.getTraitList();
        block0: for (TypeReference trait : traits) {
            IType[] types;
            TypeReferenceInfo tri = new TypeReferenceInfo(trait, false);
            IType[] iTypeArray = types = this.getAllTypes(tri.getFullyQualifiedName(), this.sourceModule, trait.start());
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (!PHPFlags.isTrait(type.getFlags())) {
                    this.reportProblem((ASTNode)trait, Messages.CannotUseTypeAsTrait, (IProblemIdentifier)PHPProblemIdentifier.CannotUseTypeAsTrait, new String[]{trait.getName()}, ProblemSeverities.Error);
                    continue block0;
                }
                ++n2;
            }
        }
        return super.visit(s);
    }

    private void visitCommentType(TypeReference typeReference, ProblemSeverity severity) throws Exception {
        if (COMMENT_TYPE_SKIP.contains(typeReference.getName().toLowerCase())) {
            return;
        }
        String name = typeReference.getName();
        assert (name.length() > 0);
        int idx = name.indexOf(PAAMAYIM_NEKUDOTAIM);
        if (idx == -1) {
            if (PHPTextSequenceUtilities.readIdentifierStartIndex(this.version, name, name.length(), false) == 0) {
                this.visit(typeReference, severity, true);
            }
        } else if (idx > 0 && PHPTextSequenceUtilities.readIdentifierStartIndex(this.version, name, idx, false) == 0) {
            this.visit(new TypeReference(typeReference.start(), typeReference.start() + idx, name.substring(0, idx)), severity, true);
        }
    }

    private void visitCommentTypes(TypeReference fullTypeReference) throws Exception {
        TypeReference typeReference;
        String typeName;
        String fullTypeName = fullTypeReference.getName();
        Matcher matcher = PHPEvaluationUtils.TYPE_DELIMS_PATTERN.matcher(fullTypeName);
        int start = 0;
        while (matcher.find()) {
            if (matcher.start() != start) {
                typeName = fullTypeName.substring(start, matcher.start());
                typeReference = new TypeReference(fullTypeReference.start() + start, fullTypeReference.start() + start + typeName.length(), typeName);
                this.visitCommentType(typeReference, ProblemSeverities.Warning);
            }
            start = matcher.end();
        }
        if (start == 0) {
            this.visitCommentType(fullTypeReference, ProblemSeverities.Warning);
        } else if (start != fullTypeName.length()) {
            typeName = fullTypeName.substring(start);
            typeReference = new TypeReference(fullTypeReference.start() + start, fullTypeReference.start() + start + typeName.length(), typeName);
            this.visitCommentType(typeReference, ProblemSeverities.Warning);
        }
    }

    @Override
    public boolean visit(PHPDocTag phpDocTag) throws Exception {
        for (TypeReference fullTypeReference : phpDocTag.getTypeReferences()) {
            this.visitCommentTypes(fullTypeReference);
        }
        super.visit(phpDocTag);
        return false;
    }

    private boolean visitVarTags(PHPDocBlock s) throws Exception {
        PHPDocTag[] pHPDocTagArray = s.getTags(PHPDocTag.TagKind.VAR);
        int n = pHPDocTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPDocTag phpDocTag = pHPDocTagArray[n2];
            this.visit(phpDocTag);
            ++n2;
        }
        return false;
    }

    private boolean visit(VarComment varComment) throws Exception {
        TypeReference[] typeReferenceArray = varComment.getTypeReferences();
        int n = typeReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference fullTypeReference = typeReferenceArray[n2];
            this.visitCommentTypes(fullTypeReference);
            ++n2;
        }
        super.visit(varComment);
        return false;
    }

    private void checkVarComment(VariableReference s) throws Exception {
        int minPos = this.currentNamespace != null ? this.currentNamespace.sourceStart() : 0;
        int maxPos = s.sourceStart();
        Iterator<VarComment> itr = this.varComments.iterator();
        while (itr.hasNext()) {
            VarComment varComment = itr.next();
            if (varComment.sourceStart() < minPos) {
                itr.remove();
                continue;
            }
            if (varComment.sourceEnd() > maxPos) break;
            this.visit(varComment);
            itr.remove();
        }
        if (this.currentDeclaration instanceof ASTNode) {
            minPos = Math.max(minPos, ((ASTNode)this.currentDeclaration).sourceStart());
        }
        Iterator<PHPDocBlock> itr2 = this.docBlocks.iterator();
        while (itr2.hasNext()) {
            PHPDocBlock docBlock = itr2.next();
            if (docBlock.sourceStart() < minPos) {
                itr2.remove();
                continue;
            }
            if (docBlock.sourceEnd() > maxPos) break;
            this.visitVarTags(docBlock);
            itr2.remove();
        }
    }

    @Override
    public boolean visit(VariableReference s) throws Exception {
        this.checkVarComment(s);
        return super.visit(s);
    }

    @Override
    public boolean visit(ArrayVariableReference s) throws Exception {
        this.checkVarComment(s);
        return super.visit(s);
    }

    private void checkTypeName(TypeDeclaration s) {
        if (!s.getName().equals(this.expectedTypeName)) {
            String type = null;
            if (s instanceof ClassDeclaration) {
                type = ATTR_CLASS;
            } else if (s instanceof InterfaceDeclaration) {
                type = "interface";
            } else if (s instanceof TraitDeclaration) {
                type = "trait";
            }
            this.reportProblem((ASTNode)s.getRef(), Messages.FirstTypeMustMatchFileName, (IProblemIdentifier)PHPProblemIdentifier.FirstClassMustMatchFileName, new String[]{type, s.getName(), this.expectedTypeName}, ProblemSeverities.Error);
        }
    }

    private void checkDuplicateTypeDeclaration(TypeDeclaration node) {
        String name = node.getName();
        String currentNamespaceName = this.currentNamespace == null || this.currentNamespace.isGlobal() ? EMPTY : this.currentNamespace.getName();
        boolean isDuplicateWithUse = false;
        UsePartInfo info = this.usePartInfo.get(name.toLowerCase());
        if (info != null) {
            String fullyQualifiedName = PHPModelUtils.concatFullyQualifiedNames("\\", currentNamespaceName, name);
            if (!info.getFullyQualifiedName().equals(fullyQualifiedName)) {
                isDuplicateWithUse = true;
            }
        }
        if (isDuplicateWithUse || !this.typeDeclared.add(name.toLowerCase())) {
            this.reportProblem((ASTNode)node.getRef(), Messages.DuplicateDeclaration, (IProblemIdentifier)PHPProblemIdentifier.DuplicateDeclaration, name, ProblemSeverities.Error);
        }
    }

    private void checkUnimplementedMethods(Statement statement, ASTNode classNode) throws ModelException {
        this.checkUnimplementedMethods(statement, classNode.sourceStart(), classNode.sourceEnd());
    }

    private void checkReservedWord(TypeDeclaration declaration, String nodeTypeMessage) throws ModelException {
        String name = declaration.getName();
        if (name == null || name.length() == 0) {
            return;
        }
        for (SimpleProposal proposal : RESERVED_WORDS) {
            if (!proposal.isValid(name.toLowerCase(), this.version)) continue;
            this.reportProblem(declaration.getNameStart(), declaration.getNameEnd(), Messages.CannotUseReservedWord, PHPProblemIdentifier.CannotUseReservedWord, new String[]{name, nodeTypeMessage}, ProblemSeverities.Error);
            break;
        }
    }

    private void checkUnimplementedMethods(Statement statement, int nodeStart, int nodeEnd) throws ModelException {
        IModelElement element = this.sourceModule.getElementAt(statement.start());
        if (!(element instanceof IType)) {
            return;
        }
        IType type = (IType)element;
        if (type.getSuperClasses().length > 0 && !PHPFlags.isAbstract((int)type.getFlags())) {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = PHPModelUtils.getUnimplementedMethods(type, null);
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (!method.getParent().getElementName().equals(type.getElementName())) {
                    StringBuilder methodName = new StringBuilder(method.getParent().getElementName()).append(PAAMAYIM_NEKUDOTAIM);
                    PHPModelUtils.getMethodLabel(method, methodName);
                    String message = Messages.getString("AbstractMethodMustBeImplemented", type.getElementName(), methodName.toString());
                    this.reportProblem(nodeStart, nodeEnd, message, PHPProblemIdentifier.AbstractMethodMustBeImplemented, ProblemSeverities.Error);
                }
                ++n2;
            }
        }
    }

    private void checkSuperclass(TypeReference superClass, boolean isInterface, String className) throws ModelException {
        if (superClass != null) {
            IType[] types;
            TypeReferenceInfo refInfo = new TypeReferenceInfo(superClass, false);
            IType[] iTypeArray = types = this.getAllTypes(refInfo.getFullyQualifiedName(), this.sourceModule, superClass.sourceStart());
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (!isInterface) {
                    if (PHPFlags.isTrait(type.getFlags()) || PHPFlags.isInterface((int)type.getFlags())) {
                        this.reportProblem((ASTNode)superClass, Messages.SuperclassMustBeAClass, (IProblemIdentifier)PHPProblemIdentifier.SuperclassMustBeAClass, new String[]{superClass.getName(), className}, ProblemSeverities.Error);
                    }
                    if (PHPFlags.isFinal((int)type.getFlags())) {
                        this.reportProblem((ASTNode)superClass, Messages.ClassExtendFinalClass, (IProblemIdentifier)PHPProblemIdentifier.ClassExtendFinalClass, new String[]{className, type.getElementName()}, ProblemSeverities.Error);
                    }
                } else if (PHPFlags.isTrait(type.getFlags()) || !PHPFlags.isInterface((int)type.getFlags())) {
                    this.reportProblem((ASTNode)superClass, Messages.SuperInterfaceMustBeAnInterface, (IProblemIdentifier)PHPProblemIdentifier.SuperInterfaceMustBeAnInterface, new String[]{superClass.getName(), className}, ProblemSeverities.Error);
                }
                ++n2;
            }
        }
    }

    private void checkUnusedImport() {
        Collection<UsePartInfo> useInfos = this.usePartInfo.values();
        for (UsePartInfo useInfo : useInfos) {
            if (useInfo.isProblemReported || useInfo.getRefCount() != 0) continue;
            FullyQualifiedReference m = useInfo.getUsePart().getNamespace();
            String name = useInfo.getUsePart().getFullUseStatementName();
            this.reportProblem((ASTNode)m, Messages.UnusedImport, (IProblemIdentifier)PHPProblemIdentifier.UnusedImport, name, ProblemSeverities.Warning);
        }
        this.usePartInfo.clear();
        this.elementExists.clear();
        this.typeDeclared.clear();
    }

    private boolean findElement(TypeReferenceInfo info) {
        String name = info.getFullyQualifiedName();
        if (this.elementExists.containsKey(name)) {
            return this.elementExists.get(name);
        }
        boolean isFound = false;
        try {
            TypeReference type = info.getTypeReference();
            int elementType = 1;
            if (type instanceof FullyQualifiedReference) {
                elementType = ((FullyQualifiedReference)type).getElementType();
            }
            switch (elementType) {
                case 1: {
                    IType[] elements = PHPModelUtils.getTypes(name, this.sourceModule, type.start(), null);
                    if (elements.length == 0) {
                        elements = PHPModelUtils.getTraits(name, this.sourceModule, type.start(), null, null);
                    }
                    if (elements.length == 0 && info.isUseStatement() && (elements = this.sourceModule.codeSelect(type.start(), type.end() - type.start())).length == 0) {
                        IType[] namespaces;
                        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)this.sourceModule.getScriptProject());
                        IType[] iTypeArray = namespaces = PHPModelAccess.getDefault().findNamespaces(null, info.getTypeName(), ISearchEngine.MatchRule.PREFIX, 0, 0, scope, null);
                        int n = namespaces.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType namespace = iTypeArray[n2];
                            String namespaceName = namespace.getElementName();
                            String typeName = info.getTypeName();
                            if (namespaceName.length() > typeName.length() && namespaceName.charAt(typeName.length()) == '\\') {
                                isFound = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (elements.length > 0) {
                        isFound = true;
                    }
                    break;
                }
                case 2: 
                case 3: {
                    isFound = true;
                    break;
                }
                default: {
                    isFound = false;
                    break;
                }
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        this.elementExists.put(name, isFound);
        return isFound;
    }

    private void reportProblem(int start, int end, String message, IProblemIdentifier id, String[] stringArguments, ProblemSeverity severity) {
        message = MessageFormat.format(message, stringArguments);
        this.reportProblem(start, end, message, id, severity);
    }

    private void reportProblem(ASTNode s, String message, IProblemIdentifier id, String[] stringArguments, ProblemSeverity severity) {
        message = MessageFormat.format(message, stringArguments);
        this.reportProblem(s, message, id, severity);
    }

    @Override
    public void reportProblem(ASTNode s, String message, IProblemIdentifier id, ProblemSeverity severity) {
        IValidatorExtension[] iValidatorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IValidatorExtension extension = iValidatorExtensionArray[n2];
            if (extension.skipProblem(s, message, id)) {
                return;
            }
            ++n2;
        }
        int start = 0;
        int end = 0;
        if (s != null) {
            start = s.sourceStart();
            end = s.sourceEnd();
        } else {
            start = end = this.context.getLineTracker().getLineOffset(1);
        }
        this.reportProblem(start, end, message, id, severity);
    }

    private void reportProblem(ASTNode s, String message, IProblemIdentifier id, String stringArguments, ProblemSeverity severity) {
        this.reportProblem(s, message, id, new String[]{stringArguments}, severity);
    }

    @Override
    public void reportProblem(int start, int end, String message, IProblemIdentifier id, ProblemSeverity severity) {
        IValidatorExtension[] iValidatorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IValidatorExtension extension = iValidatorExtensionArray[n2];
            if (extension.skipProblem(start, end, message, id)) {
                return;
            }
            ++n2;
        }
        ISourceLineTracker tracker = this.context.getLineTracker();
        int line = tracker.getLineNumberOfOffset(start);
        DefaultProblem problem = new DefaultProblem(this.context.getFile().getName(), message, id, null, severity, start, end, line, 0);
        this.context.getProblemReporter().reportProblem((IProblem)problem);
    }

    private String getFirstSegmentOfTypeName(String typeName) {
        if (typeName != null) {
            String[] segments;
            String[] stringArray = segments = typeName.split("\\\\");
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (segment.trim().length() > 0) {
                    return segment;
                }
                ++n2;
            }
        }
        return EMPTY;
    }

    private IType[] getAllTypes(String typeName, ISourceModule sourceModule, int offset) {
        try {
            ArrayList<IType> lists = new ArrayList<IType>();
            IType[] types = PHPModelUtils.getTypes(typeName, sourceModule, offset, null);
            lists.addAll(Arrays.asList(types));
            types = PHPModelUtils.getTraits(typeName, sourceModule, offset, null, null);
            lists.addAll(Arrays.asList(types));
            return lists.toArray(new IType[0]);
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
            return new IType[0];
        }
    }

    @Override
    public boolean visit(ConstantDeclaration s) throws Exception {
        this.currentDeclaration = s;
        this.validateConstantExpression((ASTNode)s.getConstantValue(), false);
        String id = "c" + s.getName();
        Map<String, ISourceNode> childs = this.declarationScope.peekLast();
        if (childs.containsKey(id)) {
            this.reportProblem((ASTNode)s.getConstantName(), Messages.DuplicateConstantDeclaration, (IProblemIdentifier)PHPProblemIdentifier.DuplicateConstantDeclaration, new String[]{s.getName()}, ProblemSeverities.Error);
        } else {
            childs.put(id, (ISourceNode)s.getConstantName());
        }
        return super.visit(s);
    }

    @Override
    public boolean visit(FormalParameter s) throws Exception {
        this.validateConstantExpression(s.getInitialization(), true);
        if (this.version.isGreaterThan(PHPVersion.PHP5_3) && s.getParameterName() != null && PHPVariables.isVariable(s.getParameterName().getName(), this.version)) {
            this.reportProblem((ASTNode)s.getParameterName(), Messages.ReassignAutoGlobalVariable, (IProblemIdentifier)PHPProblemIdentifier.ReassignAutoGlobalVariable, s.getParameterName().getName(), ProblemSeverities.Error);
        }
        return super.visit(s);
    }

    @Override
    public boolean endvisit(PHPFieldDeclaration s) throws Exception {
        this.validateConstantExpression((ASTNode)s.getVariableValue(), true);
        return super.endvisit(s);
    }

    private void validateConstantExpression(ASTNode astNode, boolean allowArray) {
        if (astNode == null || astNode instanceof Scalar || astNode instanceof ConstantReference) {
            return;
        }
        if (astNode instanceof FullyQualifiedReference && ((FullyQualifiedReference)astNode).getElementType() == 3) {
            return;
        }
        if (astNode instanceof Quote) {
            for (ASTNode aSTNode : ((Quote)astNode).getExpressions()) {
                this.validateConstantExpression(aSTNode, allowArray);
            }
        } else if (astNode instanceof UnaryOperation) {
            UnaryOperation unaryOperation = (UnaryOperation)astNode;
            if (this.version.isLessThan(PHPVersion.PHP5_6) && unaryOperation.getOperatorType() != 1 && unaryOperation.getOperatorType() != 0) {
                this.reportProblem(astNode, Messages.InvalidConstantExpression, PHPProblemIdentifier.InvalidConstantExpression, ProblemSeverities.Error);
            } else {
                this.validateConstantExpression((ASTNode)unaryOperation.getExpr(), allowArray);
            }
        } else if (astNode instanceof StaticConstantAccess) {
            StaticConstantAccess staticConstantAccess = (StaticConstantAccess)astNode;
            if (!(staticConstantAccess.getDispatcher() instanceof FullyQualifiedReference)) {
                this.reportProblem((ASTNode)staticConstantAccess.getDispatcher(), Messages.DynamicClassNotAllowed, PHPProblemIdentifier.InvalidConstantExpression, ProblemSeverities.Error);
            }
        } else if (this.version.isGreaterThan(PHPVersion.PHP5_5) && astNode instanceof InfixExpression) {
            InfixExpression infixExpression = (InfixExpression)astNode;
            this.validateConstantExpression((ASTNode)infixExpression.getLeft(), allowArray);
            this.validateConstantExpression((ASTNode)infixExpression.getRight(), allowArray);
        } else if ((allowArray || this.version.isGreaterThan(PHPVersion.PHP5_5)) && astNode instanceof ArrayCreation) {
            ((ArrayCreation)astNode).getElements().stream().forEach(n -> {
                this.validateConstantExpression((ASTNode)n.getKey(), allowArray);
                this.validateConstantExpression((ASTNode)n.getValue(), allowArray);
            });
        } else if (this.version.isGreaterThan(PHPVersion.PHP5_5) && astNode instanceof ReflectionArrayVariableReference) {
            ReflectionArrayVariableReference reflectionArrayVariableReference = (ReflectionArrayVariableReference)astNode;
            this.validateConstantExpression((ASTNode)reflectionArrayVariableReference.getExpression(), allowArray);
            this.validateConstantExpression((ASTNode)reflectionArrayVariableReference.getIndex(), allowArray);
        } else {
            this.reportProblem(astNode, Messages.InvalidConstantExpression, PHPProblemIdentifier.InvalidConstantExpression, ProblemSeverities.Error);
        }
    }

    @Override
    public boolean visit(BreakStatement s) throws Exception {
        this.validatePositiveConstantInteger(s.getExpr(), "break");
        return true;
    }

    @Override
    public boolean visit(ContinueStatement s) throws Exception {
        this.validatePositiveConstantInteger(s.getExpr(), "continue");
        return true;
    }

    private void validatePositiveConstantInteger(Expression expr, String operator) {
        if (expr == null || this.version.isLessThan(PHPVersion.PHP5_4)) {
            return;
        }
        if (!(expr instanceof Scalar)) {
            this.reportProblem((ASTNode)expr, NLS.bind((String)Messages.UsupportedNonConstantOperand, (Object)operator), PHPProblemIdentifier.SYNTAX, ProblemSeverities.Error);
            return;
        }
        Scalar sc = (Scalar)expr;
        if (sc.getScalarType() != 0 || Integer.parseInt(sc.getValue()) < 1) {
            this.reportProblem((ASTNode)expr, NLS.bind((String)Messages.OperatorAcceptOnlyPositiveNumbers, (Object)operator), PHPProblemIdentifier.SYNTAX, ProblemSeverities.Error);
        }
    }

    @NonNull
    private String addLeadingSeparator(@NonNull String fullyQualifiedName) {
        if (fullyQualifiedName.length() > 0 && fullyQualifiedName.charAt(0) != '\\') {
            fullyQualifiedName = String.valueOf('\\') + fullyQualifiedName;
        }
        return fullyQualifiedName;
    }

    private Indentation getTextIndentation(char[] text, int start, int length) {
        Indentation indentation = new Indentation();
        int i = start;
        int max = start + length;
        block4: while (i < max) {
            switch (text[i]) {
                case ' ': {
                    indentation.flags |= 1;
                    break;
                }
                case '\t': {
                    indentation.flags |= 2;
                    break;
                }
                default: {
                    break block4;
                }
            }
            ++i;
        }
        indentation.value = new String(text, start, i - start);
        return indentation;
    }

    private void checkHeredocIndentations(Quote quote) {
        boolean hasHeredocTab;
        int heredocIndentationLength = quote.getInnerIndentation().length();
        if (heredocIndentationLength == 0) {
            return;
        }
        boolean hasHeredocSpace = quote.getInnerIndentation().indexOf(32) != -1;
        boolean bl = hasHeredocTab = quote.getInnerIndentation().indexOf(9) != -1;
        assert (this.getTextIndentation((char[])quote.getInnerIndentation().toCharArray(), (int)0, (int)heredocIndentationLength).value.length() == heredocIndentationLength);
        assert (hasHeredocSpace || hasHeredocTab);
        if (hasHeredocSpace && hasHeredocTab) {
            int lastLineOffset = this.context.getLineTracker().getLineInformationOfOffset(quote.end()).getOffset();
            this.reportProblem(lastLineOffset, lastLineOffset + heredocIndentationLength, Messages.HeredocMixedIndentation, PHPProblemIdentifier.SYNTAX, ProblemSeverities.Error);
            return;
        }
        int currentLine = this.context.getLineTracker().getLineNumberOfOffset(quote.start()) + 1;
        int lastLine = this.context.getLineTracker().getLineNumberOfOffset(quote.end()) - 1;
        while (currentLine <= lastLine) {
            int currentLineOffset = this.context.getLineTracker().getLineOffset(currentLine);
            int currentLineLength = this.context.getLineTracker().getLineLength(currentLine);
            int maxCheckIndentationLength = Math.min(currentLineLength, heredocIndentationLength);
            Indentation currentLineIndentation = this.getTextIndentation(this.context.getContents(), currentLineOffset, maxCheckIndentationLength);
            if (hasHeredocSpace && (currentLineIndentation.flags & 2) == 2 || hasHeredocTab && (currentLineIndentation.flags & 1) == 1) {
                this.reportProblem(currentLineOffset, currentLineOffset + currentLineIndentation.value.length(), Messages.HeredocMixedIndentation, PHPProblemIdentifier.SYNTAX, ProblemSeverities.Error);
            } else if (!currentLineIndentation.value.startsWith(quote.getInnerIndentation())) {
                this.reportProblem(currentLineOffset, currentLineOffset + currentLineIndentation.value.length(), MessageFormat.format(Messages.HeredocInvalidIndentation, heredocIndentationLength), PHPProblemIdentifier.SYNTAX, ProblemSeverities.Error);
            }
            ++currentLine;
        }
    }

    @Override
    public boolean endvisit(Quote quote) throws Exception {
        if (this.version.isGreaterThan(PHPVersion.PHP7_2) && (quote.getQuoteType() == 2 || quote.getQuoteType() == 3)) {
            this.checkHeredocIndentations(quote);
        }
        return super.endvisit(quote);
    }

    public boolean visitGeneral(ASTNode node) throws Exception {
        IValidatorExtension[] iValidatorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IValidatorExtension extension = iValidatorExtensionArray[n2];
            extension.visit(node);
            ++n2;
        }
        return true;
    }

    public void endvisitGeneral(ASTNode node) throws Exception {
        IValidatorExtension[] iValidatorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IValidatorExtension extension = iValidatorExtensionArray[n2];
            extension.endvisit(node);
            ++n2;
        }
    }

    @Override
    public UsePartInfo getUsePartInfo(String name) {
        return this.usePartInfo.get(name);
    }

    @Override
    public boolean hasNamespace() {
        return this.hasNamespace;
    }

    @Override
    public NamespaceDeclaration getCurrentNamespace() {
        return this.currentNamespace;
    }

    @Override
    public PHPVersion getPHPVersion() {
        return this.version;
    }

    private static class Indentation {
        private static final int HAS_SPACE = 1;
        private static final int HAS_TAB = 2;
        private int flags = 0;
        private String value = "";

        private Indentation() {
        }
    }

    private class TypeReferenceInfo
    implements IValidatorVisitor.ITypeReferenceInfo {
        private TypeReference typeReference;
        private boolean isGlobal = false;
        private boolean hasNamespace = false;
        private String namespaceName = "";
        private String typeName;
        private String fullyQualifiedName;
        private boolean isUseStatement;

        public TypeReferenceInfo(TypeReference typeReference, boolean isUseStatement) {
            this.typeReference = typeReference;
            this.isUseStatement = isUseStatement;
            this.typeName = typeReference.getName();
            FullyQualifiedReference fullTypeReference = null;
            if (typeReference instanceof FullyQualifiedReference) {
                fullTypeReference = (FullyQualifiedReference)typeReference;
                if (fullTypeReference.getNamespace() != null) {
                    if (!fullTypeReference.getNamespace().isLocal()) {
                        String[] segments;
                        UsePartInfo info;
                        this.hasNamespace = true;
                        this.isGlobal = fullTypeReference.getNamespace().isGlobal();
                        this.namespaceName = fullTypeReference.getNamespace().getName();
                        this.typeName = fullTypeReference.getFullyQualifiedName();
                        if (!isUseStatement && !this.isGlobal && (info = ValidatorVisitor.this.usePartInfo.get((segments = this.namespaceName.split("\\\\", 2))[0].toLowerCase())) != null) {
                            String restSegs = ValidatorVisitor.EMPTY;
                            if (segments.length > 1) {
                                restSegs = segments[1];
                            }
                            this.namespaceName = PHPModelUtils.concatFullyQualifiedNames(info.getFullyQualifiedName(), restSegs);
                        }
                        if (isUseStatement) {
                            this.isGlobal = true;
                            this.namespaceName = ValidatorVisitor.this.addLeadingSeparator(this.namespaceName);
                        }
                    }
                } else if (isUseStatement) {
                    this.isGlobal = true;
                }
            } else {
                this.isGlobal = this.typeName.startsWith("\\");
            }
            this.fullyQualifiedName = this.isGlobal ? ValidatorVisitor.this.addLeadingSeparator(this.typeName) : (this.hasNamespace ? PHPModelUtils.concatFullyQualifiedNames(this.namespaceName, typeReference.getName()) : this.typeName);
            if (!this.fullyQualifiedName.startsWith("\\")) {
                String key = ValidatorVisitor.this.getFirstSegmentOfTypeName(this.fullyQualifiedName).toLowerCase();
                if (ValidatorVisitor.this.usePartInfo.containsKey(key)) {
                    this.fullyQualifiedName = ValidatorVisitor.this.usePartInfo.get(key).getFullyQualifiedName();
                } else if (ValidatorVisitor.this.currentNamespace != null && !ValidatorVisitor.this.currentNamespace.isGlobal()) {
                    this.fullyQualifiedName = PHPModelUtils.concatFullyQualifiedNames(ValidatorVisitor.this.currentNamespace.getName(), this.fullyQualifiedName);
                }
                this.fullyQualifiedName = ValidatorVisitor.this.addLeadingSeparator(this.fullyQualifiedName);
            }
        }

        @Override
        public boolean isGlobal() {
            return this.isGlobal;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public String getNamespaceName() {
            return this.namespaceName;
        }

        @Override
        public TypeReference getTypeReference() {
            return this.typeReference;
        }

        @Override
        public boolean isUseStatement() {
            return this.isUseStatement;
        }
    }

    private class UsePartInfo
    implements IValidatorVisitor.IUsePartInfo {
        private UsePart usePart;
        private String realName;
        private int refCount;
        private String fullyQualifiedName;
        private TypeReferenceInfo tri;
        private boolean isAlias = false;
        private boolean isProblemReported = false;

        public UsePartInfo(UsePart usePart) {
            this.usePart = usePart;
            this.tri = usePart.getGroupNamespace() == null ? new TypeReferenceInfo(usePart.getNamespace(), true) : new TypeReferenceInfo(ASTUtils.createFakeGroupUseType(usePart), true);
            if (usePart.getAlias() != null) {
                this.realName = usePart.getAlias().getName();
                this.isAlias = true;
            } else {
                this.realName = usePart.getNamespace().getName();
            }
            if (this.tri.getNamespaceName() != null) {
                this.fullyQualifiedName = this.tri.getNamespaceName();
            }
            this.fullyQualifiedName = ValidatorVisitor.this.addLeadingSeparator(PHPModelUtils.concatFullyQualifiedNames(this.fullyQualifiedName, usePart.getNamespace().getName()));
        }

        @Override
        public UsePart getUsePart() {
            return this.usePart;
        }

        @Override
        public int getRefCount() {
            return this.refCount;
        }

        @Override
        public void increaseRefCount() {
            ++this.refCount;
        }

        @Override
        public String getRealName() {
            return this.realName;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        @Override
        public String getNamespaceName() {
            return this.tri.getNamespaceName();
        }

        @Override
        public TypeReferenceInfo getTypeReferenceInfo() {
            return this.tri;
        }

        @Override
        public boolean isAlias() {
            return this.isAlias;
        }

        public String toString() {
            String str = "use " + this.fullyQualifiedName;
            if (this.isAlias) {
                str = String.valueOf(str) + " as " + this.realName;
            }
            return str;
        }
    }
}

