/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.ui.actions.OrganizeUseStatementsAction;
import org.eclipse.php.internal.ui.actions.PHPQuickMenuCreator;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class GenerateActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.php.ui.source.menu";
    public static final String GROUP_GENERATE = "generateGroup";
    public static final String GROUP_CODE = "codeGroup";
    public static final String GROUP_EXTERNALIZE = "externalizeGroup";
    public static final String GROUP_COMMENT = "commentGroup";
    public static final String GROUP_EDIT = "editGroup";
    private PHPStructuredEditor fEditor;
    private IWorkbenchSite fSite;
    private String fGroupName = "group.reorganize";
    private List<ISelectionChangedListener> fRegisteredSelectionListeners;
    private OrganizeUseStatementsAction fOrganizeUseStatementsAction;
    private static final String QUICK_MENU_ID = "org.eclipse.php.ui.edit.text.php.source.quickMenu";
    private final ISelectionProvider fSelectionProvider;
    private IHandlerActivation fQuickAccessHandlerActivation;
    private IHandlerService fHandlerService;

    public GenerateActionGroup(PHPStructuredEditor editor, String groupName) {
        this.fSite = editor.getSite();
        this.fSelectionProvider = this.fSite.getSelectionProvider();
        this.fEditor = editor;
        this.fGroupName = groupName;
        this.fOrganizeUseStatementsAction = new OrganizeUseStatementsAction((IEditorPart)editor);
        this.fOrganizeUseStatementsAction.setActionDefinitionId("org.eclipse.php.ui.editor.organize.use.statements");
        editor.setAction("OrganizeUseStatements", (IAction)this.fOrganizeUseStatementsAction);
    }

    public GenerateActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite(), null);
        this.installQuickAccessAction();
    }

    public GenerateActionGroup(IWorkbenchSite site, ISelectionProvider selectionProvider) {
        this.fSite = site;
        this.fSelectionProvider = selectionProvider == null ? this.fSite.getSelectionProvider() : selectionProvider;
        ISelection selection = this.fSelectionProvider.getSelection();
        this.fOrganizeUseStatementsAction = new OrganizeUseStatementsAction(site);
        this.fOrganizeUseStatementsAction.setActionDefinitionId("org.eclipse.php.ui.editor.organize.use.statements");
        this.fOrganizeUseStatementsAction.update(selection);
        SelectionDispatchAction[] actions = new SelectionDispatchAction[]{this.fOrganizeUseStatementsAction};
        int i = 0;
        while (i < actions.length) {
            SelectionDispatchAction action = actions[i];
            this.registerSelectionListener(this.fSelectionProvider, action);
            if (selectionProvider != null) {
                action.setSpecialSelectionProvider(this.fSelectionProvider);
            }
            ++i;
        }
    }

    private void installQuickAccessAction() {
        this.fHandlerService = (IHandlerService)this.fSite.getService(IHandlerService.class);
        if (this.fHandlerService != null) {
            IHandler handler = new PHPQuickMenuCreator(null){

                @Override
                protected void fillMenu(IMenuManager menu) {
                    GenerateActionGroup.this.fillQuickMenu(menu);
                }
            }.createHandler();
            this.fQuickAccessHandlerActivation = this.fHandlerService.activateHandler(QUICK_MENU_ID, handler);
        }
    }

    private void registerSelectionListener(ISelectionProvider provider, ISelectionChangedListener listener) {
        if (this.fRegisteredSelectionListeners == null) {
            this.fRegisteredSelectionListeners = new ArrayList<ISelectionChangedListener>(20);
        }
        provider.addSelectionChangedListener(listener);
        this.fRegisteredSelectionListeners.add(listener);
    }

    private void installFormatAction() {
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        String menuText = "Source";
        MenuManager subMenu = new MenuManager(menuText, MENU_ID);
        int added = 0;
        added = this.isEditorOwner() ? this.fillEditorSubMenu((IMenuManager)subMenu) : this.fillViewSubMenu((IMenuManager)subMenu);
        if (added > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
        }
    }

    protected void fillQuickMenu(IMenuManager menu) {
        if (this.isEditorOwner()) {
            this.fillEditorSubMenu(menu);
        } else {
            this.fillViewSubMenu(menu);
        }
    }

    protected int fillEditorSubMenu(IMenuManager source) {
        int added = 0;
        source.add((IContributionItem)new Separator(GROUP_COMMENT));
        added += this.addEditorAction(source, "org.eclipse.dltk.ui.actions.AddBlockComment");
        added += this.addEditorAction(source, "org.eclipse.dltk.ui.actions.RemoveBlockComment");
        added += this.addEditorAction(source, "org.eclipse.dltk.ui.actions.ToggleComment");
        added += this.addEditorAction(source, "org.eclipse.dltk.ui.actions.Comment");
        added += this.addEditorAction(source, "org.eclipse.dltk.ui.actions.Uncomment");
        source.add((IContributionItem)new Separator(GROUP_EDIT));
        added += this.addEditorAction(source, "org.eclipse.dltk.ui.actions.Format");
        added += this.addEditorAction(source, "org.eclipse.dltk.ui.actions.FormatElement");
        added += this.addEditorAction(source, "org.eclipse.dltk.ui.actions.Indent");
        source.add((IContributionItem)new Separator());
        added += this.addEditorAction(source, "ShiftLeft");
        source.add((IContributionItem)new Separator(GROUP_GENERATE));
        source.add((IContributionItem)new Separator(GROUP_CODE));
        source.add((IContributionItem)new Separator(GROUP_EXTERNALIZE));
        return added += this.addEditorAction(source, "ShiftRight");
    }

    private int fillViewSubMenu(IMenuManager source) {
        source.add((IAction)this.fOrganizeUseStatementsAction);
        return 1;
    }

    public void dispose() {
        if (this.fQuickAccessHandlerActivation != null && this.fHandlerService != null) {
            this.fHandlerService.deactivateHandler(this.fQuickAccessHandlerActivation);
        }
        this.fEditor = null;
        super.dispose();
    }

    protected void setGlobalActionHandlers(IActionBars bars) {
        bars.setGlobalActionHandler("org.eclipse.pdt.ui.actions.OrganizeUseStatements", (IAction)this.fOrganizeUseStatementsAction);
        bars.updateActionBars();
    }

    protected final IAction getAction(ITextEditor editor, String actionId) {
        return editor == null || actionId == null ? null : editor.getAction(actionId);
    }

    protected int addAction(IMenuManager menu, String groupName, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.appendToGroup(groupName, action);
            return 1;
        }
        return 0;
    }

    protected int addEditorAction(IMenuManager menu, String groupName, String actionID) {
        if (this.fEditor == null) {
            return 0;
        }
        IAction action = this.fEditor.getAction(actionID);
        if (action == null) {
            return 0;
        }
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if (action.isEnabled()) {
            menu.appendToGroup(groupName, action);
            return 1;
        }
        return 0;
    }

    protected int addEditorAction(IMenuManager menu, String actionID) {
        if (this.fEditor == null) {
            return 0;
        }
        IAction action = this.fEditor.getAction(actionID);
        if (action == null) {
            return 0;
        }
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if (action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean isEditorOwner() {
        return this.fEditor != null;
    }
}

