/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.json.internal;

import com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.tips.core.IHtmlTip;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.TipImage;
import org.eclipse.tips.json.IJsonTip;
import org.eclipse.tips.json.internal.Util;

public class JsonHTMLTip
extends Tip
implements IJsonTip,
IHtmlTip {
    private String fSubject;
    private Date fDate;
    private String fHtml;
    private TipImage fTipImage;
    private JsonObject fJsonObject;

    public JsonHTMLTip(String providerId, JsonObject jsonObject) throws ParseException {
        super(providerId);
        this.fJsonObject = jsonObject;
        this.fSubject = Util.getValueOrDefault(jsonObject, "subject", "Not set");
        this.fDate = JsonHTMLTip.getDate(jsonObject);
        this.fHtml = Util.getValueOrDefault(jsonObject, "html", null);
        String base64Img = Util.getValueOrDefault(jsonObject, "image", null);
        if (base64Img != null) {
            int max;
            this.fTipImage = new TipImage(base64Img);
            double ratio = Util.getValueOrDefault(jsonObject, "ratio", 0.0);
            if (ratio > 0.0) {
                this.fTipImage.setAspectRatio(ratio);
            }
            if ((max = Util.getValueOrDefault(jsonObject, "maxWidth", 0)) > 0) {
                this.fTipImage.setMaxWidth(max);
            }
            if ((max = Util.getValueOrDefault(jsonObject, "maxHeight", 0)) > 0) {
                this.fTipImage.setMaxHeight(max);
            }
        }
    }

    private static Date getDate(JsonObject jsonObject) throws ParseException {
        String date = Util.getValueOrDefault(jsonObject, "date", "1970-01-01");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.parse(date);
    }

    @Override
    public String getJsonObject() {
        return this.fJsonObject.toString();
    }

    public Date getCreationDate() {
        return this.fDate;
    }

    public String getHTML() {
        return Util.replace(this.fJsonObject, this.fHtml);
    }

    public TipImage getImage() {
        return this.fTipImage;
    }

    public String getSubject() {
        return this.fSubject;
    }
}

