/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.parser.wsil;

import java.text.MessageFormat;
import java.text.ParseException;

public class UDDIURIHelper {
    private static final String QUERYSERVICE_URI_TEMPLATE = "uddiservice:query:{0}:query:{1}";
    private static final String SERVICEKEY_URI_TEMPLATE = "uddiservice:serviceKey:{0}:serviceKey:{1}";

    public static final String getQueryServiceURI(String query, String inquiryURL) {
        Object[] uriParams = new String[]{query, inquiryURL};
        return MessageFormat.format(QUERYSERVICE_URI_TEMPLATE, uriParams);
    }

    public static final String getServiceKeyURI(String serviceKey, String inquiryURL) {
        Object[] uriParams = new String[]{serviceKey, inquiryURL};
        return MessageFormat.format(SERVICEKEY_URI_TEMPLATE, uriParams);
    }

    private static final String[] parseURI(String pattern, String uri) {
        try {
            MessageFormat mf = new MessageFormat(pattern);
            Object[] parsedResults = mf.parse(uri);
            if (parsedResults != null && parsedResults.length > 0) {
                String[] results = new String[parsedResults.length];
                int i = 0;
                while (i < parsedResults.length) {
                    results[i] = (String)parsedResults[i];
                    ++i;
                }
                return results;
            }
        }
        catch (ParseException parseException) {}
        return null;
    }

    public static final String[] parseServiceKeyURI(String uri) {
        return UDDIURIHelper.parseURI(SERVICEKEY_URI_TEMPLATE, uri);
    }

    public static final String[] parseQueryServiceURI(String uri) {
        return UDDIURIHelper.parseURI(QUERYSERVICE_URI_TEMPLATE, uri);
    }
}

