/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.commentelement;

import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.commentelement.CommentElementHandler;
import org.eclipse.wst.xml.core.internal.commentelement.impl.CommentElementConfiguration;
import org.eclipse.wst.xml.core.internal.document.TagAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class CommentElementAdapter
implements TagAdapter {
    private CommentElementConfiguration fConfiguration;
    private boolean fEndTag;
    private CommentElementHandler fHandler;

    public CommentElementAdapter(boolean isEndTag, CommentElementHandler handler) {
        this.fEndTag = isEndTag;
        this.fHandler = handler;
    }

    private String generateCommentClose(IDOMElement element) {
        return element.isJSPTag() ? "--%>" : "-->";
    }

    private String generateCommentOpen(IDOMElement element) {
        return element.isJSPTag() ? "<%--" : "<!--";
    }

    private CommentElementConfiguration getConfiguration() {
        return this.fConfiguration;
    }

    @Override
    public String getEndTag(IDOMElement element) {
        String content = this.fHandler.generateEndTagContent(element);
        if (content == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.generateCommentOpen(element));
        buffer.append(content);
        buffer.append(this.generateCommentClose(element));
        return buffer.toString();
    }

    public String getHandlerID() {
        return this.getConfiguration().getHandlerID();
    }

    public String getProperty(String name) {
        return this.getConfiguration().getProperty(name);
    }

    @Override
    public String getStartTag(IDOMElement element) {
        String content = this.fHandler.generateStartTagContent(element);
        if (content == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.generateCommentOpen(element));
        buffer.append(content);
        buffer.append(this.generateCommentClose(element));
        return buffer.toString();
    }

    public boolean isAdapterForType(Object type) {
        return type == CommentElementAdapter.class || type == TagAdapter.class;
    }

    public boolean isContainer() {
        return !this.fHandler.isEmpty();
    }

    @Override
    public boolean isEndTag() {
        return this.fEndTag;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public void setConfiguration(CommentElementConfiguration configuration) {
        this.fConfiguration = configuration;
    }
}

