/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.preview.adapter.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IJavaRuntimeWorkingCopy;
import org.eclipse.jst.server.preview.adapter.internal.Messages;
import org.eclipse.wst.server.core.model.RuntimeDelegate;
import org.osgi.framework.Bundle;

public class PreviewRuntime
extends RuntimeDelegate
implements IJavaRuntimeWorkingCopy {
    public static final String ID = "org.eclipse.jst.server.preview.runtime";
    protected static final String PROP_VM_INSTALL_TYPE_ID = "vm-install-type-id";
    protected static final String PROP_VM_INSTALL_ID = "vm-install-id";

    protected static Path getPluginPath(Bundle bundle) {
        try {
            URL installURL = bundle.getEntry("/");
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new Path(localURL.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static IPath getJarredPluginPath(Bundle bundle) {
        try {
            File file = FileLocator.getBundleFile((Bundle)bundle);
            return new Path(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected String getVMInstallTypeId() {
        return this.getAttribute(PROP_VM_INSTALL_TYPE_ID, null);
    }

    protected String getVMInstallId() {
        return this.getAttribute(PROP_VM_INSTALL_ID, null);
    }

    public boolean isUsingDefaultJRE() {
        return this.getVMInstallTypeId() == null;
    }

    public IVMInstall getVMInstall() {
        if (this.getVMInstallTypeId() == null) {
            return JavaRuntime.getDefaultVMInstall();
        }
        try {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)this.getVMInstallTypeId());
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            String id = this.getVMInstallId();
            IVMInstall[] iVMInstallArray = vmInstalls;
            int n = vmInstalls.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstall vmInstall = iVMInstallArray[n2];
                if (id.equals(vmInstall.getId())) {
                    return vmInstall;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK() && status.getMessage().length() > 0) {
            return status;
        }
        if (this.getVMInstall() == null) {
            return new Status(4, "org.eclipse.jst.server.preview.adapter", 0, Messages.errorJRE, null);
        }
        return Status.OK_STATUS;
    }

    public void setVMInstall(IVMInstall vmInstall) {
        if (vmInstall == null) {
            this.setVMInstall(null, null);
        } else {
            this.setVMInstall(vmInstall.getVMInstallType().getId(), vmInstall.getId());
        }
    }

    protected void setVMInstall(String typeId, String id) {
        if (typeId == null) {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, typeId);
        }
        if (id == null) {
            this.setAttribute(PROP_VM_INSTALL_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_ID, id);
        }
    }
}

