/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.binutils.link2source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.linuxtools.binutils.link2source.Messages;
import org.eclipse.linuxtools.binutils.link2source.STCSourceNotFoundEditorInput;
import org.eclipse.linuxtools.binutils.link2source.STLink2SourceSupport;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.osgi.service.prefs.BackingStoreException;

public class STCSourceNotFoundEditor
extends CommonSourceNotFoundEditor {
    private static final String foundMappingsContainerName = "Found Mappings";
    public static final String ID = "org.eclipse.linuxtools.binutils.link2source.STCSourceNotFoundEditor";
    private Button locateFileButton;
    private Button editLookupButton;

    private IPath getMissingFile() {
        IEditorInput i = this.getEditorInput();
        if (i instanceof STCSourceNotFoundEditorInput) {
            STCSourceNotFoundEditorInput input = (STCSourceNotFoundEditorInput)i;
            return input.getSourcePath();
        }
        return null;
    }

    private int getLineNumber() {
        IEditorInput i = this.getEditorInput();
        if (i instanceof STCSourceNotFoundEditorInput) {
            STCSourceNotFoundEditorInput input = (STCSourceNotFoundEditorInput)i;
            return input.getLineNumber();
        }
        return -1;
    }

    private IProject getProject() {
        IEditorInput i = this.getEditorInput();
        if (i instanceof STCSourceNotFoundEditorInput) {
            STCSourceNotFoundEditorInput input = (STCSourceNotFoundEditorInput)i;
            return input.getProject();
        }
        return null;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.syncButtons();
    }

    private boolean isValidMissingFile() {
        IPath p = this.getMissingFile();
        return p != null && !p.toString().isEmpty();
    }

    private void syncButtons() {
        boolean v = this.isValidMissingFile();
        if (this.locateFileButton != null) {
            this.locateFileButton.setVisible(v);
        }
        if (this.editLookupButton != null) {
            this.editLookupButton.setVisible(v);
        }
    }

    protected String getText() {
        boolean v = this.isValidMissingFile();
        if (v) {
            return String.valueOf(Messages.STCSourceNotFoundEditor_cant_find_source_file) + "\"" + this.getMissingFile() + "\" \n";
        }
        return Messages.STCSourceNotFoundEditor_no_source_available;
    }

    protected void createButtons(Composite parent) {
        this.locateFileButton = new Button(parent, 8);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = false;
        this.locateFileButton.setLayoutData((Object)data);
        this.locateFileButton.setText(Messages.STCSourceNotFoundEditor_locate_file);
        this.locateFileButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.locateFile()));
        this.editLookupButton = new Button(parent, 8);
        this.editLookupButton.setLayoutData((Object)data);
        this.editLookupButton.setText(Messages.STCSourceNotFoundEditor_edit_source_lookup_path);
        this.editLookupButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.editSourceLookupPath()));
        this.syncButtons();
    }

    protected void editSourceLookupPath() {
        PreferenceDialog d = PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.cdt.debug.ui.SourcePreferencePage", null, null);
        if (d.open() == 0) {
            this.closeEditor();
            this.openSourceFileAtLocation(this.getProject(), this.getMissingFile(), this.getLineNumber());
        }
    }

    private void addSourceMappingToDirector(IPath missingPath, IPath newSourcePath, AbstractSourceLookupDirector director) {
        ArrayList<ISourceContainer> containerList = new ArrayList<ISourceContainer>(Arrays.asList(director.getSourceContainers()));
        boolean hasFoundMappings = false;
        MappingSourceContainer foundMappings = null;
        Iterator<ISourceContainer> iter = containerList.iterator();
        while (iter.hasNext() && !hasFoundMappings) {
            ISourceContainer container = iter.next();
            if (!(container instanceof MappingSourceContainer) || !(hasFoundMappings = container.getName().equals(foundMappingsContainerName))) continue;
            foundMappings = (MappingSourceContainer)container;
        }
        if (!hasFoundMappings) {
            foundMappings = new MappingSourceContainer(foundMappingsContainerName);
            foundMappings.init((ISourceLookupDirector)director);
            containerList.add((ISourceContainer)foundMappings);
        }
        foundMappings.addMapEntry(new MapEntrySourceContainer(missingPath.toOSString(), newSourcePath));
        director.setSourceContainers(containerList.toArray(new ISourceContainer[containerList.size()]));
    }

    private void addSourceMappingToCommon(IPath missingPath, IPath newSourcePath) throws CoreException {
        CSourceLookupDirector director = CDebugCorePlugin.getDefault().getCommonSourceLookupDirector();
        this.addSourceMappingToDirector(missingPath, newSourcePath, (AbstractSourceLookupDirector)director);
        try {
            InstanceScope.INSTANCE.getNode("org.eclipse.cdt.debug.core").flush();
        }
        catch (BackingStoreException e) {
            IStatus status = Status.error((String)(String.valueOf(Messages.STCSourceNotFoundEditor_failed_saving_settings_for_content_type) + "org.eclipse.cdt.debug.core"), (Throwable)e);
            throw new CoreException(status);
        }
    }

    private void locateFile() {
        Path newPath;
        FileDialog dialog = new FileDialog(this.getEditorSite().getShell(), 0);
        IPath missingPath = this.getMissingFile();
        dialog.setFilterNames(new String[]{Messages.STCSourceNotFoundEditor_missing_source_file});
        dialog.setFilterExtensions(new String[]{"*." + missingPath.getFileExtension()});
        String res = dialog.open();
        if (res != null && (newPath = new Path(res)).lastSegment().equalsIgnoreCase(missingPath.lastSegment())) {
            if (missingPath.segmentCount() > 1) {
                int missingPathSegCount = missingPath.segmentCount() - 2;
                int newPathSegCount = newPath.segmentCount() - 2;
                while (missingPathSegCount >= 0 && newPathSegCount >= 0) {
                    if (!newPath.segment(newPathSegCount).equalsIgnoreCase(missingPath.segment(missingPathSegCount))) break;
                    --newPathSegCount;
                    --missingPathSegCount;
                }
                IPath compPath = missingPath.removeLastSegments(missingPath.segmentCount() - missingPathSegCount - 1);
                IPath newSourcePath = newPath.removeLastSegments(newPath.segmentCount() - newPathSegCount - 1);
                try {
                    this.addSourceMappingToCommon(compPath, newSourcePath);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            this.openSourceFileAtLocation(this.getProject(), (IPath)newPath, this.getLineNumber());
            this.closeEditor();
        }
    }

    protected void openSourceFileAtLocation(IProject project, IPath sourceLoc, int lineNumber) {
        STLink2SourceSupport.openSourceFileAtLocation(project, sourceLoc, lineNumber);
    }
}

