/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.internal.archetype.ArchetypeManager;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.preferences.LocalArchetypeCatalogDialog;
import org.eclipse.m2e.core.ui.internal.preferences.RemoteArchetypeCatalogDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenArchetypesPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger log = LoggerFactory.getLogger(MavenArchetypesPreferencePage.class);
    ArchetypeManager archetypeManager;
    CheckboxTableViewer archetypesViewer;
    List<ArchetypeCatalogFactory> archetypeCatalogs;

    public MavenArchetypesPreferencePage() {
        super(1);
        this.setTitle(Messages.MavenArchetypesPreferencePage_title);
        this.setPreferenceStore(M2EUIPluginActivator.getDefault().getPreferenceStore());
        this.archetypeManager = MavenPluginActivator.getDefault().getArchetypeManager();
    }

    protected void performDefaults() {
        Iterator<ArchetypeCatalogFactory> it = this.archetypeCatalogs.iterator();
        while (it.hasNext()) {
            ArchetypeCatalogFactory factory = it.next();
            if (!factory.isEditable()) continue;
            it.remove();
        }
        this.archetypesViewer.setAllChecked(true);
        this.archetypesViewer.setInput(this.archetypeCatalogs);
        this.archetypesViewer.setSelection(null, true);
        super.performDefaults();
    }

    public boolean performOk() {
        Collection catalogs = this.archetypeManager.getArchetypeCatalogs();
        for (ArchetypeCatalogFactory factory : catalogs) {
            if (!factory.isEditable()) continue;
            this.archetypeManager.removeArchetypeCatalogFactory(factory.getId());
        }
        for (ArchetypeCatalogFactory factory : this.archetypeCatalogs) {
            factory.setEnabled(this.archetypesViewer.getChecked((Object)factory));
            if (!factory.isEditable()) continue;
            this.archetypeManager.addArchetypeCatalogFactory(factory);
        }
        try {
            this.archetypeManager.saveCatalogs();
        }
        catch (IOException ex) {
            this.setErrorMessage(NLS.bind((String)Messages.MavenArchetypesPreferencePage_error, (Object)ex.getMessage()));
            return false;
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite composite = new Composite(this.getFieldEditorParent(), 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        Link addRemoveOrLink = new Link(composite, 0);
        GridData gd_addRemoveOrLink = new GridData(4, 0x1000000, false, false, 2, 1);
        addRemoveOrLink.setLayoutData((Object)gd_addRemoveOrLink);
        addRemoveOrLink.setText(Messages.MavenArchetypesPreferencePage_link);
        addRemoveOrLink.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            try {
                URL url = new URL("http://maven.apache.org/plugins/maven-archetype-plugin/specification/archetype-catalog.html");
                IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                browser.openURL(url);
            }
            catch (MalformedURLException ex) {
                log.error("Malformed URL", (Throwable)ex);
            }
            catch (PartInitException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }));
        this.archetypesViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67584);
        this.archetypesViewer.setLabelProvider((IBaseLabelProvider)new CatalogsLabelProvider());
        this.archetypesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object input) {
                if (input instanceof Collection) {
                    return ((Collection)input).toArray();
                }
                return new Object[0];
            }
        });
        Table table = this.archetypesViewer.getTable();
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        table.setLayoutData((Object)new GridData(4, 4, true, false, 1, 6));
        TableColumn typeColumn = new TableColumn(table, 0);
        typeColumn.setWidth(250);
        typeColumn.setText("");
        Button enableAllBtn = new Button(composite, 0);
        enableAllBtn.setLayoutData((Object)new GridData(4, 128, false, false));
        enableAllBtn.setText(Messages.MavenArchetypesPreferencePage_btnEnableAll);
        enableAllBtn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.toggleRepositories(true)));
        Button disableAllBtn = new Button(composite, 0);
        disableAllBtn.setLayoutData((Object)new GridData(4, 128, false, false));
        disableAllBtn.setText(Messages.MavenArchetypesPreferencePage_btnDisableAll);
        disableAllBtn.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.toggleRepositories(false)));
        Button addLocalButton = new Button(composite, 0);
        addLocalButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addLocalButton.setText(Messages.MavenArchetypesPreferencePage_btnAddLocal);
        addLocalButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            LocalArchetypeCatalogDialog dialog = new LocalArchetypeCatalogDialog(this.getShell(), null);
            if (dialog.open() == 0) {
                this.addCatalogFactory(dialog.getArchetypeCatalogFactory());
            }
        }));
        Button addRemoteButton = new Button(composite, 0);
        addRemoteButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addRemoteButton.setText(Messages.MavenArchetypesPreferencePage_btnAddRemote);
        addRemoteButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            RemoteArchetypeCatalogDialog dialog = new RemoteArchetypeCatalogDialog(this.getShell(), null);
            if (dialog.open() == 0) {
                this.addCatalogFactory(dialog.getArchetypeCatalogFactory());
            }
        }));
        Button editButton = new Button(composite, 0);
        editButton.setLayoutData((Object)new GridData(4, 128, false, false));
        editButton.setEnabled(false);
        editButton.setText(Messages.MavenArchetypesPreferencePage_btnEdit);
        editButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int n;
            TitleAreaDialog dialog;
            ArchetypeCatalogFactory factory = this.getSelectedArchetypeCatalogFactory();
            ArchetypeCatalogFactory newFactory = null;
            if (factory instanceof ArchetypeCatalogFactory.LocalCatalogFactory) {
                dialog = new LocalArchetypeCatalogDialog(this.getShell(), factory);
                if (dialog.open() == 0) {
                    newFactory = dialog.getArchetypeCatalogFactory();
                }
            } else if (factory instanceof ArchetypeCatalogFactory.RemoteCatalogFactory && (dialog = new RemoteArchetypeCatalogDialog(this.getShell(), factory)).open() == 0) {
                newFactory = dialog.getArchetypeCatalogFactory();
            }
            if (newFactory != null && (n = this.archetypeCatalogs.indexOf(factory)) > -1) {
                this.archetypeCatalogs.set(n, newFactory);
                this.archetypesViewer.setInput(this.archetypeCatalogs);
                this.archetypesViewer.setSelection((ISelection)new StructuredSelection((Object)newFactory), true);
            }
        }));
        Button removeButton = new Button(composite, 0);
        removeButton.setEnabled(false);
        removeButton.setLayoutData((Object)new GridData(4, 128, false, true));
        removeButton.setText(Messages.MavenArchetypesPreferencePage_btnRemove);
        removeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ArchetypeCatalogFactory factory = this.getSelectedArchetypeCatalogFactory();
            this.archetypeCatalogs.remove(factory);
            this.archetypesViewer.setInput(this.archetypeCatalogs);
            this.archetypesViewer.setSelection(null, true);
        }));
        this.archetypesViewer.addSelectionChangedListener(event -> {
            if (this.archetypesViewer.getSelection() instanceof IStructuredSelection) {
                ArchetypeCatalogFactory factory = this.getSelectedArchetypeCatalogFactory();
                boolean isEnabled = factory != null && factory.isEditable();
                removeButton.setEnabled(isEnabled);
                editButton.setEnabled(isEnabled);
            }
        });
        this.archetypesViewer.addCheckStateListener(event -> this.archetypesViewer.refresh(event.getElement(), true));
        this.archetypeCatalogs = new ArrayList<ArchetypeCatalogFactory>(this.archetypeManager.getArchetypeCatalogs());
        this.archetypesViewer.setInput(this.archetypeCatalogs);
        this.archetypeCatalogs.forEach(a -> {
            boolean bl = this.archetypesViewer.setChecked(a, a.isEnabled());
        });
        this.archetypesViewer.refresh();
        this.addField((FieldEditor)new BooleanFieldEditor("enableSnapshotArchetypes", Messages.MavenProjectWizardArchetypePage_btnSnapshots, this.getFieldEditorParent()));
    }

    protected void toggleRepositories(boolean toggle) {
        this.archetypeCatalogs.forEach(a -> {
            boolean bl2 = this.archetypesViewer.setChecked(a, toggle);
        });
        this.archetypesViewer.refresh();
    }

    protected ArchetypeCatalogFactory getSelectedArchetypeCatalogFactory() {
        IStructuredSelection selection = (IStructuredSelection)this.archetypesViewer.getSelection();
        return (ArchetypeCatalogFactory)selection.getFirstElement();
    }

    private void addCatalogFactory(ArchetypeCatalogFactory factory) {
        if (factory == null) {
            return;
        }
        this.archetypeCatalogs.add(factory);
        if (!this.archetypesViewer.getControl().isDisposed()) {
            this.archetypesViewer.setInput(this.archetypeCatalogs);
            this.archetypesViewer.setChecked((Object)factory, true);
            this.archetypesViewer.setSelection((ISelection)new StructuredSelection((Object)factory), true);
        }
    }

    class CatalogsLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private final Color disabledColor = Display.getCurrent().getSystemColor(16);

        CatalogsLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ArchetypeCatalogFactory factory = (ArchetypeCatalogFactory)element;
            String description = factory.getDescription();
            String text = factory instanceof ArchetypeCatalogFactory.LocalCatalogFactory ? NLS.bind((String)Messages.MavenArchetypesPreferencePage_local, (Object)description) : (factory instanceof ArchetypeCatalogFactory.RemoteCatalogFactory ? (factory.isEditable() ? NLS.bind((String)Messages.MavenArchetypesPreferencePage_remote, (Object)description) : NLS.bind((String)Messages.MavenArchetypesPreferencePage_packaged, (Object)description)) : description);
            return factory.isEditable() ? text : NLS.bind((String)Messages.MavenArchetypesPreferencePage_SystemLabel, (Object)text);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            return MavenArchetypesPreferencePage.this.archetypesViewer.getChecked(element) ? null : this.disabledColor;
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

