/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views.nodes;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.views.nodes.IArtifactNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.IMavenRepositoryNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.IndexedArtifactFileNode;
import org.eclipse.swt.graphics.Image;

public class IndexedArtifactNode
implements IMavenRepositoryNode,
IArtifactNode {
    private final IndexedArtifact artifact;
    private Object[] kids = null;

    public IndexedArtifactNode(IndexedArtifact artifact) {
        this.artifact = artifact;
    }

    @Override
    public Object[] getChildren() {
        Set files = this.artifact.getFiles();
        if (files == null) {
            return new Object[0];
        }
        ArrayList<IndexedArtifactFileNode> fileList = new ArrayList<IndexedArtifactFileNode>();
        for (IndexedArtifactFile iaf : files) {
            fileList.add(new IndexedArtifactFileNode(iaf));
        }
        this.kids = fileList.toArray(new IndexedArtifactFileNode[fileList.size()]);
        return this.kids;
    }

    @Override
    public String getName() {
        String pkg = this.artifact.getPackaging();
        if (pkg == null) {
            pkg = Messages.IndexedArtifactNode_no_pack;
        }
        return String.valueOf(this.artifact.getArtifactId()) + " - " + pkg;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public Image getImage() {
        return MavenImages.IMG_JAR;
    }

    @Override
    public String getDocumentKey() {
        return this.artifact.getArtifactId();
    }

    @Override
    public boolean isUpdating() {
        return false;
    }
}

