/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.event;

import java.util.function.Consumer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;

public final class EventUtil {
    public static final IListener[] NO_LISTENERS = new IListener[0];

    private EventUtil() {
    }

    public static boolean addUniqueListener(Object notifier, IListener listener) {
        if (notifier instanceof INotifier.INotifier2) {
            return ((INotifier.INotifier2)notifier).addUniqueListener(listener);
        }
        if (notifier instanceof INotifier && !EventUtil.hasListener(notifier, listener)) {
            ((INotifier)notifier).addListener(listener);
            return true;
        }
        return false;
    }

    public static boolean addListener(Object notifier, IListener listener) {
        if (notifier instanceof INotifier) {
            ((INotifier)notifier).addListener(listener);
            return true;
        }
        return false;
    }

    public static <E extends IEvent> AutoCloseable addListener(Object notifier, final Class<E> eventType, final Consumer<E> eventConsumer) {
        if (notifier instanceof INotifier) {
            final INotifier n = (INotifier)notifier;
            AutoCloseableListener listener = new AutoCloseableListener(){

                @Override
                public void notifyEvent(IEvent event) {
                    if (eventType.isInstance(event)) {
                        eventConsumer.accept((IEvent)eventType.cast(event));
                    }
                }

                @Override
                public void close() throws Exception {
                    n.removeListener(this);
                }
            };
            n.addListener(listener);
            return listener;
        }
        return () -> {};
    }

    public static boolean removeListener(Object notifier, IListener listener) {
        if (notifier instanceof INotifier) {
            ((INotifier)notifier).removeListener(listener);
            return true;
        }
        return false;
    }

    public static IListener[] getListeners(Object notifier) {
        if (notifier instanceof INotifier) {
            return ((INotifier)notifier).getListeners();
        }
        return NO_LISTENERS;
    }

    public static boolean hasListener(Object notifier, IListener listener) {
        if (notifier instanceof INotifier.INotifier2) {
            return ((INotifier.INotifier2)notifier).hasListener(listener);
        }
        if (notifier instanceof INotifier) {
            IListener[] listeners = ((INotifier)notifier).getListeners();
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] == listener) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static interface AutoCloseableListener
    extends IListener,
    AutoCloseable {
    }
}

