/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.php.internal.server.core.builtin.DefaultPHPServerDebugger;
import org.eclipse.php.internal.server.core.builtin.DefaultPHPServerRunner;
import org.eclipse.php.internal.server.core.builtin.PHPServerBehaviour;
import org.eclipse.php.internal.server.core.builtin.PHPServerRunnerConfiguration;
import org.eclipse.php.internal.server.core.builtin.Trace;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class PHPServerLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            Trace.trace((byte)3, "Launch configuration could not find server");
            return;
        }
        PHPServerBehaviour phpServer = (PHPServerBehaviour)server.loadAdapter(PHPServerBehaviour.class, null);
        if (server.shouldPublish() && ServerCore.isAutoPublishing()) {
            server.publish(1, monitor);
        }
        String workingDir = phpServer.getServerDeployDirectory().toOSString();
        String host = phpServer.getServer().getHost();
        int port = phpServer.getPHPServerConfiguration().getMainPort().getPort();
        String phpExeLocation = configuration.getAttribute("ATTR_LOCATION", "");
        String phpIniLocation = configuration.getAttribute("ATTR_INI_LOCATION", "");
        PHPServerRunnerConfiguration runConfig = new PHPServerRunnerConfiguration(phpExeLocation, host, port);
        runConfig.setWorkingDirectory(workingDir);
        runConfig.setIniFilePath(phpIniLocation);
        DefaultPHPServerRunner runner = null;
        if ("run".equals(mode)) {
            runner = new DefaultPHPServerRunner();
        } else if ("debug".equals(mode)) {
            runner = new DefaultPHPServerDebugger();
        } else {
            return;
        }
        phpServer.setupLaunch(launch, mode, monitor);
        phpServer.setPHPServerRunner(runner);
        try {
            runner.run(runConfig, launch, monitor);
            phpServer.addProcessListener(launch.getProcesses()[0]);
        }
        catch (Exception e) {
            phpServer.stopImpl();
        }
    }
}

