/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.changes;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.refactoring.core.rename.Messages;

public class ProjectReferenceChange
extends Change {
    private String oldName;
    private String newName;
    private IProject[] referencing;
    private IBuildpathEntry newEntry;

    public ProjectReferenceChange(String oldName, String newName, IProject[] referencing) {
        this.oldName = oldName;
        this.newName = newName;
        this.referencing = referencing;
    }

    public Object getModifiedElement() {
        return this.referencing;
    }

    public String getName() {
        return NLS.bind((String)Messages.ProjectReferenceChange_0, (Object[])new String[]{this.oldName, this.newName});
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(this.getName(), 1);
            pm.beginTask(Messages.ProjectReferenceChange_1, this.referencing.length);
            int i = 0;
            while (i < this.referencing.length) {
                IScriptProject jp = DLTKCore.create((IProject)this.referencing[i]);
                if (jp != null && jp.exists()) {
                    this.modifyBuildpath(jp, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                } else {
                    pm.worked(1);
                }
                ++i;
            }
        }
        finally {
            pm.done();
        }
        return new ProjectReferenceChange(this.newName, this.oldName, this.referencing);
    }

    private void modifyBuildpath(IScriptProject referencingProject, IProgressMonitor pm) throws ModelException {
        pm.beginTask("", 1);
        IProject project = referencingProject.getProject();
        IBuildpathEntry[] oldEntries = referencingProject.getRawBuildpath();
        IBuildpathEntry[] newEntries = new IBuildpathEntry[oldEntries.length];
        int i = 0;
        while (i < newEntries.length) {
            newEntries[i] = this.isOurEntry(oldEntries[i]) ? this.createModifiedEntry(oldEntries[i]) : oldEntries[i];
            ++i;
        }
        IncludePath[] includes = IncludePathManager.getInstance().getIncludePaths(project);
        IncludePath[] newInclude = new IncludePath[includes.length];
        int i2 = 0;
        while (i2 < includes.length) {
            newInclude[i2] = this.isOurEntry(includes[i2]) ? this.createModifiedIncludePath(includes[i2], project) : includes[i2];
            ++i2;
        }
        referencingProject.setRawBuildpath(newEntries, pm);
        IncludePathManager.getInstance().setIncludePath(project, newInclude);
        IncludePathManager.getInstance().refresh(project);
        pm.done();
    }

    private boolean isOurEntry(IncludePath includePath) {
        Object entry = includePath.getEntry();
        if (entry instanceof IProject) {
            return ((IProject)entry).getName().equals(this.oldName);
        }
        if (entry instanceof IBuildpathEntry) {
            return this.isOurEntry((IBuildpathEntry)entry);
        }
        return false;
    }

    private IncludePath createModifiedIncludePath(IncludePath includePath, IProject project) {
        Object entry = includePath.getEntry();
        boolean cfr_ignored_0 = entry instanceof IProject;
        if (entry instanceof IBuildpathEntry) {
            this.newEntry = this.createModifiedEntry((IBuildpathEntry)entry);
            return new IncludePath((Object)this.newEntry, project);
        }
        return null;
    }

    private boolean isOurEntry(IBuildpathEntry cpe) {
        if (cpe.getEntryKind() != 2) {
            return false;
        }
        return cpe.getPath().equals((Object)new Path("/" + this.oldName));
    }

    private IBuildpathEntry createModifiedEntry(IBuildpathEntry oldEntry) {
        return DLTKCore.newProjectEntry((IPath)this.createNewPath(), (IAccessRule[])oldEntry.getAccessRules(), (boolean)oldEntry.combineAccessRules(), (IBuildpathAttribute[])oldEntry.getExtraAttributes(), (boolean)oldEntry.isExported());
    }

    protected IPath createNewPath() {
        return new Path("/" + this.newName);
    }
}

