/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ide.internal.provider;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.TipImage;
import org.eclipse.tips.core.TipProvider;
import org.eclipse.tips.core.internal.LogUtil;
import org.eclipse.tips.ide.internal.provider.Tip1_Welcome;
import org.eclipse.tips.ide.internal.provider.Tip2_StartingTips;
import org.eclipse.tips.ide.internal.provider.Tip3_StartingTips;
import org.eclipse.tips.ide.internal.provider.Tip6_ActionsTip;
import org.eclipse.tips.ide.internal.provider.Tip7_Extend;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TipsTipProvider
extends TipProvider {
    private TipImage fImage48;

    public TipImage getImage() {
        if (this.fImage48 == null) {
            Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
            try {
                this.fImage48 = new TipImage(bundle.getEntry("icons/tips.png")).setAspectRatio(1.0);
            }
            catch (IOException e) {
                this.getManager().log(LogUtil.info(((Object)((Object)this)).getClass(), (Throwable)e));
            }
        }
        return this.fImage48;
    }

    public synchronized IStatus loadNewTips(IProgressMonitor pMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pMonitor);
        subMonitor.beginTask("Loading Tips", -1);
        ArrayList<Tip> tips = new ArrayList<Tip>();
        tips.add(new Tip1_Welcome(this.getID()));
        tips.add(new Tip2_StartingTips(this.getID()));
        tips.add(new Tip3_StartingTips(this.getID()));
        tips.add(new Tip6_ActionsTip(this.getID()));
        if (Platform.getBundle((String)"org.eclipse.pde.ui") != null) {
            tips.add(new Tip7_Extend(this.getID()));
        }
        this.setTips(tips);
        subMonitor.done();
        return Status.OK_STATUS;
    }

    public String getDescription() {
        return "Tips about Tips";
    }

    public String getID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void dispose() {
    }

    public static Date getDateFromYYMMDD(String pYYMMDD) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            return sdf.parse(pYYMMDD);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

