/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.beans.PropertyDescriptor;
import org.eclipse.wb.internal.core.model.property.editor.EnumerationValuesPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditorProvider;

public final class PropertyDescriptorEditorProvider
extends PropertyEditorProvider {
    public PropertyEditor getEditorForPropertyDescriptor(PropertyDescriptor descriptor) throws Exception {
        Object attributeValue = descriptor.getValue("enumerationValues");
        if (PropertyDescriptorEditorProvider.isEnumerationProperty(descriptor)) {
            return new EnumerationValuesPropertyEditor(attributeValue);
        }
        return null;
    }

    private static boolean isEnumerationProperty(PropertyDescriptor descriptor) {
        Object attributeValue = descriptor.getValue("enumerationValues");
        if (!(attributeValue instanceof Object[])) {
            return false;
        }
        Object[] enumElements = (Object[])attributeValue;
        if (enumElements.length == 0 || enumElements.length % 3 != 0) {
            return false;
        }
        int i = 0;
        while (i < enumElements.length) {
            Object element = enumElements[i];
            if (i % 3 == 0 && !(element instanceof String)) {
                return false;
            }
            if (i % 3 == 2 && !(element instanceof String)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

