/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.ibm.catalog.util.ICatalogQuery;
import org.eclipse.datatools.enablement.ibm.util.QueryExecutionJob;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.ecore.EObject;

public class QueryExecutionEngine {
    public static void realizeQueries(EObject object, ICatalogQuery[] queries) {
        if (!(object instanceof ICatalogObject)) {
            return;
        }
        ICatalogObject catalogObject = (ICatalogObject)object;
        QueryExecutionEngine.runOrderQueries(catalogObject, queries);
        Database database = catalogObject.getCatalogDatabase();
        HashSet<QueryExecutionJob> jobs = new HashSet<QueryExecutionJob>();
        int i = 0;
        while (i < queries.length) {
            if (!queries[i].isQueryProcessed(database)) {
                QueryExecutionJob job = new QueryExecutionJob("Query Execution Job", queries[i], catalogObject);
                jobs.add(job);
                if (queries[i].useOnDemandQuery()) {
                    job.waitUntilFinished();
                }
                job.schedule();
            }
            ++i;
        }
        QueryExecutionEngine.finishJobs(jobs);
    }

    private static void runOrderQueries(ICatalogObject object, ICatalogQuery[] queries) {
        HashSet<ICatalogQuery> orderQueries = new HashSet<ICatalogQuery>();
        ICatalogQuery[] iCatalogQueryArray = queries;
        int n = queries.length;
        int n2 = 0;
        while (n2 < n) {
            ICatalogQuery query = iCatalogQueryArray[n2];
            if (query.getOrderQuery() != null) {
                orderQueries.add(query.getOrderQuery());
            }
            ++n2;
        }
        ArrayList<QueryExecutionJob> orderQueryJobs = new ArrayList<QueryExecutionJob>(orderQueries.size());
        for (ICatalogQuery orderQuery : orderQueries) {
            QueryExecutionJob orderQueryJob = new QueryExecutionJob("Query Execution Job -- OrderQuery", orderQuery, object);
            orderQueryJob.waitUntilFinished();
            orderQueryJobs.add(orderQueryJob);
            orderQueryJob.schedule();
        }
        QueryExecutionEngine.finishJobs(orderQueryJobs);
    }

    private static void finishJobs(Collection<QueryExecutionJob> queryJobs) {
        for (QueryExecutionJob queryJob : queryJobs) {
            try {
                queryJob.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

