/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.loaders;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.enablement.ingres.internal.loaders.LoaderHelper;
import org.eclipse.datatools.modelbase.sql.routines.Source;

public class IngresViewSourceLoader
extends JDBCBaseLoader {
    private static final String VIEW_SOURCE_QUERY = "SELECT text_segment FROM iiviews WHERE table_name=? AND table_owner=? ORDER BY text_sequence";
    private static final String VIEW_SOURCE_SEGMENT = "text_segment";

    public IngresViewSourceLoader() {
        this(null);
    }

    public IngresViewSourceLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public IngresViewSourceLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
    }

    public void loadSource(String viewOwner, String viewName, Source source) {
        block6: {
            ResultSet rs = null;
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = this.getCatalogObject().getConnection().prepareStatement(VIEW_SOURCE_QUERY);
                    stmt.setString(1, viewName);
                    stmt.setString(2, viewOwner);
                    rs = stmt.executeQuery();
                    StringBuffer sourceBuf = new StringBuffer();
                    while (rs.next()) {
                        sourceBuf.append(rs.getString(VIEW_SOURCE_SEGMENT));
                    }
                    source.setBody(sourceBuf.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LoaderHelper.close(rs);
                    LoaderHelper.close(stmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                LoaderHelper.close(rs);
                LoaderHelper.close(stmt);
                throw throwable;
            }
            LoaderHelper.close(rs);
            LoaderHelper.close(stmt);
        }
    }
}

