/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.xml.query.util;

import java.util.List;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.XMLDataType;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceWriter;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLAggregateFunction;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLAggregateSortSpecification;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLAttributeDeclarationItem;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLAttributesDeclaration;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLContentType;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLContentType2;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLDeclarationType;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLEmptyHandlingType;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLNamespaceDeclarationDefault;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLNamespaceDeclarationItem;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLNamespaceDeclarationPrefix;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLNamespacesDeclaration;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLNullHandlingType;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLPassingType;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLPredicateExists;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLQueryArgumentItem;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLQueryArgumentList;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLQueryExpression;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLReturningType;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLSerializeFunction;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLSerializeFunctionEncoding;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLSerializeFunctionTarget;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLTableColumnDefinitionDefault;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLTableColumnDefinitionOrdinality;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLTableColumnDefinitionRegular;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLTableFunction;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueExpressionCast;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionComment;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionCommentContent;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionConcat;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionConcatContentItem;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionDocument;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionDocumentContent;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionElement;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionElementContentItem;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionElementContentList;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionForest;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionForestContentItem;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionPI;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionPIContent;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionParse;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionParseContent;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionQuery;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionQueryReturning;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionText;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionTextContent;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionValidate;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionValidateAccordingToIdentifier;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionValidateAccordingToURI;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionValidateContent;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionValidateElement;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionValidateElementName;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLValueFunctionValidateElementNamespace;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLWhitespaceHandlingType;
import org.eclipse.emf.common.util.EList;

public class SQLXMLQuerySourceWriter
extends SQLQuerySourceWriter {
    protected final String XML_CONTENT_TYPE_CONTENT = "CONTENT";
    protected final String XML_CONTENT_TYPE_DOCUMENT = "DOCUMENT";
    protected final String XML_CONTENT_TYPE_SEQUENCE = "SEQUENCE";
    protected final String XML_DECLARATION_TYPE_INCLUDING = "INCLUDING XMLDECLARATION";
    protected final String XML_DECLARATION_TYPE_EXCLUDING = "EXCLUDING XMLDECLARATION";
    protected final String XML_EMPTY_HANDLING_TYPE_EMPTY_ON_EMPTY = "EMPTY ON EMPTY";
    protected final String XML_EMPTY_HANDLING_TYPE_NULL_ON_EMPTY = "NULL ON EMPTY";
    protected final String XML_NULL_HANDLING_TYPE_ABSENT_ON_NULL = "ABSENT ON NULL";
    protected final String XML_NULL_HANDLING_TYPE_EMPTY_ON_NULL = "EMPTY ON NULL";
    protected final String XML_NULL_HANDLING_TYPE_NIL_ON_NO_CONTENT = "NIL ON NO CONTENT";
    protected final String XML_NULL_HANDLING_TYPE_NIL_ON_NULL = "NIL ON NULL";
    protected final String XML_NULL_HANDLING_TYPE_NULL_ON_NULL = "NULL ON NULL";
    protected final String BY_REF = "BY REF";
    protected final String BY_VALUE = "BY VALUE";
    protected final String XML_RETURNING_TYPE_CONTENT = "RETURNING CONTENT";
    protected final String XML_RETURNING_TYPE_SEQUENCE = "RETURNING SEQUENCE";
    protected final String XML_WHITESPACE_PRESERVE = "PRESERVE WHITESPACE";
    protected final String XML_WHITESPACE_STRIP = "STRIP WHITESPACE";
    protected final String ACCORDING_TO_XMLSCHEMA = "ACCORDING TO XMLSCHEMA";
    protected final String COLUMNS = "COLUMNS";
    protected final String CONTENT = "CONTENT";
    protected final String ELEMENT = "ELEMENT";
    protected final String ENCODING = "ENCODING";
    protected final String FOR_ORDINALITY = "FOR ORDINALITY";
    protected final String ID = "ID";
    protected final String LOCATION = "LOCATION";
    protected final String NAME = "NAME";
    protected final String NAMESPACE = "NAMESPACE";
    protected final String NO_DEFAULT = "NO DEFAULT";
    protected final String NO_NAMESPACE = "NO NAMESPACE";
    protected final String OPTION = "OPTION";
    protected final String PASSING = "PASSING";
    protected final String PATH = "PATH";
    protected final String RETURNING = "RETURNING";
    protected final String URI = "URI";
    protected final String VERSION = "VERSION";
    protected final String XMLAGG = "XMLAGG";
    protected final String XMLATTRIBUTES = "XMLATTRIBUTES";
    protected final String XMLCAST = "XMLCAST";
    protected final String XMLCONCAT = "XMLCONCAT";
    protected final String XMLCOMMENT = "XMLCOMMENT";
    protected final String XMLELEMENT = "XMLELEMENT";
    protected final String XMLEXISTS = "XMLEXISTS";
    protected final String XMLDOCUMENT = "XMLDOCUMENT";
    protected final String XMLFOREST = "XMLFOREST";
    protected final String XMLNAMESPACES = "XMLNAMESPACES";
    protected final String XMLPARSE = "XMLPARSE";
    protected final String XMLPI = "XMLPI";
    protected final String XMLQUERY = "XMLQUERY";
    protected final String XMLSERIALIZE = "XMLSERIALIZE";
    protected final String XMLTABLE = "XMLTABLE";
    protected final String XMLTEXT = "XMLTEXT";
    protected final String XMLVALIDATE = "XMLVALIDATE";

    protected void appendSpecificSQL(XMLDataType dataType, StringBuffer sb) {
        this.appendSpecificSQL(dataType.getPrimitiveType(), sb);
    }

    protected void appendSpecificSQL(XMLContentType contentType, StringBuffer sb) {
        int type = contentType.getValue();
        switch (type) {
            case 0: {
                sb.append("CONTENT");
                break;
            }
            case 1: {
                sb.append("DOCUMENT");
                break;
            }
        }
    }

    protected void appendSpecificSQL(XMLContentType2 contentType, StringBuffer sb) {
        int type = contentType.getValue();
        switch (type) {
            case 0: {
                sb.append("CONTENT");
                break;
            }
            case 1: {
                sb.append("DOCUMENT");
                break;
            }
            case 2: {
                sb.append("SEQUENCE");
                break;
            }
        }
    }

    protected void appendSpecificSQL(XMLDeclarationType declarationType, StringBuffer sb) {
        int type = declarationType.getValue();
        switch (type) {
            case 1: {
                sb.append("INCLUDING XMLDECLARATION");
                break;
            }
            case 0: {
                sb.append("EXCLUDING XMLDECLARATION");
                break;
            }
        }
    }

    protected void appendSpecificSQL(XMLEmptyHandlingType emptyHandlingType, StringBuffer sb) {
        int type = emptyHandlingType.getValue();
        switch (type) {
            case 0: {
                sb.append("EMPTY ON EMPTY");
                break;
            }
            case 1: {
                sb.append("NULL ON EMPTY");
                break;
            }
        }
    }

    protected void appendSpecificSQL(XMLPassingType passingType, StringBuffer sb) {
        int type = passingType.getValue();
        switch (type) {
            case 0: {
                sb.append("BY REF");
                break;
            }
            case 1: {
                sb.append("BY VALUE");
                break;
            }
            case 2: {
                break;
            }
        }
    }

    protected void appendSpecificSQL(XMLReturningType returningType, StringBuffer sb) {
        int type = returningType.getValue();
        switch (type) {
            case 0: {
                sb.append("RETURNING CONTENT");
                break;
            }
            case 1: {
                sb.append("RETURNING SEQUENCE");
                break;
            }
        }
    }

    protected void appendSpecificSQL(XMLNullHandlingType nullHandlingType, StringBuffer sb) {
        int type = nullHandlingType.getValue();
        switch (type) {
            case 0: {
                sb.append("ABSENT ON NULL");
                break;
            }
            case 1: {
                sb.append("EMPTY ON NULL");
                break;
            }
            case 2: {
                sb.append("NIL ON NO CONTENT");
                break;
            }
            case 3: {
                sb.append("NIL ON NULL");
                break;
            }
            case 4: {
                sb.append("NULL ON NULL");
                break;
            }
        }
    }

    protected void appendSpecificSQL(XMLWhitespaceHandlingType whiteSpaceHandlingType, StringBuffer sb) {
        int type = whiteSpaceHandlingType.getValue();
        switch (type) {
            case 0: {
                sb.append("PRESERVE WHITESPACE");
                break;
            }
            case 1: {
                sb.append("STRIP WHITESPACE");
                break;
            }
        }
    }

    protected void appendSpecificSQL(XMLAggregateFunction aggFunction, StringBuffer sb) {
        XMLReturningType type;
        this.appendKeyword(sb, "XMLAGG");
        this.appendSymbol(sb, '(');
        this.appendSQLForSQLObjectList((List)aggFunction.getParameterList(), sb);
        EList sortSpecList = aggFunction.getSortSpecList();
        if (sortSpecList != null && !sortSpecList.isEmpty()) {
            this.appendSpace(sb);
            this.appendKeyword(sb, "ORDER BY");
            this.appendSpace(sb);
            this.appendSQLForSQLObjectList((List)aggFunction.getSortSpecList(), sb);
        }
        if ((type = aggFunction.getReturningOption()) != XMLReturningType.NONE_LITERAL) {
            this.appendSpace(sb);
            this.appendSpecificSQL(type, sb);
        }
        this.appendSymbol(sb, ')');
    }

    protected void appendSpecificSQL(XMLAggregateSortSpecification sortSpec, StringBuffer sb) {
        this.appendSQL((SQLQueryObject)sortSpec.getOrderBySpec(), sb);
    }

    protected void appendSpecificSQL(XMLAttributesDeclaration attributesDecl, StringBuffer sb) {
        EList list = attributesDecl.getAttributeDeclItem();
        if (!list.isEmpty()) {
            sb.append("XMLATTRIBUTES");
            sb.append('(');
            this.appendSQLForSQLObjectList((List)list, sb);
            sb.append(')');
        }
    }

    protected void appendSpecificSQL(XMLAttributeDeclarationItem attributesDeclItem, StringBuffer sb) {
        this.appendSQL((SQLQueryObject)attributesDeclItem.getValueExpr(), sb);
        if (attributesDeclItem.getName() != null) {
            sb.append(' ');
            sb.append("AS");
            sb.append(' ');
            sb.append(attributesDeclItem.getName());
        }
    }

    protected void appendSpecificSQL(XMLValueFunctionElement elementFunction, StringBuffer sb) {
        XMLReturningType returningOption;
        XMLValueFunctionElementContentList elementContentList;
        int indent = this.getLastLineIndent(sb) + 2;
        if (!this.isLastLineEmpty(sb)) {
            sb.append('\n');
            this.appendSpace(sb, indent);
        }
        sb.append("XMLELEMENT");
        sb.append(' ');
        sb.append('(');
        sb.append("NAME");
        sb.append(' ');
        sb.append(elementFunction.getElementName());
        if (elementFunction.getNamespacesDecl() != null) {
            sb.append(',');
            this.appendWithConditionalLineBreaks((SQLObject)elementFunction.getNamespacesDecl(), sb, indent, this.displayWidth);
        }
        if (elementFunction.getAttributesDecl() != null) {
            sb.append(',');
            sb.append(' ');
            this.appendSpecificSQL(elementFunction.getAttributesDecl(), sb);
        }
        if ((elementContentList = elementFunction.getElementContentList()) != null) {
            this.appendSQL(elementContentList, sb);
        }
        if ((returningOption = elementFunction.getReturningOption()) != XMLReturningType.NONE_LITERAL) {
            sb.append(' ');
            this.appendSpecificSQL(returningOption, sb);
        }
        sb.append(')');
    }

    protected void appendSpecificSQL(XMLPredicateExists existsPredicate, StringBuffer sb) {
        sb.append("XMLEXISTS");
        sb.append('(');
        XMLQueryExpression queryExpr = existsPredicate.getXqueryExpr();
        this.appendSQL(queryExpr, sb);
        XMLQueryArgumentList argList = existsPredicate.getXqueryArgList();
        if (argList != null) {
            sb.append(' ');
            this.appendSQL(argList, sb);
        }
        sb.append(')');
    }

    protected void appendSpecificSQL(XMLValueFunctionForest forestFunction, StringBuffer sb) {
        XMLReturningType returningType;
        sb.append("XMLFOREST");
        sb.append('(');
        XMLNamespacesDeclaration namespacesDecl = forestFunction.getNamespacesDecl();
        if (namespacesDecl != null) {
            sb.append(' ');
            this.appendSQL(namespacesDecl, sb);
            sb.append(',');
            sb.append(' ');
        }
        EList contentItemList = forestFunction.getForestContentList();
        this.appendSQLForSQLObjectList((List)contentItemList, sb);
        XMLNullHandlingType nullHandlingType = forestFunction.getNullHandlingOption();
        if (nullHandlingType != XMLNullHandlingType.NONE_LITERAL) {
            sb.append(' ');
            sb.append("OPTION");
            sb.append(' ');
            this.appendSpecificSQL(nullHandlingType, sb);
        }
        if ((returningType = forestFunction.getReturningOption()) != XMLReturningType.NONE_LITERAL) {
            sb.append(' ');
            this.appendSpecificSQL(returningType, sb);
        }
        sb.append(')');
    }

    protected void appendSpecificSQL(XMLValueFunctionForestContentItem forestContentItem, StringBuffer sb) {
        this.appendSQL((SQLQueryObject)forestContentItem.getValueExpr(), sb);
        String name = forestContentItem.getName();
        if (name != null) {
            sb.append(' ');
            sb.append("AS");
            sb.append(' ');
            sb.append(name);
        }
    }

    protected void appendSpecificSQL(XMLNamespacesDeclaration namespaceDecl, StringBuffer sb) {
        EList declItemList = namespaceDecl.getNamespaceDecltemList();
        if (!declItemList.isEmpty()) {
            sb.append("XMLNAMESPACES");
            sb.append('(');
            this.appendSQLForSQLObjectList((List)declItemList, sb);
            sb.append(')');
        }
    }

    protected void appendSpecificSQL(XMLNamespaceDeclarationItem namespaceDecItem, StringBuffer sb) {
        if (namespaceDecItem instanceof XMLNamespaceDeclarationPrefix) {
            sb.append(namespaceDecItem.getUri());
            sb.append(' ');
            sb.append("AS");
            sb.append(' ');
            sb.append(((XMLNamespaceDeclarationPrefix)namespaceDecItem).getPrefix());
        } else if (namespaceDecItem instanceof XMLNamespaceDeclarationDefault) {
            if (((XMLNamespaceDeclarationDefault)namespaceDecItem).isNoDefault()) {
                sb.append("DEFAULT");
                sb.append(' ');
                sb.append(namespaceDecItem.getUri());
            } else {
                sb.append("NO DEFAULT");
            }
        }
    }

    protected void appendSpecificSQL(XMLNamespaceDeclarationDefault namespaceDefault, StringBuffer sb) {
        if (!namespaceDefault.isNoDefault()) {
            sb.append("DEFAULT");
            sb.append(' ');
            sb.append(namespaceDefault.getUri());
        } else {
            sb.append("NO DEFAULT");
        }
    }

    protected void appendSpecificSQL(XMLNamespaceDeclarationPrefix namespacePrefix, StringBuffer sb) {
        sb.append(namespacePrefix.getUri());
        sb.append(' ');
        sb.append("AS");
        sb.append(' ');
        sb.append(namespacePrefix.getPrefix());
    }

    protected void appendSpecificSQL(XMLValueFunctionElementContentItem elementContent, StringBuffer sb) {
        QueryValueExpression expr = elementContent.getValueExpr();
        this.appendSQL((SQLQueryObject)expr, sb);
    }

    protected void appendSpecificSQL(XMLValueFunctionElementContentList elementContentList, StringBuffer sb) {
        if (elementContentList != null) {
            XMLNullHandlingType nullType;
            EList contentListChildren = elementContentList.getElementContentListChildren();
            if (!contentListChildren.isEmpty()) {
                sb.append(',');
                sb.append(' ');
                this.appendSQLForSQLObjectList((List)contentListChildren, sb);
            }
            if ((nullType = elementContentList.getNullHandlingOption()) != XMLNullHandlingType.NONE_LITERAL) {
                sb.append(' ');
                sb.append("OPTION");
                sb.append(' ');
                this.appendSpecificSQL(nullType, sb);
            }
        }
    }

    protected void appendSpecificSQL(XMLSerializeFunction xmlSerializeFunction, StringBuffer sb) {
        DataType asDataType = xmlSerializeFunction.getDataType();
        String serializeVersion = xmlSerializeFunction.getSerializeVersion();
        XMLDeclarationType declType = xmlSerializeFunction.getDeclarationOption();
        XMLSerializeFunctionEncoding serializeEncoding = xmlSerializeFunction.getSerializeEncoding();
        int indent = this.getLastLineIndent(sb) + 2;
        sb.append("XMLSERIALIZE");
        sb.append('(');
        this.appendSpecificSQL(xmlSerializeFunction.getContentOption(), sb);
        this.indentOnNewLine(sb, indent);
        this.appendSQL((SQLQueryObject)xmlSerializeFunction.getSerializeTarget(), sb);
        sb.append(' ');
        sb.append("AS");
        sb.append(' ');
        if (asDataType == null) {
            asDataType = xmlSerializeFunction.getSerializeTarget().getDataType();
        }
        this.appendSQL((SQLObject)asDataType, sb);
        this.indentOnNewLine(sb, indent);
        if (serializeEncoding != null && serializeEncoding.getEncodingName() != null) {
            sb.append(' ');
            sb.append("ENCODING");
            sb.append(' ');
            sb.append(serializeEncoding.getEncodingName());
        }
        if (serializeVersion != null) {
            sb.append(' ');
            sb.append("VERSION");
            sb.append(' ');
            sb.append(serializeVersion);
        }
        if (declType != null && declType != XMLDeclarationType.NONE_LITERAL) {
            sb.append(' ');
            this.appendSpecificSQL(declType, sb);
        }
        sb.append(')');
    }

    protected void appendSpecificSQL(XMLSerializeFunctionTarget xmlSerializeFunctionTarget, StringBuffer sb) {
        this.appendSQL((SQLQueryObject)xmlSerializeFunctionTarget.getValueExpr(), sb);
    }

    protected void appendSpecificSQL(XMLQueryArgumentItem xQueryArgument, StringBuffer sb) {
        XMLPassingType passingMechanism;
        this.appendSQL((SQLQueryObject)xQueryArgument.getValueExpr(), sb);
        String variableName = xQueryArgument.getName();
        if (variableName != null) {
            sb.append(' ');
            sb.append("AS");
            sb.append(' ');
            sb.append(variableName);
        }
        if ((passingMechanism = xQueryArgument.getPassingMechanism()) != XMLPassingType.NONE_LITERAL) {
            sb.append(' ');
            this.appendSpecificSQL(passingMechanism, sb);
        }
    }

    protected void appendSpecificSQL(XMLQueryArgumentList xQueryArgList, StringBuffer sb) {
        sb.append("PASSING");
        sb.append(' ');
        this.appendSpecificSQL(xQueryArgList.getPassingMechanism(), sb);
        sb.append(' ');
        this.appendSQLForSQLObjectList((List)xQueryArgList.getXqueryArgListChildren(), sb);
    }

    protected void appendSpecificSQL(XMLQueryExpression queryExpr, StringBuffer sb) {
        sb.append(queryExpr.getXqueryExprContent());
    }

    protected void appendSpecificSQL(XMLValueExpressionCast xmlCastExpr, StringBuffer sb) {
        StringBuffer sbCast = new StringBuffer();
        sbCast.append("XMLCAST");
        sbCast.append(' ');
        sbCast.append('(');
        this.appendSQL((SQLQueryObject)xmlCastExpr.getValueExpr(), sbCast);
        sbCast.append(' ');
        sbCast.append("AS");
        sbCast.append(' ');
        this.appendSQL((SQLObject)xmlCastExpr.getDataType(), sbCast);
        XMLPassingType passingMechanism = xmlCastExpr.getPassingMechanism();
        if (passingMechanism != XMLPassingType.NONE_LITERAL) {
            sbCast.append(' ');
            this.appendSpecificSQL(xmlCastExpr.getPassingMechanism(), sbCast);
        }
        sbCast.append(')');
        this.wrapSQL((QueryValueExpression)xmlCastExpr, sbCast);
        sb.append(sbCast);
    }

    protected void appendSpecificSQL(XMLValueFunctionComment commentFunction, StringBuffer sb) {
        sb.append("XMLCOMMENT");
        sb.append('(');
        XMLValueFunctionCommentContent content = commentFunction.getCommentContent();
        if (content != null) {
            this.appendSQL((SQLQueryObject)content.getValueExpr(), sb);
        }
        sb.append(' ');
        this.appendSpecificSQL(commentFunction.getReturningOption(), sb);
        sb.append(')');
    }

    protected void appendSpecificSQL(XMLValueFunctionConcat concatFunction, StringBuffer sb) {
        sb.append("XMLCONCAT");
        sb.append('(');
        this.appendSQLForSQLObjectList((List)concatFunction.getConcatContentList(), sb);
        sb.append(' ');
        this.appendSpecificSQL(concatFunction.getReturningOption(), sb);
        sb.append(')');
    }

    protected void appendSpecificSQL(XMLValueFunctionConcatContentItem concatItem, StringBuffer sb) {
        this.appendSQL((SQLQueryObject)concatItem.getValueExpr(), sb);
    }

    protected void appendSpecificSQL(XMLValueFunctionDocument documentFunction, StringBuffer sb) {
        XMLReturningType returningType;
        sb.append("XMLDOCUMENT");
        sb.append('(');
        XMLValueFunctionDocumentContent docContent = documentFunction.getDocumentContent();
        if (docContent != null) {
            this.appendSQL((SQLQueryObject)docContent.getValueExpr(), sb);
        }
        if ((returningType = documentFunction.getReturningOption()) != XMLReturningType.NONE_LITERAL) {
            sb.append(' ');
            this.appendSpecificSQL(returningType, sb);
        }
        sb.append(')');
    }

    protected void appendSpecificSQL(XMLValueFunctionParse parseFunction, StringBuffer sb) {
        int indent = this.getLastLineIndent(sb) + 2;
        sb.append("XMLPARSE");
        sb.append('(');
        this.appendSpecificSQL(parseFunction.getContentOption(), sb);
        sb.append(' ');
        StringBuffer contentSB = new StringBuffer();
        this.appendSQL((SQLQueryObject)parseFunction.getParseContent(), contentSB);
        this.indentSQL(contentSB, indent);
        sb.append(contentSB);
        XMLWhitespaceHandlingType whitespaceHandlingOption = parseFunction.getWhitespaceHandlingOption();
        if (whitespaceHandlingOption != XMLWhitespaceHandlingType.NONE_LITERAL) {
            this.indentOnNewLine(sb, indent);
            this.appendSpecificSQL(whitespaceHandlingOption, sb);
        }
        sb.append(')');
    }

    protected void appendSpecificSQL(XMLValueFunctionPI piFunction, StringBuffer sb) {
        XMLReturningType returningType;
        sb.append("XMLPI");
        sb.append('(');
        sb.append("NAME");
        sb.append(' ');
        sb.append(piFunction.getTargetName());
        XMLValueFunctionPIContent piContent = piFunction.getPIContent();
        if (piContent != null) {
            sb.append(',');
            sb.append(' ');
            this.appendSQL((SQLQueryObject)piContent.getValueExpr(), sb);
        }
        if ((returningType = piFunction.getReturningOption()) != XMLReturningType.NONE_LITERAL) {
            sb.append(' ');
            this.appendSpecificSQL(returningType, sb);
        }
        sb.append(')');
    }

    protected void appendSpecificSQL(XMLValueFunctionParseContent parseContent, StringBuffer sb) {
        this.appendSQL((SQLQueryObject)parseContent.getValueExpr(), sb);
    }

    protected void appendSpecificSQL(XMLValueFunctionQuery queryFunction, StringBuffer sb) {
        XMLEmptyHandlingType emptyHandlingOption;
        XMLValueFunctionQueryReturning returningClause;
        sb.append("XMLQUERY");
        sb.append('(');
        this.appendSQL(queryFunction.getXqueryExpr(), sb);
        XMLQueryArgumentList xqueryArgList = queryFunction.getXqueryArgList();
        if (xqueryArgList != null) {
            sb.append(' ');
            this.appendSQL(xqueryArgList, sb);
        }
        if ((returningClause = queryFunction.getQueryReturning()) != null) {
            sb.append(' ');
            this.appendSQL(returningClause, sb);
        }
        if ((emptyHandlingOption = queryFunction.getEmptyHandlingOption()) != XMLEmptyHandlingType.NONE_LITERAL) {
            sb.append(' ');
            this.appendSpecificSQL(emptyHandlingOption, sb);
        }
        sb.append(')');
    }

    protected void appendSpecificSQL(XMLValueFunctionQueryReturning queryReturning, StringBuffer sb) {
        this.appendSpecificSQL(queryReturning.getReturningOption(), sb);
        XMLPassingType passingOption = queryReturning.getPassingOption();
        if (passingOption != XMLPassingType.NONE_LITERAL) {
            sb.append(' ');
            this.appendSpecificSQL(passingOption, sb);
        }
    }

    protected void appendSpecificSQL(XMLTableColumnDefinitionDefault columnDefinitionDefault, StringBuffer sb) {
        sb.append("DEFAULT");
        sb.append(' ');
        this.appendSQL((SQLQueryObject)columnDefinitionDefault.getValueExpr(), sb);
    }

    protected void appendSpecificSQL(XMLTableColumnDefinitionOrdinality columnDefinitionOrdinality, StringBuffer sb) {
        String columnName = columnDefinitionOrdinality.getName();
        columnName = StatementHelper.convertCatalogIdentifierToSQLFormat((String)columnName, (char)this.getDelimitedIdentifierQuote());
        sb.append(columnName);
        sb.append(' ');
        sb.append("FOR ORDINALITY");
    }

    protected void appendSpecificSQL(XMLTableColumnDefinitionRegular columnDefinitionRegular, StringBuffer sb) {
        String tableColumnPattern;
        XMLTableColumnDefinitionDefault defaultClause;
        String columnName = columnDefinitionRegular.getName();
        columnName = StatementHelper.convertCatalogIdentifierToSQLFormat((String)columnName, (char)this.getDelimitedIdentifierQuote());
        sb.append(columnName);
        sb.append(' ');
        this.appendSQL((SQLObject)columnDefinitionRegular.getDataType(), sb);
        XMLPassingType passingOption = columnDefinitionRegular.getPassingOption();
        if (passingOption != XMLPassingType.NONE_LITERAL) {
            sb.append(' ');
            this.appendSpecificSQL(passingOption, sb);
        }
        if ((defaultClause = columnDefinitionRegular.getColumnDefinitionDefault()) != null) {
            sb.append(' ');
            this.appendSQL((SQLQueryObject)defaultClause, sb);
        }
        if ((tableColumnPattern = columnDefinitionRegular.getTableColumnPattern()) != null) {
            sb.append(' ');
            sb.append("PATH");
            sb.append(' ');
            sb.append(tableColumnPattern);
        }
    }

    protected void appendSpecificSQL(XMLTableFunction tableFunction, StringBuffer sb) {
        sb.append("XMLTABLE");
        sb.append('(');
        XMLNamespacesDeclaration namespacesDecl = tableFunction.getNamespacesDecl();
        if (namespacesDecl != null) {
            this.appendSQL(namespacesDecl, sb);
            sb.append(',');
            sb.append(' ');
        }
        sb.append(tableFunction.getTableRowPattern());
        XMLQueryArgumentList xQueryArgList = tableFunction.getXqueryArgList();
        if (xQueryArgList != null) {
            sb.append(' ');
            this.appendSQL(xQueryArgList, sb);
        }
        sb.append(' ');
        sb.append("COLUMNS");
        sb.append(' ');
        this.appendSQLForSQLObjectList((List)tableFunction.getColumnDefList(), sb);
        sb.append(')');
        if (tableFunction.getTableCorrelation() != null) {
            sb.append(' ');
            sb.append("AS");
            sb.append(' ');
            this.appendSQL((SQLQueryObject)tableFunction.getTableCorrelation(), sb);
        }
    }

    protected void appendSpecificSQL(XMLValueFunctionText textFunction, StringBuffer sb) {
        sb.append("XMLTEXT");
        sb.append('(');
        this.appendSQL((SQLQueryObject)textFunction.getTextContent(), sb);
        XMLReturningType returningType = textFunction.getReturningOption();
        if (returningType != XMLReturningType.NONE_LITERAL) {
            sb.append(' ');
            this.appendSpecificSQL(returningType, sb);
        }
        sb.append(')');
    }

    protected void appendSpecificSQL(XMLValueFunctionTextContent textContent, StringBuffer sb) {
        this.appendSQL((SQLQueryObject)textContent.getValueExpr(), sb);
    }

    protected void appendSpecificSQL(XMLValueFunctionValidate validateFunction, StringBuffer sb) {
        int indent = this.getLastLineIndent(sb) + 2;
        sb.append("XMLVALIDATE");
        sb.append('(');
        this.appendSpecificSQL(validateFunction.getContentOption(), sb);
        sb.append('\n');
        this.appendSpace(sb, indent);
        this.appendSQL((SQLQueryObject)validateFunction.getValidateContent(), sb);
        if (validateFunction.getValidateAccordingTo() != null) {
            this.indentOnNewLine(sb, indent);
            this.appendSQL(validateFunction.getValidateAccordingTo(), sb);
        }
        sb.append(')');
    }

    protected void appendSpecificSQL(XMLValueFunctionValidateAccordingToIdentifier accordingToIdentifier, StringBuffer sb) {
        sb.append("ACCORDING TO XMLSCHEMA");
        sb.append(' ');
        sb.append("ID");
        sb.append(' ');
        String schemaName = accordingToIdentifier.getSchemaName();
        String registeredXMLSchemaName = accordingToIdentifier.getRegisteredXMLSchemaName();
        if (schemaName != null) {
            schemaName = StatementHelper.convertCatalogIdentifierToSQLFormat((String)schemaName, (char)this.getDelimitedIdentifierQuote());
            sb.append(schemaName);
            sb.append('.');
        }
        registeredXMLSchemaName = StatementHelper.convertCatalogIdentifierToSQLFormat((String)registeredXMLSchemaName, (char)this.getDelimitedIdentifierQuote());
        sb.append(registeredXMLSchemaName);
        XMLValueFunctionValidateElement optValidateElement = accordingToIdentifier.getValidateElement();
        if (optValidateElement != null) {
            sb.append(' ');
            this.appendSQL(optValidateElement, sb);
        }
    }

    protected void appendSpecificSQL(XMLValueFunctionValidateAccordingToURI accordingToURI, StringBuffer sb) {
        XMLValueFunctionValidateElement optValidateElement;
        sb.append("ACCORDING TO XMLSCHEMA");
        sb.append(' ');
        if (accordingToURI.isNoNamespace()) {
            sb.append("NO NAMESPACE");
        } else {
            sb.append("URI");
            sb.append(' ');
            sb.append(accordingToURI.getTargetNamespaceURI());
        }
        String schemaLocationURI = accordingToURI.getSchemaLocationURI();
        if (schemaLocationURI != null) {
            sb.append(' ');
            sb.append("LOCATION");
            sb.append(' ');
            sb.append(schemaLocationURI);
        }
        if ((optValidateElement = accordingToURI.getValidateElement()) != null) {
            sb.append(' ');
            this.appendSQL(optValidateElement, sb);
        }
    }

    protected void appendSpecificSQL(XMLValueFunctionValidateContent validateFunctionContent, StringBuffer sb) {
        this.appendSQL((SQLQueryObject)validateFunctionContent.getValueExpr(), sb);
    }

    protected void appendSpecificSQL(XMLValueFunctionValidateElement validateElement, StringBuffer sb) {
        XMLValueFunctionValidateElementNamespace validateElementNamespace = validateElement.getValidateElementNamespace();
        XMLValueFunctionValidateElementName validateElementName = validateElement.getValidateElementName();
        if (validateElementNamespace != null) {
            this.appendSpecificSQL(validateElementNamespace, sb);
            if (validateElementName != null) {
                sb.append(' ');
            }
        }
        if (validateElementName != null) {
            this.appendSQL(validateElementName, sb);
        }
    }

    protected void appendSpecificSQL(XMLValueFunctionValidateElementName validateElementName, StringBuffer sb) {
        sb.append("ELEMENT");
        sb.append(' ');
        sb.append(validateElementName.getName());
    }

    protected void appendSpecificSQL(XMLValueFunctionValidateElementNamespace validateElementNS, StringBuffer sb) {
        if (validateElementNS.isNoNamespace()) {
            sb.append("NO NAMESPACE");
        } else {
            sb.append("NAMESPACE");
            sb.append(' ');
            sb.append(validateElementNS.getNamespaceURI());
        }
    }
}

