/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions.selection;

import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.selection.ISQLSelection;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;

public class BlankLineSelection
implements ISQLSelection {
    private SQLEditor _sqlEditor;

    public BlankLineSelection(SQLEditor editor) {
        this._sqlEditor = editor;
    }

    @Override
    public String getStatements() {
        IRegion lineInfo;
        String selectedText = null;
        IDocument doc = this._sqlEditor.getDocumentProvider().getDocument((Object)this._sqlEditor.getEditorInput());
        ITextSelection selection = (ITextSelection)this._sqlEditor.getSelectionProvider().getSelection();
        int currentLine = selection.getStartLine();
        int totalLine = doc.getNumberOfLines();
        int startLine = currentLine;
        int endLine = currentLine;
        String lineText = null;
        while (startLine > 0) {
            try {
                lineInfo = doc.getLineInformation(startLine);
                lineText = doc.get(lineInfo.getOffset(), lineInfo.getLength());
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
            if (lineText.trim().length() == 0) break;
            --startLine;
        }
        while (endLine < totalLine - 1) {
            try {
                lineInfo = doc.getLineInformation(endLine);
                lineText = doc.get(lineInfo.getOffset(), lineInfo.getLength());
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
            if (lineText.trim().length() == 0) break;
            ++endLine;
        }
        try {
            int startOffset = doc.getLineOffset(startLine);
            int endOffset = doc.getLineOffset(endLine) + doc.getLineLength(endLine);
            selectedText = doc.get(startOffset, endOffset - startOffset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return selectedText;
    }
}

