/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.format;

import java.util.ConcurrentModificationException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ServerMessageHandler;
import org.eclipse.lsp4e.operations.format.LSPFormatter;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPFormatHandler
extends AbstractHandler {
    private final LSPFormatter formatter = new LSPFormatter();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (part instanceof MultiPageEditorPart var3_4 && ( instanceOfPatternExpressionValue = (selectedPage = multoPage.getSelectedPage())) instanceof IEditorPart && (var6_7 = (IEditorPart) instanceOfPatternExpressionValue) == (IEditorPart) instanceOfPatternExpressionValue) {
            part = editor;
        }
        if (( instanceOfPatternExpressionValue = part) instanceof ITextEditor && (selectedPage = (ITextEditor) instanceOfPatternExpressionValue) == (ITextEditor) instanceOfPatternExpressionValue) {
            IDocument document = LSPEclipseUtils.getDocument((ITextEditor)textEditor);
            Shell shell = textEditor.getSite().getShell();
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (document != null && ( instanceOfPatternExpressionValue = selection) instanceof ITextSelection var10_11) {
                LSPFormatter.VersionedFormatRequest versionedEdits = this.formatter.versionedRequestFormatting(document, (ITextSelection)textSelection);
                versionedEdits.edits().thenAcceptAsync(edits -> {
                    if (!edits.isEmpty()) {
                        shell.getDisplay().asyncExec(() -> {
                            try {
                                this.formatter.applyEdits(document, (List<? extends TextEdit>)edits, versionedEdits.version());
                            }
                            catch (ConcurrentModificationException e) {
                                ServerMessageHandler.showMessage(Messages.LSPFormatHandler_DiscardedFormat, new MessageParams(MessageType.Error, Messages.LSPFormatHandler_DiscardedFormatResponse));
                            }
                        });
                    }
                });
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled() {
        IWorkbenchPart iWorkbenchPart;
        void multiPage;
        Object selectedPage;
        void var3_2;
        MultiPageEditorPart multiPageEditorPart;
        IWorkbenchPart part = UI.getActivePart();
        IWorkbenchPart iWorkbenchPart2 = part;
        if (iWorkbenchPart2 instanceof MultiPageEditorPart && (multiPageEditorPart = (MultiPageEditorPart)iWorkbenchPart2) == (MultiPageEditorPart)var3_2 && ( instanceOfPatternExpressionValue = (selectedPage = multiPage.getSelectedPage())) instanceof IWorkbenchPart && (iWorkbenchPart = (IWorkbenchPart) instanceOfPatternExpressionValue) == (IWorkbenchPart) instanceOfPatternExpressionValue) {
            void workbenchPart;
            part = workbenchPart;
        }
        if (( instanceOfPatternExpressionValue = part) instanceof ITextEditor && (selectedPage = (ITextEditor) instanceOfPatternExpressionValue) == (ITextEditor) instanceOfPatternExpressionValue) {
            void textEditor;
            List<LanguageServiceAccessor.LSPDocumentInfo> infos = LanguageServiceAccessor.getLSPDocumentInfosFor(LSPEclipseUtils.getDocument((ITextEditor)textEditor), LSPFormatter::supportFormatting);
            ISelection selection = textEditor.getSelectionProvider().getSelection();
            return !infos.isEmpty() && !selection.isEmpty() && selection instanceof ITextSelection;
        }
        return false;
    }
}

