/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.embedder;

import java.io.Serializable;
import org.apache.maven.artifact.Artifact;
import org.eclipse.osgi.util.NLS;

public record ArtifactKey(String groupId, String artifactId, String version, String classifier) implements Serializable
{
    public ArtifactKey(Artifact a) {
        this(a.getGroupId(), a.getArtifactId(), a.getBaseVersion(), null);
    }

    @Override
    public String toString() {
        return String.valueOf(this.groupId) + ':' + this.artifactId + ':' + this.version + ArtifactKey.toString(this.classifier);
    }

    public static ArtifactKey fromPortableString(String str) {
        int p = 0;
        int c = ArtifactKey.nextColonIndex(str, p);
        String groupId = ArtifactKey.substring(str, p, c);
        p = c + 1;
        c = ArtifactKey.nextColonIndex(str, p);
        String artifactId = ArtifactKey.substring(str, p, c);
        p = c + 1;
        c = ArtifactKey.nextColonIndex(str, p);
        String version = ArtifactKey.substring(str, p, c);
        p = c + 1;
        c = ArtifactKey.nextColonIndex(str, p);
        String classifier = ArtifactKey.substring(str, p, c);
        return new ArtifactKey(groupId, artifactId, version, classifier);
    }

    private static String substring(String str, int start, int end) {
        String substring = str.substring(start, end);
        return "".equals(substring) ? null : substring;
    }

    private static int nextColonIndex(String str, int pos) {
        int idx = str.indexOf(58, pos);
        if (idx < 0) {
            throw new IllegalArgumentException(NLS.bind((String)"Invalid portable string: {0}", (Object)str));
        }
        return idx;
    }

    public String toPortableString() {
        return String.valueOf(ArtifactKey.toString(this.groupId)) + ':' + ArtifactKey.toString(this.artifactId) + ':' + ArtifactKey.toString(this.version) + ':' + ArtifactKey.toString(this.classifier) + ':';
    }

    private static String toString(String s) {
        return s != null ? s : "";
    }
}

