/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.m2e.core.internal.embedder.PlexusContainerManager;
import org.eclipse.m2e.core.project.IProjectConfiguration;

public class ResolverConfiguration
implements Serializable,
IProjectConfiguration {
    private static final long serialVersionUID = 1258510761534886581L;
    private boolean resolveWorkspaceProjects = true;
    private String selectedProfiles = "";
    private String lifecycleMappingId;
    private Properties properties;
    private File multiModuleProjectDirectory;

    public ResolverConfiguration() {
    }

    public ResolverConfiguration(IProject project) {
        this.setMultiModuleProjectDirectory(PlexusContainerManager.computeMultiModuleProjectDirectory(project.getLocation().toFile()));
    }

    public ResolverConfiguration(IProjectConfiguration resolverConfiguration) {
        this.setLifecycleMappingId(resolverConfiguration.getLifecycleMappingId());
        this.setMultiModuleProjectDirectory(resolverConfiguration.getMultiModuleProjectDirectory());
        Properties properties2 = new Properties();
        properties2.putAll(resolverConfiguration.getConfigurationProperties());
        this.setProperties(properties2);
        this.setResolveWorkspaceProjects(resolverConfiguration.isResolveWorkspaceProjects());
        this.setSelectedProfiles(resolverConfiguration.getSelectedProfiles());
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, String> getConfigurationProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        Set<String> names = this.properties.stringPropertyNames();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : names) {
            map.put(key, this.properties.getProperty(key));
        }
        return Collections.unmodifiableMap(map);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Deprecated(forRemoval=true)
    public boolean shouldResolveWorkspaceProjects() {
        return this.isResolveWorkspaceProjects();
    }

    @Override
    public boolean isResolveWorkspaceProjects() {
        return this.resolveWorkspaceProjects;
    }

    @Override
    public String getSelectedProfiles() {
        return this.selectedProfiles;
    }

    public void setResolveWorkspaceProjects(boolean resolveWorkspaceProjects) {
        this.resolveWorkspaceProjects = resolveWorkspaceProjects;
    }

    public void setSelectedProfiles(String profiles) {
        this.selectedProfiles = profiles;
    }

    @Override
    public String getLifecycleMappingId() {
        return this.lifecycleMappingId;
    }

    public void setLifecycleMappingId(String lifecycleMappingId) {
        this.lifecycleMappingId = lifecycleMappingId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ResolverConfiguration other = (ResolverConfiguration)obj;
        return this.resolveWorkspaceProjects == other.resolveWorkspaceProjects && Objects.equals(this.selectedProfiles, other.selectedProfiles) && Objects.equals(this.lifecycleMappingId, other.lifecycleMappingId) && Objects.equals(this.properties, other.properties) && Objects.equals(this.multiModuleProjectDirectory, other.multiModuleProjectDirectory);
    }

    public int hashCode() {
        return Objects.hash(this.resolveWorkspaceProjects, this.selectedProfiles, this.lifecycleMappingId, this.properties, this.multiModuleProjectDirectory);
    }

    @Override
    public File getMultiModuleProjectDirectory() {
        return this.multiModuleProjectDirectory;
    }

    public void setMultiModuleProjectDirectory(File multiModuleProjectDirectory) {
        this.multiModuleProjectDirectory = multiModuleProjectDirectory;
    }
}

