/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.tests.common;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class FileHelpers {
    public static void copyDir(File src, File dst) throws IOException {
        FileHelpers.copyDir(src, dst, pathname -> !".svn".equals(pathname.getName()));
    }

    public static void copyDir(File src, File dst, FileFilter filter) throws IOException {
        FileHelpers.copyDir(src, dst, filter, true);
    }

    private static void copyDir(File src, File dst, FileFilter filter, boolean deleteDst) throws IOException {
        if (!src.isDirectory()) {
            throw new IllegalArgumentException("Not a directory:" + src.getAbsolutePath());
        }
        if (deleteDst) {
            FileUtils.deleteDirectory((File)dst);
        }
        dst.mkdirs();
        File[] files = src.listFiles(filter);
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.canRead()) {
                    File dstChild = new File(dst, file.getName());
                    if (file.isDirectory()) {
                        FileHelpers.copyDir(file, dstChild, filter, false);
                    } else {
                        FileHelpers.copyFile(file, dstChild);
                    }
                }
                ++n2;
            }
        }
    }

    private static void copyFile(File src, File dst) throws IOException {
        Files.copy(src.toPath(), dst.toPath(), new CopyOption[0]);
    }

    public static void filterXmlFile(File src, File dst, Map<String, String> tokens) throws IOException {
        String text;
        Throwable throwable = null;
        Iterator<Map.Entry<String, String>> iterator = null;
        try (XmlStreamReader reader = ReaderFactory.newXmlReader((File)src);){
            text = IOUtil.toString((Reader)reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        for (Map.Entry<String, String> entry : tokens.entrySet()) {
            text = text.replace(entry.getKey(), entry.getValue());
        }
        dst.getParentFile().mkdirs();
        throwable = null;
        iterator = null;
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)dst);){
            writer.write(text);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static boolean deleteDirectory(File directory) {
        try {
            FileUtils.deleteDirectory((File)directory);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

