/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.pinclone;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.internal.ui.pinclone.DebugContextPinProvider;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class DebugEventFilterService {
    private static DebugEventFilterService INSTANCE;
    private Map<IWorkbenchPart, DebugEventFilter> fFilterMap = new HashMap<IWorkbenchPart, DebugEventFilter>();

    private DebugEventFilterService() {
    }

    public static synchronized DebugEventFilterService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DebugEventFilterService();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugContextPinProvider addDebugEventFilter(IWorkbenchPart part, ISelection debugContext) {
        DebugContextPinProvider contextProvider = null;
        DebugEventFilter filter = null;
        Map<IWorkbenchPart, DebugEventFilter> map = this.fFilterMap;
        synchronized (map) {
            block5: {
                if (!this.fFilterMap.containsKey(part)) break block5;
                return null;
            }
            contextProvider = new DebugContextPinProvider(part, debugContext);
            filter = new DebugEventFilter(contextProvider);
            this.fFilterMap.put(part, filter);
        }
        assert (contextProvider != null && filter != null);
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(part.getSite().getWorkbenchWindow());
        contextService.addDebugContextProvider((IDebugContextProvider)contextProvider);
        contextService.addDebugContextListener((IDebugContextListener)filter);
        return contextProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDebugEventFilter(IWorkbenchPart part) {
        DebugEventFilter filter = null;
        Map<IWorkbenchPart, DebugEventFilter> map = this.fFilterMap;
        synchronized (map) {
            if (!this.fFilterMap.containsKey(part)) {
                return;
            }
            filter = this.fFilterMap.remove(part);
        }
        assert (filter != null);
        DebugContextPinProvider contextProvider = filter.getTranslator();
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(part.getSite().getWorkbenchWindow());
        contextProvider.delegateEvent(new DebugContextEvent((IDebugContextProvider)contextProvider, contextService.getActiveContext(), 1));
        contextService.removeDebugContextListener((IDebugContextListener)filter);
        contextService.removeDebugContextProvider((IDebugContextProvider)contextProvider);
        contextProvider.dispose();
    }

    private class DebugEventFilter
    implements IDebugContextListener {
        private final DebugContextPinProvider fProvider;

        private DebugEventFilter(DebugContextPinProvider provider) {
            this.fProvider = provider;
        }

        public void debugContextChanged(DebugContextEvent event) {
            ISelection eventContext = event.getContext();
            if (eventContext instanceof IStructuredSelection) {
                ArrayList filteredContextList = new ArrayList();
                List eventContextList = ((IStructuredSelection)eventContext).toList();
                for (Object o : eventContextList) {
                    if (!this.fProvider.isPinnedTo(o) || this.fProvider == event.getDebugContextProvider()) continue;
                    filteredContextList.add(o);
                }
                if (filteredContextList.size() > 0) {
                    this.fProvider.delegateEvent(new DebugContextEvent((IDebugContextProvider)this.fProvider, (ISelection)new StructuredSelection(filteredContextList), event.getFlags()));
                }
            }
        }

        public DebugContextPinProvider getTranslator() {
            return this.fProvider;
        }
    }
}

