/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import java.io.Serializable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class Dimension
implements Cloneable,
Serializable,
Translatable {
    private static final long serialVersionUID = 1L;
    public static final Dimension SINGLETON = new Dimension();
    public int width;
    public int height;

    public static Dimension max(Dimension d1, Dimension d2) {
        return new Dimension(Math.max(d1.width(), d2.width()), Math.max(d1.height(), d2.height()));
    }

    public static Dimension min(Dimension d1, Dimension d2) {
        return new Dimension(Math.min(d1.width(), d2.width()), Math.min(d1.height(), d2.height()));
    }

    public Dimension() {
    }

    public Dimension(Dimension d) {
        this.width = d.width();
        this.height = d.height();
    }

    public Dimension(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public Dimension(Image image) {
        Rectangle r = image.getBounds();
        this.width = r.width;
        this.height = r.height;
    }

    public Dimension(org.eclipse.swt.graphics.Point p) {
        this.width = p.x;
        this.height = p.y;
    }

    public boolean contains(Dimension d) {
        return this.width >= d.width() && this.height >= d.height();
    }

    public boolean containsProper(Dimension d) {
        return this.width > d.width() && this.height > d.height();
    }

    public boolean equals(int w, int h) {
        return this.width == w && this.height == h;
    }

    public boolean equals(Object o) {
        if (o instanceof Dimension) {
            Dimension d = (Dimension)o;
            return d.width() == this.width && d.height() == this.height;
        }
        return false;
    }

    public Dimension expand(Dimension d) {
        return this.expand(d.width(), d.height());
    }

    public Dimension expand(double w, double h) {
        return this.expand((int)w, (int)h);
    }

    public Dimension expand(int w, int h) {
        this.width += w;
        this.height += h;
        return this;
    }

    public Dimension expand(Point p) {
        return this.expand(p.x(), p.y());
    }

    public int getArea() {
        return this.width * this.height;
    }

    public Dimension getCopy() {
        return new Dimension(this);
    }

    public Dimension getDifference(Dimension d) {
        return this.getShrinked(d);
    }

    public Dimension getExpanded(Dimension d) {
        return this.getCopy().expand(d);
    }

    public Dimension getExpanded(double w, double h) {
        return this.getCopy().expand(w, h);
    }

    public Dimension getExpanded(int w, int h) {
        return this.getCopy().expand(w, h);
    }

    public Dimension getIntersected(Dimension d) {
        return this.getCopy().intersect(d);
    }

    public Dimension getNegated() {
        return this.getCopy().negate();
    }

    public Dimension getScaled(double amount) {
        return this.getCopy().scale(amount);
    }

    public Dimension getShrinked(Dimension d) {
        return this.getCopy().shrink(d);
    }

    public Dimension getShrinked(double w, double h) {
        return this.getCopy().shrink(w, h);
    }

    public Dimension getShrinked(int w, int h) {
        return this.getCopy().shrink(w, h);
    }

    public Dimension getTransposed() {
        return this.getCopy().transpose();
    }

    public Dimension getUnioned(Dimension d) {
        return this.getUnioned(d.width(), d.height());
    }

    public Dimension getUnioned(int w, int h) {
        return this.getCopy().union(w, h);
    }

    public int hashCode() {
        return this.width * this.height ^ this.width + this.height;
    }

    public int height() {
        return this.height;
    }

    public Dimension intersect(Dimension d) {
        this.width = Math.min(d.width(), this.width);
        this.height = Math.min(d.height(), this.height);
        return this;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public Dimension negate() {
        return this.scale(-1.0);
    }

    @Override
    public void performScale(double factor) {
        this.scale(factor);
    }

    @Override
    public void performTranslate(int dx, int dy) {
    }

    public double preciseHeight() {
        return this.height;
    }

    public double preciseWidth() {
        return this.width;
    }

    public Dimension scale(double factor) {
        return this.scale(factor, factor);
    }

    public Dimension scale(double widthFactor, double heightFactor) {
        this.width = (int)Math.floor((double)this.width * widthFactor);
        this.height = (int)Math.floor((double)this.height * heightFactor);
        return this;
    }

    public Dimension setHeight(int height) {
        this.height = height;
        return this;
    }

    public void setSize(Dimension d) {
        this.width = d.width();
        this.height = d.height();
    }

    public Dimension setSize(int w, int h) {
        this.width = w;
        this.height = h;
        return this;
    }

    public Dimension setWidth(int width) {
        this.width = width;
        return this;
    }

    public Dimension shrink(Dimension d) {
        return this.shrink(d.width(), d.height());
    }

    public Dimension shrink(double w, double h) {
        return this.shrink((int)w, (int)h);
    }

    public Dimension shrink(int w, int h) {
        this.width -= w;
        this.height -= h;
        return this;
    }

    public String toString() {
        return "Dimension(" + this.preciseWidth() + ", " + this.preciseHeight() + ")";
    }

    public Dimension transpose() {
        int temp = this.width;
        this.width = this.height;
        this.height = temp;
        return this;
    }

    public Dimension union(Dimension d) {
        return this.union(d.width, d.height);
    }

    public Dimension union(int w, int h) {
        this.width = Math.max(this.width, w);
        this.height = Math.max(this.height, h);
        return this;
    }

    public int width() {
        return this.width;
    }
}

