/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PatternStyle implements Enumerator
{
    EXACT(0, "EXACT", "EXACT"),
    TREE(1, "TREE", "TREE"),
    ANT(2, "ANT", "ANT"),
    REGEX(3, "REGEX", "REGEX");

    public static final int EXACT_VALUE = 0;
    public static final int TREE_VALUE = 1;
    public static final int ANT_VALUE = 2;
    public static final int REGEX_VALUE = 3;
    private static final PatternStyle[] VALUES_ARRAY;
    public static final List<PatternStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PatternStyle[]{EXACT, TREE, ANT, REGEX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PatternStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PatternStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PatternStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PatternStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PatternStyle get(int value) {
        switch (value) {
            case 0: {
                return EXACT;
            }
            case 1: {
                return TREE;
            }
            case 2: {
                return ANT;
            }
            case 3: {
                return REGEX;
            }
        }
        return null;
    }

    private PatternStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

