/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.style;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ClusterStyle implements Enumerator
{
    BOLD(0, "bold", "bold"),
    DASHED(1, "dashed", "dashed"),
    DOTTED(2, "dotted", "dotted"),
    FILLED(3, "filled", "filled"),
    INVIS(4, "invis", "invis"),
    RADIAL(5, "radial", "radial"),
    ROUNDED(6, "rounded", "rounded"),
    SOLID(7, "solid", "solid"),
    STRIPED(8, "striped", "striped");

    public static final int BOLD_VALUE = 0;
    public static final int DASHED_VALUE = 1;
    public static final int DOTTED_VALUE = 2;
    public static final int FILLED_VALUE = 3;
    public static final int INVIS_VALUE = 4;
    public static final int RADIAL_VALUE = 5;
    public static final int ROUNDED_VALUE = 6;
    public static final int SOLID_VALUE = 7;
    public static final int STRIPED_VALUE = 8;
    private static final ClusterStyle[] VALUES_ARRAY;
    public static final List<ClusterStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ClusterStyle[]{BOLD, DASHED, DOTTED, FILLED, INVIS, RADIAL, ROUNDED, SOLID, STRIPED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ClusterStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClusterStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClusterStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClusterStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClusterStyle get(int value) {
        switch (value) {
            case 0: {
                return BOLD;
            }
            case 1: {
                return DASHED;
            }
            case 2: {
                return DOTTED;
            }
            case 3: {
                return FILLED;
            }
            case 4: {
                return INVIS;
            }
            case 5: {
                return RADIAL;
            }
            case 6: {
                return ROUNDED;
            }
            case 7: {
                return SOLID;
            }
            case 8: {
                return STRIPED;
            }
        }
        return null;
    }

    private ClusterStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

