/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerHostConfig;

public class CloseableContainer
implements AutoCloseable {
    public final String containerId;
    private final IDockerConnection connection;

    public CloseableContainer(IDockerConnection connection, String image) throws DockerException, InterruptedException {
        this.connection = connection;
        DockerContainerConfig.Builder builder = new DockerContainerConfig.Builder().cmd("sleep 3600").image(image);
        DockerContainerConfig config = builder.build();
        DockerHostConfig.Builder hostBuilder = new DockerHostConfig.Builder();
        hostBuilder.autoRemove(true);
        IDockerHostConfig hostConfig = hostBuilder.build();
        this.containerId = connection.createContainer(config, hostConfig, null);
    }

    public void start() throws DockerException, InterruptedException {
        this.connection.startContainer(this.containerId, null);
    }

    @Override
    public void close() throws DockerException, InterruptedException {
        try {
            this.connection.killContainer(this.containerId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection.removeContainer(this.containerId);
    }
}

