/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerPortMapping;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.DockerConnectionWatcher;
import org.eclipse.linuxtools.internal.docker.ui.consoles.RunConsole;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerContentProvider;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImageHierarchyView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImagesView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class CommandUtils {
    public static void asyncRefresh(Viewer viewer) {
        Display.getDefault().asyncExec(() -> {
            if (viewer != null && !viewer.getControl().isDisposed()) {
                viewer.refresh();
            }
        });
    }

    public static IDockerConnection getCurrentConnection(IWorkbenchPart activePart) {
        if (DockerConnectionWatcher.getInstance().getConnection() != null) {
            return DockerConnectionWatcher.getInstance().getConnection();
        }
        if (activePart instanceof DockerContainersView) {
            return ((DockerContainersView)activePart).getConnection();
        }
        if (activePart instanceof DockerImagesView) {
            return ((DockerImagesView)activePart).getConnection();
        }
        return Stream.of(DockerConnectionManager.getInstance().getConnections()).filter(c -> c.isOpen()).findFirst().orElse(null);
    }

    public static List<Object> getSelectedElements(IWorkbenchPart activePart) {
        return CommandUtils.getSelectedElements(activePart, Object.class);
    }

    public static Object getSelectedElement(IWorkbenchPart activePart) {
        List<Object> selectedElements = CommandUtils.getSelectedElements(activePart, Object.class);
        if (selectedElements != null && !selectedElements.isEmpty()) {
            return selectedElements.get(0);
        }
        return null;
    }

    private static <T> List<T> getSelectedElements(IWorkbenchPart activePart, Class<T> targetClass) {
        if (activePart instanceof DockerContainersView) {
            IStructuredSelection selection = ((DockerContainersView)activePart).getStructuredSelection();
            return CommandUtils.castSelectionTo(selection, targetClass);
        }
        if (activePart instanceof DockerImagesView) {
            IStructuredSelection selection = ((DockerImagesView)activePart).getStructuredSelection();
            return CommandUtils.castSelectionTo(selection, targetClass);
        }
        if (activePart instanceof DockerExplorerView) {
            ITreeSelection selection = ((DockerExplorerView)activePart).getCommonViewer().getStructuredSelection();
            return CommandUtils.castSelectionTo((IStructuredSelection)selection, targetClass);
        }
        if (activePart instanceof DockerImageHierarchyView) {
            ITreeSelection selection = ((DockerImageHierarchyView)activePart).getCommonViewer().getStructuredSelection();
            return CommandUtils.adaptSelectionTo((IStructuredSelection)selection, targetClass);
        }
        return Collections.emptyList();
    }

    public static List<IDockerContainer> getSelectedContainers(IWorkbenchPart activePart) {
        return CommandUtils.getSelectedElements(activePart, IDockerContainer.class);
    }

    public static List<IDockerPortMapping> getSelectedPortMappings(IWorkbenchPart activePart) {
        return CommandUtils.getSelectedElements(activePart, IDockerPortMapping.class);
    }

    public static List<DockerExplorerContentProvider.DockerContainerVolume> getSelectedVolumes(IWorkbenchPart activePart) {
        return CommandUtils.getSelectedElements(activePart, DockerExplorerContentProvider.DockerContainerVolume.class);
    }

    public static List<IDockerImage> getSelectedImages(IWorkbenchPart activePart) {
        return CommandUtils.getSelectedElements(activePart, IDockerImage.class);
    }

    public static IDockerImage getSelectedImage(IWorkbenchPart activePart) {
        List<IDockerImage> selectedImages = CommandUtils.getSelectedImages(activePart);
        if (selectedImages == null || selectedImages.isEmpty()) {
            return null;
        }
        return selectedImages.get(0);
    }

    private static <T> List<T> castSelectionTo(IStructuredSelection selection, Class<T> targetClass) {
        return selection.toList().stream().filter(selectedElement -> targetClass.isAssignableFrom(selectedElement.getClass())).map(selectedElement -> selectedElement).collect(Collectors.toList());
    }

    private static <T> List<T> adaptSelectionTo(IStructuredSelection selection, Class<T> targetClass) {
        return selection.toList().stream().filter(selectedElement -> {
            void adaptable;
            Object object = selectedElement;
            if (!(object instanceof IAdaptable)) return false;
            IAdaptable iAdaptable = (IAdaptable)object;
            IAdaptable cfr_ignored_0 = (IAdaptable)object;
            if (adaptable.getAdapter(targetClass) == null) return false;
            return true;
        }).map(selectedElement -> ((IAdaptable)selectedElement).getAdapter(targetClass)).toList();
    }

    public static RunConsole getRunConsole(IDockerConnection connection, IDockerContainer container) {
        RunConsole console;
        if (container != null && connection.getContainerInfo(container.id()) != null && connection.getContainerInfo(container.id()).config() != null && connection.getContainerInfo(container.id()).config().tty()) {
            RunConsole.attachToTerminal(connection, container.id(), null);
            return null;
        }
        boolean autoLogOnStart = Activator.getDefault().getPreferenceStore().getBoolean("autoLogOnStart");
        if (autoLogOnStart && (console = RunConsole.findConsole(container)) != null) {
            console.attachToConsole(connection);
            console.clearConsole();
            return console;
        }
        return null;
    }

    public static boolean openWizard(IWizard wizard, Shell shell) {
        WizardDialog wizardDialog = new WizardDialog(shell, wizard);
        wizardDialog.create();
        return wizardDialog.open() == 0;
    }

    public static boolean openWizard(IWizard wizard, Shell shell, int width, int height) {
        WizardDialog wizardDialog = new WizardDialog(shell, wizard);
        wizardDialog.setPageSize(width, height);
        wizardDialog.create();
        return wizardDialog.open() == 0;
    }

    public static void execute(String id, IStructuredSelection selection) {
        Command command;
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command2 = command = service != null ? service.getCommand(id) : null;
        if (command != null && command.isDefined()) {
            try {
                ParameterizedCommand pCmd = ParameterizedCommand.generateCommand((Command)command, null);
                IHandlerService handlerSvc = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                IEvaluationContext ctx = handlerSvc.getCurrentState();
                ctx = new EvaluationContext(ctx, (Object)selection);
                ctx.addVariable("selection", (Object)selection);
                handlerSvc.executeCommandInContext(pCmd, null, ctx);
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }
}

