/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.propertytesters;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.linuxtools.vagrant.core.EnumVMStatus;
import org.eclipse.linuxtools.vagrant.core.IVagrantVM;

public class VMPropertyTester
extends PropertyTester {
    public static final String IS_RUNNING = "isRunning";
    public static final String IS_SHUTOFF = "isShutoff";
    public static final String IS_PAUSED = "isPaused";
    public static final String IS_REMOVABLE = "isRemovable";
    public static final String IS_UNKNOWN = "isUnknown";

    /*
     * WARNING - void declaration
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        block19: {
            Object object = receiver;
            if (!(object instanceof IVagrantVM)) break block19;
            IVagrantVM iVagrantVM = (IVagrantVM)object;
            IVagrantVM cfr_ignored_0 = (IVagrantVM)object;
            switch (property) {
                case "isRunning": {
                    void vm;
                    return this.checkIfStateMatchesExpectation((IVagrantVM)vm, EnumVMStatus.RUNNING, expectedValue);
                }
                case "isShutoff": {
                    void vm;
                    return this.checkIfStateMatchesExpectation((IVagrantVM)vm, EnumVMStatus.SHUTOFF, expectedValue);
                }
                case "isUnknown": {
                    void vm;
                    return this.checkIfStateMatchesExpectation((IVagrantVM)vm, EnumVMStatus.UNKNOWN, expectedValue);
                }
                case "isPaused": {
                    void vm;
                    return this.checkIfStateMatchesExpectation((IVagrantVM)vm, EnumVMStatus.PAUSED, expectedValue);
                }
                case "isRemovable": {
                    void vm;
                    return this.checkIfStateMatchesExpectation((IVagrantVM)vm, EnumVMStatus.SHUTOFF, expectedValue) || this.checkIfStateMatchesExpectation((IVagrantVM)vm, EnumVMStatus.UNKNOWN, expectedValue);
                }
            }
        }
        return false;
    }

    private boolean checkIfStateMatchesExpectation(IVagrantVM vm, EnumVMStatus expectedStatus, Object expectedMatch) {
        if (expectedMatch == null) {
            return false;
        }
        EnumVMStatus containerStatus = EnumVMStatus.fromStatusMessage((String)vm.state());
        return expectedMatch.equals(containerStatus == expectedStatus);
    }
}

