/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.core.internal.exported;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.modisco.facet.util.core.internal.Activator;
import org.eclipse.modisco.facet.util.core.internal.Messages;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractRegistry {
    protected void initialize() {
        IExtension[] extensions;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(this.getExtensionPointNamespace(), this.getExtensionPointName());
        if (extensionPoint == null) {
            Logger.logError("Extension point not found:" + this.getExtensionPointNamespace() + "." + this.getExtensionPointName(), Activator.getDefault());
            return;
        }
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurationElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
            int n3 = configurationElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                try {
                    this.handleRootElement(configurationElement);
                }
                catch (Exception e) {
                    String errogMsg = NLS.bind((String)"An exception occurred while loading registry of the extension point {0}. The problem occurred with the an extension contributed by the plug-in {1}", (Object)(String.valueOf(this.getExtensionPointNamespace()) + '.' + this.getExtensionPointName()), (Object)extension.getContributor().getName());
                    Logger.logError(e, errogMsg, Activator.getDefault());
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected abstract String getExtensionPointNamespace();

    protected abstract String getExtensionPointName();

    protected abstract void handleRootElement(IConfigurationElement var1);

    protected static void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append(NLS.bind((String)Messages.AbstractRegistry_pluginExtension, (Object)extension.getNamespaceIdentifier(), (Object)extension.getExtensionPointUniqueIdentifier()));
        String id = element.getAttribute("id");
        if (id != null) {
            buf.append(Messages.AbstractRegistry_id);
            buf.append(id);
        }
        buf.append(String.valueOf(Messages.AbstractRegistry_colon) + text);
        Logger.logError(buf.toString(), Activator.getDefault());
    }

    protected static void logMissingAttribute(IConfigurationElement element, String attributeName) {
        AbstractRegistry.logError(element, NLS.bind((String)Messages.AbstractRegistry_requiredAttributeNotDefined, (Object)attributeName));
    }

    protected static void logUnknownElement(IConfigurationElement element) {
        AbstractRegistry.logError(element, String.valueOf(Messages.AbstractRegistry_unknownExtensionTag) + element.getName());
    }
}

