/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.trace;

import java.text.MessageFormat;
import org.eclipse.net4j.internal.util.bundle.AbstractPlatform;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.trace.OMTraceHandlerEvent;
import org.eclipse.net4j.util.om.trace.OMTracer;
import org.eclipse.net4j.util.om.trace.TraceHandlerEvent;

public class Tracer
implements OMTracer {
    public static final String PROP_DISABLE_TRACING = "org.eclipse.net4j.util.om.trace.disable";
    public static final String PROP_DISABLE_TRACING_OPTIONS = "org.eclipse.net4j.util.om.trace.disable.options";
    private static final boolean IS_GLOBALLY_DISABLED = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.util.om.trace.disable");
    private OMBundle bundle;
    private Tracer parent;
    private String name;
    private String fullName;

    public Tracer(OMBundle bundle, String name) {
        this.bundle = bundle;
        this.name = name;
        this.fullName = name;
    }

    private Tracer(Tracer parent, String name) {
        this.bundle = parent.getBundle();
        this.parent = parent;
        this.name = name;
        this.fullName = String.valueOf(parent.getFullName()) + "." + name;
    }

    @Override
    public OMBundle getBundle() {
        return this.bundle;
    }

    @Override
    public OMTracer getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public boolean isEnabled() {
        if (IS_GLOBALLY_DISABLED) {
            return false;
        }
        OMBundle.DebugSupport debugSupport = this.bundle.getDebugSupport();
        return debugSupport.isDebugging() && debugSupport.getDebugOption(this.fullName, false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        OMBundle.DebugSupport debugSupport = this.bundle.getDebugSupport();
        debugSupport.setDebugOption(this.fullName, enabled);
    }

    @Override
    public void trace(OMTraceHandlerEvent event) {
        ((AbstractPlatform)this.bundle.getPlatform()).trace(event);
    }

    @Override
    public OMTraceHandlerEvent trace(Class<?> context, String msg, Throwable t) {
        TraceHandlerEvent event = new TraceHandlerEvent(this, context, msg, t);
        this.trace(event);
        return event;
    }

    @Override
    public OMTraceHandlerEvent format(Class<?> context, String pattern, Throwable t, Object ... args) {
        String msg = MessageFormat.format(pattern, args);
        return this.trace(context, msg, t);
    }

    @Override
    public OMTraceHandlerEvent format(Class<?> context, String pattern, Object ... args) {
        return this.format(context, pattern, null, args);
    }

    @Override
    public OMTraceHandlerEvent trace(Class<?> context, String msg) {
        return this.trace(context, msg, null);
    }

    @Override
    public OMTraceHandlerEvent trace(Class<?> context, Throwable t) {
        return this.trace(context, null, t);
    }

    @Override
    public OMTracer tracer(String name) {
        return new Tracer(this, name);
    }

    public String toString() {
        return "Tracer[" + this.bundle + "/" + this.fullName + "]";
    }
}

