/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.validation.internal.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.views.validation.internal.actions.AbstractMarkerAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class DeleteMarkerAction
extends AbstractMarkerAction {
    public DeleteMarkerAction(IWorkbenchSite site) {
        super(site, "Delete");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setActionDefinitionId(ActionFactory.DELETE.getCommandId());
    }

    public void run() {
        for (IPapyrusMarker next : this.getMarkers()) {
            try {
                next.delete();
            }
            catch (CoreException e) {
                StatusAdapter adapter = new StatusAdapter(e.getStatus());
                adapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)"Delete Validation Problem");
                StatusManager.getManager().handle(adapter, 2);
            }
        }
    }
}

