/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ButtonHandler;
import org.eclipse.reddeer.core.handler.IBeforeShellIsClosed;
import org.eclipse.reddeer.core.handler.ShellHandler;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.reddeer.core.lookup.WidgetLookup;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.matcher.WithStyleMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.core.lookup.WorkbenchShellLookup;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.hamcrest.Matcher;

public class WorkbenchShellHandler {
    private final Logger log = Logger.getLogger(this.getClass());
    private static WorkbenchShellHandler instance;

    public static WorkbenchShellHandler getInstance() {
        if (instance == null) {
            instance = new WorkbenchShellHandler();
        }
        return instance;
    }

    public void closeAllNonWorbenchShells() {
        this.closeAllNonWorbenchShells(null);
    }

    public void closeAllNonWorbenchShells(IBeforeShellIsClosed beforeShellIsClosed) {
        this.log.info("Closing all shells...");
        List<Shell> shells = this.getNonWorbenchShellsToClose();
        long timeOut = System.currentTimeMillis() + TimePeriod.VERY_LONG.getSeconds() * 1000L;
        do {
            Shell s = this.getFilteredActiveShell(shells);
            try {
                if (s == null && shells.size() > 0) {
                    s = shells.get(0);
                }
                if (s == null || s.isDisposed()) continue;
                if (beforeShellIsClosed != null) {
                    beforeShellIsClosed.runBeforeShellIsClosed(s);
                }
                this.closeShellSafely(s);
            }
            catch (CoreLayerException ex) {
                if (ShellHandler.getInstance().isDisposed((Widget)s)) continue;
                throw ex;
            }
        } while ((shells = this.getNonWorbenchShellsToClose()).size() > 0 && System.currentTimeMillis() < timeOut);
    }

    private List<Shell> getNonWorbenchShellsToClose() {
        ArrayList<Shell> shellsToClose = new ArrayList<Shell>();
        Shell[] currentShells = ShellLookup.getInstance().getShells();
        Shell workbenchShell = WorkbenchShellLookup.getInstance().getWorkbenchShell();
        int i = 0;
        while (i < currentShells.length) {
            if (currentShells[i] != workbenchShell && !currentShells[i].isDisposed()) {
                shellsToClose.add(currentShells[i]);
            }
            ++i;
        }
        return shellsToClose;
    }

    private Shell getFilteredActiveShell(List<Shell> shells) {
        Shell activeShell;
        Shell result = null;
        if (shells != null && (activeShell = ShellLookup.getInstance().getActiveShell()) != null) {
            Iterator<Shell> itShell = shells.iterator();
            while (itShell.hasNext() && result == null) {
                Shell shell = itShell.next();
                if (shell.isDisposed() || !ShellHandler.getInstance().getText(shell).equals(ShellHandler.getInstance().getText(activeShell))) continue;
                result = shell;
            }
        }
        return result;
    }

    private void closeShellSafely(Shell swtShell) {
        block4: {
            try {
                String text = ShellHandler.getInstance().getText(swtShell);
                this.log.info("Close shell " + text);
                try {
                    this.clickCancelButton(swtShell);
                }
                catch (Exception exception) {
                    ShellHandler.getInstance().notifyWidget(21, (Widget)swtShell);
                    ShellHandler.getInstance().closeShell(swtShell);
                }
                new WaitWhile((WaitCondition)new ShellIsAvailable((org.eclipse.reddeer.swt.api.Shell)new DefaultShell(swtShell)));
            }
            catch (Exception e) {
                if (swtShell.isDisposed()) break block4;
                throw e;
            }
        }
    }

    private void clickCancelButton(Shell shell) {
        Button button = (Button)WidgetLookup.getInstance().activeWidget((ReferencedComposite)new DefaultShell(shell), Button.class, 0, WorkbenchShellHandler.createMatchers(8, new Matcher[]{new WithMnemonicTextMatcher("Cancel")}));
        ButtonHandler.getInstance().click(button);
    }

    private static Matcher<?>[] createMatchers(int style, Matcher<?> ... matchers) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new WithStyleMatcher(style));
        list.addAll(Arrays.asList(matchers));
        return list.toArray(new Matcher[list.size()]);
    }
}

