/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.profiler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;

class ProfilerSettingsDlg
extends Dialog {
    static final String PARAM_VIEW_UPDATE_PERIOD = "ViewUpdatePeriod";
    static final String PARAM_AGGREGATE = "Aggregate";
    static final String PARAM_STACK_TRACE = "StackTrace";
    Map<String, Object> conf;
    Map<String, Object> data;
    private Button aggregate_button;
    private Button stack_trace_button;
    private Text frame_cnt_text;
    private Text view_update_text;

    protected ProfilerSettingsDlg(Shell shell, Map<String, Object> conf) {
        super(shell);
        this.conf = conf;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Profiler Configuration");
        shell.setImage(ImageCache.getImage("icons/profiler"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createFields(composite);
        this.setData();
        composite.setSize(composite.computeSize(-1, -1));
        return composite;
    }

    private void createFields(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.aggregate_button = new Button(composite, 32);
        this.aggregate_button.setLayoutData((Object)new GridData(256, 0, true, false, 2, 1));
        this.aggregate_button.setFont(font);
        this.aggregate_button.setText("Aggregate per function");
        this.stack_trace_button = new Button(composite, 32);
        this.stack_trace_button.setLayoutData((Object)new GridData(256, 0, true, false, 2, 1));
        this.stack_trace_button.setFont(font);
        this.stack_trace_button.setText("Enable stack tracing");
        this.stack_trace_button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProfilerSettingsDlg.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ProfilerSettingsDlg.this.updateButtons();
            }
        });
        Label frame_cnt_label = new Label(composite, 64);
        frame_cnt_label.setLayoutData((Object)new GridData(32));
        frame_cnt_label.setFont(font);
        frame_cnt_label.setText("Max stack frames count:");
        this.frame_cnt_text = new Text(composite, 2052);
        this.frame_cnt_text.setLayoutData((Object)new GridData(768));
        this.frame_cnt_text.setFont(font);
        this.frame_cnt_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProfilerSettingsDlg.this.updateButtons();
            }
        });
        Label view_update_label = new Label(composite, 64);
        view_update_label.setLayoutData((Object)new GridData(32));
        view_update_label.setFont(font);
        view_update_label.setText("View update interval (msec):");
        this.view_update_text = new Text(composite, 2052);
        this.view_update_text.setLayoutData((Object)new GridData(768));
        this.view_update_text.setFont(font);
        this.view_update_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProfilerSettingsDlg.this.updateButtons();
            }
        });
    }

    private void updateButtons() {
        Button btn = this.getButton(0);
        if (btn != null) {
            btn.setEnabled(true);
        }
        this.frame_cnt_text.setEnabled(this.stack_trace_button.getSelection());
    }

    private void setData() {
        Boolean b_ag = (Boolean)this.conf.get(PARAM_AGGREGATE);
        this.aggregate_button.setSelection(b_ag != null && b_ag != false);
        Boolean b_st = (Boolean)this.conf.get(PARAM_STACK_TRACE);
        this.stack_trace_button.setSelection(b_st != null && b_st != false);
        Number n_fc = (Number)this.conf.get("FrameCnt");
        if (n_fc == null) {
            n_fc = 1;
        }
        this.frame_cnt_text.setText(n_fc.toString());
        Number n_vu = (Number)this.conf.get(PARAM_VIEW_UPDATE_PERIOD);
        if (n_vu == null) {
            n_vu = 1000;
        }
        this.view_update_text.setText(n_vu.toString());
    }

    private void getData() {
        this.data = new HashMap<String, Object>();
        this.data.put(PARAM_AGGREGATE, this.aggregate_button.getSelection());
        this.data.put(PARAM_STACK_TRACE, this.stack_trace_button.getSelection());
        this.data.put("FrameCnt", new Integer(this.frame_cnt_text.getText()));
        this.data.put(PARAM_VIEW_UPDATE_PERIOD, new Integer(this.view_update_text.getText()));
    }

    protected void okPressed() {
        try {
            this.getData();
        }
        catch (Throwable x) {
            MessageBox mb = new MessageBox(this.getShell(), 33);
            mb.setText("Invalid data");
            mb.setMessage(TCFModel.getErrorMessage(x, true));
            mb.open();
            return;
        }
        super.okPressed();
    }
}

