/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.AbstractOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpCacheFileDigest
extends AbstractOperation {
    private FSTreeNode node;
    private byte[] digest;

    public OpCacheFileDigest(FSTreeNode node) {
        this.node = node;
    }

    @Override
    protected IStatus doRun(IProgressMonitor monitor) {
        monitor.beginTask(this.getName(), 100);
        File file = CacheManager.getCacheFile(this.node);
        BufferedInputStream input = null;
        try {
            int length;
            long totalSize = file.length();
            int chunk_size = (int)totalSize / 100;
            int percentRead = 0;
            long bytesRead = 0L;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            input = new BufferedInputStream(new DigestInputStream(new FileInputStream(file), digest));
            byte[] data = new byte[5120];
            while ((length = input.read(data)) >= 0 && !monitor.isCanceled()) {
                int percent;
                if (chunk_size == 0 || (percent = (int)(bytesRead += (long)length) / chunk_size) == percentRead) continue;
                monitor.worked(percent - percentRead);
                percentRead = percent;
            }
            this.digest = digest.digest();
            IStatus iStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, CorePlugin.getUniqueIdentifier(), Messages.OpCacheFileDigest_error_updatingDigest, (Throwable)e);
            return status;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public byte[] getDigest() {
        return this.digest;
    }

    @Override
    public String getName() {
        return Messages.OpCacheFileDigest_name;
    }
}

