/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.grammar.BalancedBracketSelectors;
import org.eclipse.tm4e.core.internal.grammar.Grammar;
import org.eclipse.tm4e.core.internal.grammar.ScopeStack;
import org.eclipse.tm4e.core.internal.registry.IGrammarRepository;
import org.eclipse.tm4e.core.internal.registry.IThemeProvider;
import org.eclipse.tm4e.core.internal.theme.StyleAttributes;
import org.eclipse.tm4e.core.internal.theme.Theme;
import org.eclipse.tm4e.core.internal.types.IRawGrammar;

public final class SyncRegistry
implements IGrammarRepository,
IThemeProvider {
    private final Map<String, Grammar> _grammars = new HashMap<String, Grammar>();
    private final Map<String, IRawGrammar> _rawGrammars = new HashMap<String, IRawGrammar>();
    private final Map<String, Collection<String>> _injectionGrammars = new HashMap<String, Collection<String>>();
    private Theme _theme;

    public SyncRegistry(Theme theme) {
        this._theme = theme;
    }

    public void setTheme(Theme theme) {
        this._theme = theme;
    }

    public List<String> getColorMap() {
        return this._theme.getColorMap();
    }

    public void addGrammar(IRawGrammar grammar, @Nullable Collection<String> injectionScopeNames) {
        this._rawGrammars.put(grammar.getScopeName(), grammar);
        if (injectionScopeNames != null) {
            this._injectionGrammars.put(grammar.getScopeName(), injectionScopeNames);
        }
    }

    @Override
    public @Nullable IRawGrammar lookup(String scopeName) {
        return this._rawGrammars.get(scopeName);
    }

    @Override
    public @Nullable Collection<String> injections(String targetScope) {
        return this._injectionGrammars.get(targetScope);
    }

    @Override
    public StyleAttributes getDefaults() {
        return this._theme.getDefaults();
    }

    @Override
    public @Nullable StyleAttributes themeMatch(ScopeStack scopePath) {
        return this._theme.match(scopePath);
    }

    public @Nullable IGrammar grammarForScopeName(String scopeName, int initialLanguage, @Nullable Map<String, Integer> embeddedLanguages, @Nullable Map<String, Integer> tokenTypes, @Nullable BalancedBracketSelectors balancedBracketSelectors) {
        if (!this._grammars.containsKey(scopeName)) {
            IRawGrammar rawGrammar = this.lookup(scopeName);
            if (rawGrammar == null) {
                return null;
            }
            this._grammars.put(scopeName, new Grammar(scopeName, rawGrammar, initialLanguage, embeddedLanguages, tokenTypes, balancedBracketSelectors, this, this));
        }
        return this._grammars.get(scopeName);
    }
}

