/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util.timeline;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.Signed;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timelines;

public abstract class Timeline<Timestamp extends Comparable<Timestamp>> {
    public abstract Iterable<Signed<Timestamp>> asChangeSequence();

    public abstract boolean isPresentAtInfinity();

    public abstract boolean isEmpty();

    public abstract int size();

    public abstract Signed<Timestamp> getSigned(int var1);

    public abstract Timestamp getUnsigned(int var1);

    public Timeline<Timestamp> mergeMultiplicative(Timeline<Timestamp> that) {
        ArrayList<Comparable> result = new ArrayList<Comparable>();
        int thisIdx = 0;
        int thatIdx = 0;
        Comparable thisNext = thisIdx < this.size() ? (Comparable)this.getUnsigned(thisIdx) : null;
        Object thatNext = thatIdx < that.size() ? that.getUnsigned(thatIdx) : null;
        while (thisNext != null || thatNext != null) {
            int thisMinusThat = 0;
            if (thisNext != null && thatNext != null) {
                thisMinusThat = thisNext.compareTo(thatNext);
            }
            if (thisNext == null || thisMinusThat > 0) {
                if (thisIdx % 2 == 1) {
                    result.add(thatNext);
                }
                thatNext = ++thatIdx < that.size() ? that.getUnsigned(thatIdx) : null;
                continue;
            }
            if (thatNext == null || thisMinusThat < 0) {
                if (thatIdx % 2 == 1) {
                    result.add(thisNext);
                }
                thisNext = ++thisIdx < this.size() ? this.getUnsigned(thisIdx) : null;
                continue;
            }
            if (thisIdx % 2 == thatIdx % 2) {
                result.add(thisNext);
            }
            thatNext = ++thatIdx < that.size() ? that.getUnsigned(thatIdx) : null;
            Comparable comparable = thisNext = thisIdx < this.size() ? (Comparable)this.getUnsigned(++thisIdx) : null;
        }
        return Timelines.createFrom(result);
    }

    public Timeline<Timestamp> mergeAdditive(Diff<Timestamp> diff) {
        Iterator<Signed<Timestamp>> thisItr = this.asChangeSequence().iterator();
        Iterator diffItr = diff.iterator();
        ArrayList<Object> result = new ArrayList<Object>();
        Direction expected = Direction.INSERT;
        Signed<Timestamp> thisNext = thisItr.hasNext() ? thisItr.next() : null;
        Signed diffNext = diffItr.hasNext() ? (Signed)diffItr.next() : null;
        while (thisNext != null || diffNext != null) {
            int thisMinusDiff = 0;
            if (thisNext != null && diffNext != null) {
                thisMinusDiff = thisNext.getPayload().compareTo(diffNext.getPayload());
            }
            if (thisNext == null || thisMinusDiff > 0) {
                if (!expected.equals((Object)diffNext.getDirection())) {
                    throw new IllegalStateException(String.format("Expected direction (%s) constraint violated! %s %s @%s", new Object[]{expected, this, diff, diffNext.getPayload()}));
                }
                result.add(diffNext.getPayload());
                diffNext = diffItr.hasNext() ? (Signed)diffItr.next() : null;
                expected = expected.opposite();
                continue;
            }
            if (diffNext == null || thisMinusDiff < 0) {
                if (!expected.equals((Object)thisNext.getDirection())) {
                    throw new IllegalStateException(String.format("Expected direction (%s) constraint violated! %s %s @%s", new Object[]{expected, this, diff, thisNext.getPayload()}));
                }
                result.add(thisNext.getPayload());
                thisNext = thisItr.hasNext() ? thisItr.next() : null;
                expected = expected.opposite();
                continue;
            }
            if (diffNext.getDirection().equals((Object)thisNext.getDirection())) {
                throw new IllegalStateException(String.format("Changes do not cancel out each other! %s %s @%s", this, diff, thisNext.getPayload()));
            }
            diffNext = diffItr.hasNext() ? (Signed)diffItr.next() : null;
            Signed<Timestamp> signed = thisNext = thisItr.hasNext() ? thisItr.next() : null;
        }
        return Timelines.createFrom(result);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        boolean first = true;
        for (Signed<Timestamp> element : this.asChangeSequence()) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(element.toString());
        }
        builder.append("]");
        return builder.toString();
    }
}

