/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.gef.header.selection;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.KeyRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.SideResizeHandle;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.gef.graphical.tools.ResizeTracker;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.selection.DimensionSelectionEditPolicy;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;

public final class ColumnSelectionEditPolicy
extends DimensionSelectionEditPolicy<MigColumnInfo> {
    public ColumnSelectionEditPolicy(LayoutEditPolicy mainPolicy) {
        super(mainPolicy);
    }

    @Override
    protected Handle createResizeHandle() {
        SideResizeHandle handle = new SideResizeHandle(this.getHost(), 4, 7, true);
        handle.setDragTrackerTool((Tool)new ResizeTracker((EditPart)this.getHost(), 16, (Object)"resize"));
        return handle;
    }

    @Override
    protected Point getTextFeedbackLocation(Point mouseLocation) {
        return new Point(mouseLocation.x + 10, 10);
    }

    @Override
    protected int getPixelSize(Dimension resizeDelta) {
        return this.getHostFigure().getSize().width + resizeDelta.width;
    }

    @Override
    public void performRequest(Request request) {
        KeyRequest keyRequest;
        super.performRequest(request);
        if (request instanceof KeyRequest && (keyRequest = (KeyRequest)request).isPressed()) {
            char c = keyRequest.getCharacter();
            if (c == 'd') {
                this.setAlignment(MigColumnInfo.Alignment.DEFAULT);
            } else if (c == 'l') {
                this.setAlignment(MigColumnInfo.Alignment.LEFT);
            } else if (c == 'c') {
                this.setAlignment(MigColumnInfo.Alignment.CENTER);
            } else if (c == 'r') {
                this.setAlignment(MigColumnInfo.Alignment.RIGHT);
            } else if (c == 'f') {
                this.setAlignment(MigColumnInfo.Alignment.FILL);
            } else if (c == 'q') {
                this.setAlignment(MigColumnInfo.Alignment.LEADING);
            } else if (c == 'w') {
                this.setAlignment(MigColumnInfo.Alignment.TRAILING);
            }
        }
    }

    private void setAlignment(final MigColumnInfo.Alignment alignment) {
        final MigLayoutInfo layout = this.getLayout();
        ExecutionUtils.run((ObjectInfo)layout, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ((MigColumnInfo)ColumnSelectionEditPolicy.this.getDimension()).setAlignment(alignment);
                layout.writeDimensions();
            }
        });
    }
}

