/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.tabledataeditor.query.execute;

import java.io.FileNotFoundException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.internal.tabledataeditor.TableDataEditorPlugin;
import org.eclipse.datatools.sqltools.internal.tabledataeditor.query.execute.ISQLExecutionProvider;
import org.eclipse.datatools.sqltools.internal.tabledataeditor.util.ResourceLoader;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.datatools.sqltools.result.ui.ResultsViewUIAccessor;
import org.eclipse.emf.common.util.WrappedException;

public class QueryOutputHelper {
    private String objectName = "";
    private String statementSource = "";
    private String profileName = "";
    private String databaseName = "";
    private OperationCommand stmtOutput = null;
    private Vector sqlExecutionProviders = null;
    private Connection jdbcConnection = null;
    private boolean updateOutputItemStatus = true;

    public QueryOutputHelper(Connection connection) {
        this.jdbcConnection = connection;
        this.sqlExecutionProviders = this.getSQLExecutionProviders();
    }

    public QueryOutputHelper(String statementString, Connection connection, String profileName, String databaseName) {
        this.profileName = profileName;
        this.statementSource = statementString;
        this.jdbcConnection = connection;
        this.sqlExecutionProviders = this.getSQLExecutionProviders();
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setOutputItem(OperationCommand stmtOutput) {
        this.stmtOutput = stmtOutput;
    }

    public void setUpdateOutputItemStatus(boolean updateOutputItemStatus) {
        this.updateOutputItemStatus = updateOutputItemStatus;
    }

    public void setStatement(String statementSource) {
        this.statementSource = statementSource;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean runSQLScrapbookQuery() {
        block25: {
            try {
                if (this.jdbcConnection == null) break block25;
                OperationCommand oi = this.getOutputItem(ResourceLoader.INSTANCE.queryString("_UI_SCRAPBOOK_ITEM_TITLE"));
                ResultsViewAPI.getInstance().updateStatus(oi, 2);
                this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_STARTING"));
                this.showMessage(this.statementSource);
                ISQLExecutionProvider provider = this.getProviderFor(this.jdbcConnection, this.statementSource);
                try (Statement stmt = null;){
                    try {
                        SQLWarning rsWarningMsgs;
                        if (provider != null) {
                            stmt = provider.execute(this.jdbcConnection, this.statementSource);
                        } else {
                            stmt = this.isCallStatement(this.statementSource) ? this.jdbcConnection.prepareCall(this.statementSource) : this.jdbcConnection.createStatement();
                            if (!this.isCreateStatement(this.statementSource)) {
                                boolean setLimit = RDBCorePlugin.getDefault().getPluginPreferences().getBoolean("OUTPUT_PREFERENCE_LIMIT_ROWS_RETRIEVED");
                                if (setLimit) {
                                    int integer = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_ROW_RETRIEVED");
                                    stmt.setMaxRows(integer);
                                } else {
                                    stmt.setMaxRows(0);
                                }
                                int fieldSize = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_LOB_LENGTH");
                                if (fieldSize > 0) {
                                    stmt.setMaxFieldSize(fieldSize);
                                }
                            }
                            if (this.isCallStatement(this.statementSource)) {
                                ((CallableStatement)stmt).execute();
                            } else {
                                stmt.execute(this.statementSource);
                            }
                        }
                        ResultSet resultSet = stmt.getResultSet();
                        if (resultSet != null) {
                            ResultsViewAPI.getInstance().updateStatus(this.getOutputItem(), 2);
                            this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_SUCCESSFUL"));
                            ResultsViewAPI.getInstance().appendResultSet(this.getOutputItem(), resultSet);
                            SQLWarning rsWarningMsgs2 = resultSet.getWarnings();
                            if (rsWarningMsgs2 != null) {
                                this.showErrors(ResourceLoader.INSTANCE.queryString("_WARN_MESSAGES_ENCOUNTERED"), 4);
                                this.displayMessages(rsWarningMsgs2);
                            }
                        } else {
                            ResultsViewAPI.getInstance().updateStatus(this.getOutputItem(), 3);
                            this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_LABEL_EXECUTION_SUCCESSFUL"));
                        }
                        if ((rsWarningMsgs = stmt.getWarnings()) != null) {
                            this.showErrors(ResourceLoader.INSTANCE.queryString("_WARN_MESSAGES_ENCOUNTERED"), 4);
                            this.displayMessages(rsWarningMsgs);
                        }
                    }
                    catch (SQLException exception) {
                        SQLException sqlExp = exception;
                        String sqlState = sqlExp.getSQLState();
                        String sqlCode = Integer.toString(sqlExp.getErrorCode());
                        String sqlMsg = sqlExp.getLocalizedMessage();
                        String expMsg = exception.toString();
                        this.showErrors("SQL State = " + sqlState + " SQL Code = " + sqlCode + " SQL Message = " + sqlMsg + " Exception message = " + expMsg, 6);
                        if (stmt != null) {
                            stmt.close();
                        }
                        return false;
                    }
                    catch (Exception exception) {
                        block26: {
                            this.showErrors(exception.toString(), 6);
                            if (stmt == null) break block26;
                            stmt.close();
                        }
                        return false;
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.showErrors(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION"), 6);
                return false;
            }
            catch (WrappedException e) {
                String msg = e.exception() instanceof FileNotFoundException ? String.valueOf(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION_FILE")) + "\n\n" + e.exception().toString() : e.toString();
                this.showErrors(msg, 6);
                return false;
            }
            catch (Exception e) {
                this.showErrors(e.toString(), 6);
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runQuery() {
        try {
            if (this.jdbcConnection == null) return true;
            this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_STARTING"));
            this.showMessage(this.statementSource);
            Statement stmt = null;
            ISQLExecutionProvider provider = this.getProviderFor(this.jdbcConnection, this.statementSource);
            try {
                try {
                    SQLWarning rsWarningMsgs;
                    if (provider != null) {
                        stmt = provider.execute(this.jdbcConnection, this.statementSource);
                    } else {
                        stmt = this.isCallStatement(this.statementSource) ? this.jdbcConnection.prepareCall(this.statementSource) : this.jdbcConnection.createStatement();
                        boolean setLimit = RDBCorePlugin.getDefault().getPluginPreferences().getBoolean("OUTPUT_PREFERENCE_LIMIT_ROWS_RETRIEVED");
                        if (setLimit) {
                            int integer = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_ROW_RETRIEVED");
                            stmt.setMaxRows(integer);
                        } else {
                            stmt.setMaxRows(0);
                        }
                        int fieldSize = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_LOB_LENGTH");
                        if (fieldSize > 0) {
                            stmt.setMaxFieldSize(fieldSize);
                        }
                        if (this.isCallStatement(this.statementSource)) {
                            ((CallableStatement)stmt).execute();
                        } else {
                            stmt.execute(this.statementSource);
                        }
                    }
                    ResultSet resultSet = stmt.getResultSet();
                    if (resultSet == null) return true;
                    this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_SUCCESSFUL"));
                    ResultsViewAPI.getInstance().appendResultSet(this.getOutputItem(), resultSet);
                    int numDisplayed = ResultsViewUIAccessor.getInstance().getRowCount(this.stmtOutput);
                    if (numDisplayed >= 1000) {
                        this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_MAX_RECORD_EXCEEDED"));
                    }
                    if ((rsWarningMsgs = resultSet.getWarnings()) != null) {
                        this.showErrors(ResourceLoader.INSTANCE.queryString("_WARN_MESSAGES_ENCOUNTERED"), 4);
                        this.displayMessages(rsWarningMsgs);
                    }
                    ResultsViewAPI.getInstance().updateStatus(this.getOutputItem(), 3);
                    return true;
                }
                catch (Exception exception) {
                    this.showErrors(exception.toString(), 6);
                    ResultsViewAPI.getInstance().saveDetailResults(this.getOutputItem());
                    if (stmt == null) return false;
                    stmt.close();
                    return false;
                }
            }
            finally {
                ResultsViewAPI.getInstance().saveDetailResults(this.getOutputItem());
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            this.showErrors(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION"), 6);
            return false;
        }
        catch (WrappedException e) {
            String msg = e.exception() instanceof FileNotFoundException ? String.valueOf(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION_FILE")) + "\n\n" + e.exception().toString() : e.toString();
            this.showErrors(msg, 6);
            return false;
        }
        catch (Exception e) {
            this.showErrors(e.toString(), 6);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean executeDDL(String source) {
        try {
            if (this.jdbcConnection == null) return true;
            this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_STARTING"));
            this.showMessage(this.statementSource);
            try (Statement stmt = null;){
                try {
                    ISQLExecutionProvider provider = this.getProviderFor(this.jdbcConnection, this.statementSource);
                    if (provider != null) {
                        stmt = provider.execute(this.jdbcConnection, this.statementSource);
                    } else if (this.isCallStatement(this.statementSource)) {
                        stmt = this.jdbcConnection.prepareCall(this.statementSource);
                        ((CallableStatement)stmt).execute();
                    } else {
                        stmt = this.jdbcConnection.createStatement();
                        stmt.execute(this.statementSource);
                    }
                    this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_LABEL_EXECUTION_SUCCESSFUL"));
                    return true;
                }
                catch (Exception exception) {
                    this.showErrors(exception.toString(), 6);
                    if (stmt == null) return false;
                    stmt.close();
                    return false;
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            this.showErrors(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION"), 6);
            return false;
        }
        catch (WrappedException e) {
            String msg = e.exception() instanceof FileNotFoundException ? String.valueOf(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION_FILE")) + "\n\n" + e.exception().toString() : e.toString();
            this.showErrors(msg, 6);
            return false;
        }
        catch (Exception e) {
            this.showErrors(e.toString(), 6);
            return false;
        }
    }

    private boolean isCallStatement(String sql) {
        int len = sql.length();
        int i = 0;
        while (i < len) {
            if (sql.charAt(i) != ' ') {
                int end = Math.min(i + 4, len);
                String sub = sql.substring(i, end);
                return sub.toUpperCase().equals("CALL");
            }
            ++i;
        }
        return false;
    }

    private boolean isCreateStatement(String sql) {
        int len = sql.length();
        int i = 0;
        while (i < len) {
            if (sql.charAt(i) != ' ') {
                int end = Math.min(i + 6, len);
                String sub = sql.substring(i, end);
                return sub.toUpperCase().equals("CREATE");
            }
            ++i;
        }
        return false;
    }

    private void showErrors(String messageText, int newStatus) {
        if (this.updateOutputItemStatus) {
            ResultsViewAPI.getInstance().updateStatus(this.getOutputItem(), newStatus);
        }
        this.showMessage(messageText);
    }

    private void showMessage(String messageText) {
        ResultsViewAPI.getInstance().appendStatusMessage(this.getOutputItem(), messageText);
    }

    private OperationCommand getOutputItem() {
        if (this.stmtOutput == null) {
            this.stmtOutput = new OperationCommand(1, null, this.objectName, this.profileName, this.databaseName);
            ResultsViewAPI.getInstance().createNewInstance(this.stmtOutput, null);
        }
        return this.stmtOutput;
    }

    private OperationCommand getOutputItem(String source) {
        if (this.stmtOutput == null) {
            this.stmtOutput = new OperationCommand(1, null, source, this.profileName, this.databaseName);
            ResultsViewAPI.getInstance().createNewInstance(this.stmtOutput, null);
        }
        return this.stmtOutput;
    }

    protected Runnable getTerminateHandler() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ResultsViewAPI.getInstance().updateStatus(QueryOutputHelper.this.getOutputItem(), 5);
                QueryOutputHelper.this.stmtOutput = null;
            }
        };
        return run;
    }

    private void displayMessages(SQLWarning except) {
        String reason = "";
        reason = except instanceof DataTruncation ? ResourceLoader.INSTANCE.queryString("_WARN_DATA_WAS_TRUNCATED") : ResourceLoader.INSTANCE.queryString("_WARN_SQL_WARNINGS_FOUND");
        ResultsViewAPI.getInstance().appendStatusMessage(this.getOutputItem(), reason);
        do {
            ResultsViewAPI.getInstance().appendStatusMessage(this.getOutputItem(), "SQLState=" + except.getSQLState() + " " + except.getMessage());
        } while ((except = except.getNextWarning()) != null);
    }

    private Vector getSQLExecutionProviders() {
        Vector<SQLExecutionProviderExtension> providers = new Vector<SQLExecutionProviderExtension>();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.server.ui", "SQLExecutionProvider");
        if (extensionPoint == null) {
            return new Vector();
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("provider")) {
                    try {
                        SQLExecutionProviderExtension sepe = new SQLExecutionProviderExtension(configElements[j]);
                        providers.add(sepe);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "An error was detected when creating the SQL Execution Provider.", (Throwable)e);
                        TableDataEditorPlugin.getDefault().getLog().log((IStatus)status);
                    }
                    break;
                }
                ++j;
            }
            ++i;
        }
        return providers;
    }

    private ISQLExecutionProvider getProviderFor(Connection con, String stmt) {
        Database db = this.getDatabaseFor(con);
        if (db != null) {
            for (SQLExecutionProviderExtension sepe : this.sqlExecutionProviders) {
                if (!sepe.vendor.equals("*") && !db.getVendor().equals(sepe.vendor) || !sepe.version.equals("*") && !db.getVersion().equals(sepe.version) || !sepe.getExecutionProvider().isProviderFor(stmt)) continue;
                return sepe.getExecutionProvider();
            }
        }
        return null;
    }

    private Database getDatabaseFor(Connection con) {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        int i = 0;
        int n = profiles.length;
        while (i < n) {
            IManagedConnection connection;
            org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo info;
            IConnectionProfile profile = profiles[i];
            if (profile.isConnected() && con.equals((info = (org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo)(connection = profile.getManagedConnection(ConnectionInfo.class.getName())).getConnection().getRawConnection()).getSharedConnection())) {
                return info.getSharedDatabase();
            }
            ++i;
        }
        return null;
    }

    private class SQLExecutionProviderExtension {
        ISQLExecutionProvider executionProvider;
        String vendor;
        String version;

        public SQLExecutionProviderExtension(IConfigurationElement element) throws CoreException {
            this.vendor = element.getAttribute("vendor");
            this.version = element.getAttribute("version");
            this.executionProvider = (ISQLExecutionProvider)element.createExecutableExtension("class");
        }

        public ISQLExecutionProvider getExecutionProvider() {
            return this.executionProvider;
        }
    }
}

