/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.chess.features;

import org.eclipse.graphiti.examples.mm.chess.Colors;
import org.eclipse.graphiti.examples.mm.chess.Piece;
import org.eclipse.graphiti.examples.mm.chess.Types;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ICreateService;
import org.eclipse.graphiti.services.IGaLayoutService;
import org.eclipse.graphiti.util.IColorConstant;

public class AddChessPieceFeature
extends AbstractAddShapeFeature {
    public AddChessPieceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        if (context.getNewObject() instanceof Piece) {
            return context.getTargetContainer().getChildren().size() < 64;
        }
        return false;
    }

    public PictogramElement add(IAddContext context) {
        ICreateService createService = Graphiti.getCreateService();
        IGaLayoutService layoutService = Graphiti.getGaLayoutService();
        Piece piece = (Piece)context.getNewObject();
        int[] points = null;
        if (Types.BISHOP.equals((Object)piece.getType())) {
            points = new int[]{10, 45, 10, 40, 15, 30, 20, 25, 15, 20, 15, 15, 20, 10, 20, 5, 30, 5, 30, 10, 35, 15, 35, 20, 30, 25, 35, 30, 40, 40, 40, 45};
        } else if (Types.KING.equals((Object)piece.getType())) {
            points = new int[]{10, 45, 15, 40, 10, 35, 5, 25, 5, 5, 10, 15, 15, 5, 20, 15, 25, 5, 30, 15, 35, 5, 40, 15, 45, 5, 45, 25, 40, 35, 35, 40, 40, 45};
        } else if (Types.KNIGHT.equals((Object)piece.getType())) {
            points = new int[]{20, 45, 25, 35, 20, 25, 10, 35, 5, 30, 5, 25, 10, 15, 15, 10, 15, 5, 20, 10, 25, 5, 25, 10, 35, 15, 40, 20, 45, 30, 45, 45};
        } else if (Types.PAWN.equals((Object)piece.getType())) {
            points = new int[]{15, 45, 15, 40, 20, 30, 15, 25, 20, 20, 20, 15, 25, 10, 30, 15, 30, 20, 35, 25, 30, 30, 35, 40, 35, 45};
        } else if (Types.QUEEN.equals((Object)piece.getType())) {
            points = new int[]{10, 45, 15, 40, 10, 35, 5, 25, 5, 15, 10, 10, 15, 10, 20, 15, 25, 5, 30, 15, 35, 10, 40, 10, 45, 15, 45, 25, 40, 35, 35, 40, 40, 45};
        } else if (Types.ROOK.equals((Object)piece.getType())) {
            points = new int[]{10, 45, 10, 40, 15, 30, 15, 15, 10, 10, 10, 5, 15, 5, 15, 10, 20, 10, 20, 5, 30, 5, 30, 10, 35, 10, 35, 5, 40, 5, 40, 10, 35, 15, 35, 30, 40, 40, 40, 45};
        }
        ContainerShape pieceShape = createService.createContainerShape(context.getTargetContainer(), true);
        Polygon piecePolygon = createService.createPolygon((GraphicsAlgorithmContainer)pieceShape, points);
        if (Colors.LIGHT.equals((Object)piece.getSquare().getColor())) {
            piecePolygon.setForeground(this.manageColor(IColorConstant.BLACK));
        } else {
            piecePolygon.setForeground(this.manageColor(IColorConstant.WHITE));
        }
        piecePolygon.setLineWidth(Integer.valueOf(2));
        if (Colors.LIGHT.equals((Object)piece.getOwner())) {
            piecePolygon.setBackground(this.manageColor(IColorConstant.WHITE));
        } else {
            piecePolygon.setBackground(this.manageColor(IColorConstant.BLACK));
        }
        this.link((PictogramElement)pieceShape, piece);
        createService.createChopboxAnchor((AnchorContainer)pieceShape);
        BoxRelativeAnchor relativeAnchor = createService.createBoxRelativeAnchor((AnchorContainer)pieceShape);
        relativeAnchor.setRelativeHeight(0.5);
        relativeAnchor.setRelativeWidth(0.5);
        relativeAnchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)piecePolygon);
        relativeAnchor.setUseAnchorLocationAsConnectionEndpoint(true);
        Ellipse anchorEllipse = createService.createEllipse((GraphicsAlgorithmContainer)relativeAnchor);
        layoutService.setLocationAndSize((GraphicsAlgorithm)anchorEllipse, 25, 25, 0, 0);
        return pieceShape;
    }
}

