/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder.plexusbuildapi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.Scanner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.internal.builder.IIncrementalBuildFramework;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.ChangedFileOutputStream;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.EclipseResourceBuildDelta;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.ResourceDeltaScanner;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.EmptyScanner;
import org.sonatype.plexus.build.incremental.ThreadBuildContext;

public class EclipseIncrementalBuildContext
implements BuildContext,
IIncrementalBuildFramework.BuildContext {
    private final IIncrementalBuildFramework.BuildDelta delta;
    private IIncrementalBuildFramework.BuildResultCollector results;
    private Map<String, Object> context;
    private File baseDir;

    public EclipseIncrementalBuildContext(IResourceDelta delta, Map<String, Object> context, IIncrementalBuildFramework.BuildResultCollector results) {
        this(new EclipseResourceBuildDelta(delta), context, results, delta.getResource().getProject().getLocation().toFile());
    }

    public EclipseIncrementalBuildContext(IIncrementalBuildFramework.BuildDelta delta, Map<String, Object> context, IIncrementalBuildFramework.BuildResultCollector results, File baseDir) {
        this.delta = delta;
        this.context = context;
        this.results = results;
        this.baseDir = baseDir;
    }

    public boolean hasDelta(String relPath) {
        return this.hasDelta(new File(this.baseDir, relPath));
    }

    public boolean hasDelta(List relPaths) {
        for (String relPath : relPaths) {
            if (!this.hasDelta(relPath)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDelta(File file) {
        return this.delta.hasDelta(file);
    }

    public Scanner newDeleteScanner(File basedir) {
        IResourceDelta reldelta = this.getDelta(basedir);
        if (reldelta == null || !EclipseIncrementalBuildContext.isRemove(reldelta)) {
            return new EmptyScanner(basedir);
        }
        return new ResourceDeltaScanner(reldelta, true);
    }

    private IResourceDelta getDelta(File file) {
        IResourceDelta adapt = (IResourceDelta)Adapters.adapt((Object)this.delta, IResourceDelta.class);
        if (adapt == null) {
            return null;
        }
        IPath relpath = this.getRelativePath(file);
        if (relpath == null) {
            return null;
        }
        return adapt.findMember(relpath);
    }

    private IPath getRelativePath(File file) {
        IPath path;
        IResource adapt = (IResource)Adapters.adapt((Object)this.delta, IResource.class);
        if (adapt == null) {
            return null;
        }
        IPath basepath = adapt.getLocation();
        if (!basepath.isPrefixOf(path = IPath.fromOSString((String)file.getAbsolutePath()))) {
            return null;
        }
        return path.removeFirstSegments(basepath.segmentCount());
    }

    public Scanner newScanner(File basedir) {
        return this.newScanner(basedir, false);
    }

    public Scanner newScanner(File basedir, boolean ignoreDelta) {
        DirectoryScanner ds = ignoreDelta ? new DirectoryScanner() : new DirectoryScanner(){

            protected boolean isSelected(String name, File file) {
                return EclipseIncrementalBuildContext.this.hasDelta(file);
            }
        };
        ds.setBasedir(basedir);
        return ds;
    }

    static boolean isContentChange(IResourceDelta delta) {
        int kind = delta.getKind();
        if (1 == kind) {
            return true;
        }
        if (4 == kind) {
            if (delta.getResource() instanceof IContainer) {
                return true;
            }
            int flags = delta.getFlags();
            return (flags & 0x100) != 0;
        }
        return false;
    }

    static boolean isRemove(IResourceDelta delta) {
        int kind = delta.getKind();
        if (2 == kind) {
            return true;
        }
        return 4 == kind && delta.getResource() instanceof IContainer;
    }

    public boolean isIncremental() {
        return true;
    }

    public void refresh(File file) {
        this.results.refresh(file);
    }

    public OutputStream newFileOutputStream(File file) throws IOException {
        return new ChangedFileOutputStream(file, this);
    }

    public void setValue(String key, Object value) {
        this.context.put(key, value);
    }

    public Object getValue(String key) {
        return this.context.get(key);
    }

    @Deprecated
    public void addError(File file, int line, int column, String message, Throwable cause) {
        this.addMessage(file, line, column, message, 2, cause);
    }

    @Deprecated
    public void addWarning(File file, int line, int column, String message, Throwable cause) {
        this.addMessage(file, line, column, message, 1, cause);
    }

    public void addMessage(File file, int line, int column, String message, int severity, Throwable cause) {
        this.results.addMessage(file, line, column, message, severity, cause);
    }

    public void removeMessages(File file) {
        this.results.removeMessages(file);
    }

    public boolean isUptodate(File target, File source) {
        return target != null && target.exists() && source != null && source.exists() && target.lastModified() > source.lastModified();
    }

    @Override
    public void release() {
        ThreadBuildContext.setThreadBuildContext(null);
    }
}

