/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.persistence;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.runtime.extensions.AbstractExtensionPointManager;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.runtime.persistence.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistenceDelegate;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IVariableDelegate;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IVariableProvider;
import org.eclipse.tcf.te.runtime.persistence.internal.PersistenceDelegateBinding;
import org.eclipse.tcf.te.runtime.persistence.internal.PersistenceDelegateBindingExtensionPointManager;
import org.eclipse.tcf.te.runtime.persistence.internal.VariableDelegateExtensionPointManager;
import org.eclipse.tcf.te.runtime.persistence.internal.VariableProviderExtensionPointManager;
import org.osgi.framework.Bundle;

public class PersistenceManager
extends AbstractExtensionPointManager<IPersistenceDelegate> {
    PersistenceManager() {
    }

    public static PersistenceManager getInstance() {
        return LazyInstance.instance;
    }

    protected String getExtensionPointId() {
        return "org.eclipse.tcf.te.runtime.persistence.delegates";
    }

    protected String getConfigurationElementName() {
        return "delegate";
    }

    protected IPersistenceDelegate[] getDelegates(boolean unique) {
        ArrayList<IPersistenceDelegate> contributions = new ArrayList<IPersistenceDelegate>();
        Collection delegates = this.getExtensions().values();
        for (ExecutableExtensionProxy delegate : delegates) {
            IPersistenceDelegate instance;
            IPersistenceDelegate iPersistenceDelegate = instance = unique ? (IPersistenceDelegate)delegate.newInstance() : (IPersistenceDelegate)delegate.getInstance();
            if (instance == null || contributions.contains(instance)) continue;
            contributions.add(instance);
        }
        return contributions.toArray(new IPersistenceDelegate[contributions.size()]);
    }

    protected IPersistenceDelegate getDelegate(String id) {
        IPersistenceDelegate contribution = null;
        if (this.getExtensions().containsKey(id)) {
            ExecutableExtensionProxy proxy = (ExecutableExtensionProxy)this.getExtensions().get(id);
            contribution = (IPersistenceDelegate)proxy.getInstance();
        }
        return contribution;
    }

    public IPersistenceDelegate getDelegate(Object context, Object container) {
        PersistenceDelegateBinding[] bindings;
        Assert.isNotNull((Object)context);
        ArrayList<IPersistenceDelegate> delegates = new ArrayList<IPersistenceDelegate>();
        PersistenceDelegateBinding[] persistenceDelegateBindingArray = bindings = PersistenceDelegateBindingExtensionPointManager.getInstance().getApplicableBindings(context, container);
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            PersistenceDelegateBinding binding = persistenceDelegateBindingArray[n2];
            IPersistenceDelegate delegate = this.getDelegate(binding.getDelegateId());
            if (delegate != null && !delegates.contains(delegate)) {
                delegates.add(delegate);
            }
            ++n2;
        }
        if (delegates.isEmpty() || delegates.isEmpty()) {
            return null;
        }
        if (Platform.inDebugMode() && delegates.size() > 1) {
            Status status = new Status(1, CoreBundleActivator.getUniqueIdentifier(), "Found multiple persistence delegates for " + context.getClass().getName() + " (" + context + ")" + (container != null ? " to store in " + container : ""));
            Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
        }
        return (IPersistenceDelegate)delegates.get(0);
    }

    public IVariableDelegate[] getVariableDelegates(IPersistenceDelegate persistenceDelegate) {
        return VariableDelegateExtensionPointManager.getInstance().getDelegates(persistenceDelegate);
    }

    public IVariableProvider[] getVariableProviders() {
        return VariableProviderExtensionPointManager.getInstance().getProviders();
    }

    private static class LazyInstance {
        public static PersistenceManager instance = new PersistenceManager();

        private LazyInstance() {
        }
    }
}

