/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.testing;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Exceptions;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.FileProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ProjectConfigAdapter;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.GeneratorConfigProvider;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.testing.OnTheFlyJavaCompiler2;
import org.eclipse.xtext.xbase.testing.RegisteringFileSystemAccess;
import org.eclipse.xtext.xbase.testing.TemporaryFolder;
import org.junit.Assert;

public class CompilationTestHelper {
    private static final Logger LOG = Logger.getLogger(CompilationTestHelper.class);
    public static final String PROJECT_NAME = "myProject";
    @Inject
    private OnTheFlyJavaCompiler2 javaCompiler;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private FileExtensionProvider extensionProvider;
    @Inject
    private IOutputConfigurationProvider outputConfigurationProvider;
    @Inject
    private Provider<Result> resultProvider;
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    private TemporaryFolder temporaryFolder;
    private File workspaceRoot;
    private ClassLoader classpathUriContext;

    public void configureFreshWorkspace() {
        this.workspaceRoot = this.createFreshTempDir();
    }

    @Inject
    private void setTemporaryFolder(TemporaryFolder folder) {
        this.temporaryFolder = folder;
        this.configureFreshWorkspace();
    }

    protected String getSourceFolderPath() {
        return "/myProject/src";
    }

    protected File createFreshTempDir() {
        try {
            return this.temporaryFolder.newFolder();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setJavaCompilerClassPath(Class<?> ... classes) {
        LOG.warn((Object)"java compiler classpath setup is deprecated. Only classloader based classpathes are supported.");
    }

    public void setJavaCompilerClassPath(ClassLoader classLoader) {
        this.javaCompiler = new OnTheFlyJavaCompiler2(classLoader, this.generatorConfigProvider.get(null).getJavaSourceVersion());
        this.classpathUriContext = classLoader;
    }

    public void setJavaVersion(JavaVersion javaVersion) {
        this.javaCompiler.setJavaVersion(javaVersion);
    }

    public void assertCompilesTo(CharSequence source, final CharSequence expected) throws IOException {
        final boolean[] called = new boolean[1];
        this.compile(source, new IAcceptor<Result>(){

            public void accept(Result r) {
                Assert.assertEquals((Object)expected.toString(), (Object)r.getSingleGeneratedCode());
                called[0] = true;
            }
        });
        Assert.assertTrue((String)("Nothing was generated but the expectation was :\n" + String.valueOf(expected)), (boolean)called[0]);
    }

    public void compile(CharSequence source, IAcceptor<Result> acceptor) throws IOException {
        String fileName = "MyFile." + this.extensionProvider.getPrimaryFileExtension();
        this.compile(this.resourceSet(new Pair((Object)fileName, (Object)source)), acceptor);
    }

    public void compile(Iterable<? extends CharSequence> sources, IAcceptor<Result> acceptor) throws IOException {
        int index = 0;
        ArrayList pairs = Lists.newArrayList();
        for (CharSequence charSequence : sources) {
            String fileName = "MyFile" + ++index + "." + this.extensionProvider.getPrimaryFileExtension();
            pairs.add(new Pair((Object)fileName, (Object)charSequence));
        }
        this.compile(this.resourceSet((Pair[])Conversions.unwrapArray((Object)pairs, Pair.class)), acceptor);
    }

    public void compile(ResourceSet resourceSet, IAcceptor<Result> acceptor) {
        try {
            ArrayList resourcesToCheck = Lists.newArrayList((Iterable)resourceSet.getResources());
            if (this.generatorConfigProvider instanceof GeneratorConfigProvider) {
                GeneratorConfigProvider configProvider = (GeneratorConfigProvider)this.generatorConfigProvider;
                GeneratorConfig config = this.generatorConfigProvider.get(null);
                config.setJavaSourceVersion(this.javaCompiler.getJavaVersion());
                GeneratorConfig existent = configProvider.install(resourceSet, config);
                if (existent != null) {
                    existent.setJavaSourceVersion(this.javaCompiler.getJavaVersion());
                    configProvider.install(resourceSet, existent);
                }
            }
            Result result = (Result)this.resultProvider.get();
            result.setJavaCompiler(this.javaCompiler);
            result.setCheckMode(this.getCheckMode());
            result.setResources(resourcesToCheck);
            result.setResourceSet(resourceSet);
            result.setOutputConfigurations(this.getOutputConfigurations());
            result.doGenerate();
            acceptor.accept((Object)result);
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    protected CheckMode getCheckMode() {
        return CheckMode.NORMAL_AND_FAST;
    }

    protected Iterable<? extends OutputConfiguration> getOutputConfigurations() {
        return this.outputConfigurationProvider.getOutputConfigurations();
    }

    public ResourceSet resourceSet(Pair<String, ? extends CharSequence> ... resources) throws IOException {
        XtextResourceSet result = this.newResourceSetWithUTF8Encoding();
        FileProjectConfig projectConfig = new FileProjectConfig(new File(this.workspaceRoot, PROJECT_NAME), PROJECT_NAME);
        projectConfig.addSourceFolder("src");
        ProjectConfigAdapter.install((ResourceSet)result, (IProjectConfig)projectConfig);
        Pair<String, ? extends CharSequence>[] pairArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<String, ? extends CharSequence> entry = pairArray[n2];
            URI uri = this.copyToWorkspace(this.getSourceFolderPath() + "/" + (String)entry.getKey(), (CharSequence)entry.getValue());
            Resource resource = result.createResource(uri);
            if (resource == null) {
                throw new IllegalStateException("Couldn't create resource for URI " + String.valueOf(uri) + ". Resource.Factory not registered?");
            }
            resource.load(result.getLoadOptions());
            ++n2;
        }
        return result;
    }

    public URI copyToWorkspace(String workspacefilePath, CharSequence contents) {
        File fullPath = new File(this.workspaceRoot.getAbsolutePath() + "/" + workspacefilePath);
        if (fullPath.exists()) {
            fullPath.delete();
        } else {
            this.mkDir(fullPath.getParentFile());
        }
        URI uri = URI.createFileURI((String)fullPath.getAbsolutePath());
        this.writeFileWithUTF8(uri.toFileString(), contents.toString());
        return uri;
    }

    private void writeFileWithUTF8(String filename, String content) {
        try {
            File file = new File(filename);
            Files.write((byte[])content.getBytes(StandardCharsets.UTF_8), (File)file);
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }

    private void mkDir(File file) {
        if (!file.getParentFile().exists()) {
            this.mkDir(file.getParentFile());
        }
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public ResourceSet unLoadedResourceSet(Pair<String, ? extends CharSequence> ... resources) throws IOException {
        XtextResourceSet result = this.newResourceSetWithUTF8Encoding();
        Pair<String, ? extends CharSequence>[] pairArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<String, ? extends CharSequence> entry = pairArray[n2];
            URI uri = this.copyToWorkspace(this.getSourceFolderPath() + "/" + (String)entry.getKey(), (CharSequence)entry.getValue());
            Resource resource = result.createResource(uri);
            if (resource == null) {
                throw new IllegalStateException("Couldn't create resource for URI " + String.valueOf(uri) + ". Resource.Factory not registered?");
            }
            ++n2;
        }
        return result;
    }

    private XtextResourceSet newResourceSetWithUTF8Encoding() {
        XtextResourceSet result = (XtextResourceSet)this.resourceSetProvider.get();
        result.setClasspathURIContext((Object)this.classpathUriContext);
        result.getLoadOptions().put(XtextResource.OPTION_ENCODING, StandardCharsets.UTF_8.name());
        return result;
    }

    public static class Result {
        @Inject
        private IResourceServiceProvider.Registry serviceRegistry;
        @Inject
        private Provider<RegisteringFileSystemAccess> fileSystemAccessProvider;
        private OnTheFlyJavaCompiler2 javaCompiler;
        private ResourceSet resourceSet;
        private List<Resource> sources;
        private Map<String, OutputConfiguration> outputConfigurations;
        private CheckMode checkMode;
        private ClassLoader classLoader;
        private Map<String, Class<?>> compiledClasses;
        private Map<String, String> generatedCode;
        private RegisteringFileSystemAccess access;
        private ResourceDescriptionsData index;
        private List<Issue> allErrorsAndWarnings;

        protected void setResourceSet(ResourceSet resourceSet) {
            this.resourceSet = resourceSet;
        }

        protected void setCheckMode(CheckMode checkMode) {
            this.checkMode = checkMode;
        }

        protected void setResources(List<Resource> sources) {
            this.sources = sources;
        }

        protected void setJavaCompiler(OnTheFlyJavaCompiler2 javaCompiler) {
            this.javaCompiler = javaCompiler;
        }

        protected void setOutputConfigurations(Iterable<? extends OutputConfiguration> outputConfiguration) {
            this.outputConfigurations = Maps.newHashMap();
            for (OutputConfiguration outputConfiguration2 : outputConfiguration) {
                this.outputConfigurations.put(outputConfiguration2.getName(), outputConfiguration2);
            }
        }

        public List<Issue> getErrorsAndWarnings() {
            this.doValidation();
            return this.allErrorsAndWarnings;
        }

        public void assertNoErrors() {
            List errors = this.getErrorsAndWarnings().stream().filter(it -> it.getSeverity() == Severity.ERROR).collect(Collectors.toList());
            if (!Iterables.isEmpty(errors)) {
                Assert.fail((String)("Expected no errors, but got:\n" + errors.stream().map(Object::toString).collect(Collectors.joining("\n"))));
            }
        }

        public void assertNoIssues() {
            List<Issue> issues = this.getErrorsAndWarnings();
            if (!Iterables.isEmpty(issues)) {
                Assert.fail((String)("Expected no issues, but got:\n" + issues.stream().map(Object::toString).collect(Collectors.joining("\n"))));
            }
        }

        public Map<String, Class<?>> getCompiledClasses() {
            this.doCompile();
            return this.compiledClasses;
        }

        public ClassLoader getClassLoader() {
            this.doCompile();
            return this.classLoader;
        }

        public Map<String, String> getGeneratedCode() {
            this.doGenerate();
            return this.generatedCode;
        }

        public String getGeneratedCode(String typeName) {
            return this.getGeneratedCode().get(typeName);
        }

        public String getSingleGeneratedCode() {
            this.doGenerate();
            Set<RegisteringFileSystemAccess.GeneratedFile> generatedFiles = this.access.getGeneratedFiles();
            if (generatedFiles.size() == 1) {
                return generatedFiles.iterator().next().getContents().toString();
            }
            if (generatedFiles.isEmpty()) {
                return "NO FILE WAS GENERATED";
            }
            String separator = System.getProperty("line.separator");
            if (separator == null) {
                separator = "\n";
            }
            ArrayList files = Lists.newArrayList(generatedFiles);
            Collections.sort(files, new Comparator<RegisteringFileSystemAccess.GeneratedFile>(){

                @Override
                public int compare(RegisteringFileSystemAccess.GeneratedFile o1, RegisteringFileSystemAccess.GeneratedFile o2) {
                    return o1.getPath().toString().compareTo(o2.getPath().toString());
                }
            });
            StringBuilder result = new StringBuilder("MULTIPLE FILES WERE GENERATED" + separator + separator);
            int i = 1;
            for (RegisteringFileSystemAccess.GeneratedFile file : files) {
                result.append("File " + i + " : " + file.getPath().toString() + separator + separator);
                result.append(file.getContents()).append(separator);
                ++i;
            }
            return result.toString();
        }

        public ResourceSet getResourceSet() {
            return this.resourceSet;
        }

        public Class<?> getCompiledClass() {
            return (Class)IterableExtensions.head(this.getCompiledClasses().values());
        }

        public Class<?> getCompiledClass(String className) {
            return this.getCompiledClasses().get(className);
        }

        public Map<String, CharSequence> getAllGeneratedResources() {
            this.doGenerate();
            HashMap result = Maps.newHashMap();
            for (RegisteringFileSystemAccess.GeneratedFile f : this.access.getGeneratedFiles()) {
                result.put(f.getPath(), f.getContents());
            }
            return result;
        }

        protected void doIndex() {
            if (this.index == null) {
                ArrayList descriptions = Lists.newArrayList();
                for (Resource resource : this.sources) {
                    IResourceServiceProvider serviceProvider = this.serviceRegistry.getResourceServiceProvider(resource.getURI());
                    IResourceDescription description = serviceProvider.getResourceDescriptionManager().getResourceDescription(resource);
                    descriptions.add(description);
                }
                this.index = new ResourceDescriptionsData((Iterable)descriptions);
                ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)this.resourceSet, (ResourceDescriptionsData)this.index);
            }
        }

        protected void doLinking() {
            this.doIndex();
            for (Resource resource : this.sources) {
                EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
            }
        }

        protected void doValidation() {
            if (this.allErrorsAndWarnings == null) {
                this.doLinking();
                this.allErrorsAndWarnings = Lists.newArrayList();
                for (Resource resource : this.sources) {
                    if (!(resource instanceof XtextResource)) continue;
                    XtextResource xtextResource = (XtextResource)resource;
                    List issues = xtextResource.getResourceServiceProvider().getResourceValidator().validate((Resource)xtextResource, this.checkMode, CancelIndicator.NullImpl);
                    for (Issue issue : issues) {
                        this.allErrorsAndWarnings.add(issue);
                    }
                }
            }
        }

        protected void doGenerate() {
            if (this.access == null) {
                this.doValidation();
                this.access = (RegisteringFileSystemAccess)((Object)this.fileSystemAccessProvider.get());
                this.access.setOutputConfigurations(this.outputConfigurations);
                for (Resource resource : this.sources) {
                    if (!(resource instanceof XtextResource)) continue;
                    this.access.setProjectName(CompilationTestHelper.PROJECT_NAME);
                    XtextResource xtextResource = (XtextResource)resource;
                    IResourceServiceProvider resourceServiceProvider = xtextResource.getResourceServiceProvider();
                    GeneratorDelegate generator = (GeneratorDelegate)resourceServiceProvider.get(GeneratorDelegate.class);
                    if (generator == null) continue;
                    GeneratorContext context = new GeneratorContext();
                    context.setCancelIndicator(CancelIndicator.NullImpl);
                    generator.generate((Resource)xtextResource, (IFileSystemAccess2)this.access, (IGeneratorContext)context);
                }
                this.generatedCode = Maps.newHashMap();
                for (RegisteringFileSystemAccess.GeneratedFile e : this.access.getGeneratedFiles()) {
                    if (e.getJavaClassName() == null) continue;
                    this.generatedCode.put(e.getJavaClassName(), e.getContents().toString());
                }
            }
        }

        protected void doCompile() {
            if (this.compiledClasses == null || this.classLoader == null) {
                this.doGenerate();
                try {
                    Map<String, Class<?>> compilationResult = this.javaCompiler.compileToClasses(this.getGeneratedCode());
                    Iterator<Class<?>> values = compilationResult.values().iterator();
                    this.classLoader = values.hasNext() ? values.next().getClassLoader() : null;
                    this.compiledClasses = compilationResult;
                }
                catch (IllegalArgumentException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
    }
}

