/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.core;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Plugin;

public class ResourceManager {
    protected String m_pluginID = null;
    protected Plugin m_plugin = null;
    protected ResourceManager m_parentManager = null;
    protected ResourceBundle m_stringResources = null;
    protected String m_stringResourceFilename = null;

    public ResourceManager(Plugin plugin) {
        this(plugin, "messages.properties");
    }

    public ResourceManager(Plugin plugin, String stringResourceFilename) {
        this.m_pluginID = plugin.getBundle().getSymbolicName();
        this.m_plugin = plugin;
        this.m_stringResourceFilename = stringResourceFilename;
        this.getStringRegistry();
    }

    public void dispose() {
        this.disposeStringRegistry();
        this.m_stringResourceFilename = null;
        this.m_plugin = null;
        this.m_pluginID = null;
    }

    public Plugin getPlugin() {
        return this.m_plugin;
    }

    public void setParentManager(ResourceManager parentManager) {
        this.m_parentManager = parentManager;
    }

    public ResourceManager getParentManager() {
        return this.m_parentManager;
    }

    protected ResourceBundle getStringRegistry() {
        if (this.m_stringResources == null) {
            String filename = this.m_stringResourceFilename;
            String propertiesExtension = ".properties";
            if (filename.endsWith(propertiesExtension)) {
                filename = filename.substring(0, filename.length() - propertiesExtension.length());
            }
            ClassLoader classLoader = this.m_plugin.getClass().getClassLoader();
            Locale locale = Locale.getDefault();
            String propertyFileName1 = this.m_pluginID + ".plugin." + filename;
            try {
                this.m_stringResources = ResourceBundle.getBundle(propertyFileName1, locale, classLoader);
            }
            catch (MissingResourceException e) {
                this.m_stringResources = null;
            }
            String propertyFileName2 = filename;
            if (this.m_stringResources == null) {
                try {
                    this.m_stringResources = ResourceBundle.getBundle(propertyFileName2, locale, classLoader);
                }
                catch (MissingResourceException e) {
                    this.m_stringResources = null;
                }
            }
        }
        return this.m_stringResources;
    }

    protected void disposeStringRegistry() {
        this.m_stringResources = null;
    }

    public String getString(String key) {
        Object result = null;
        if (key == null) {
            return "(null resource)";
        }
        ResourceBundle strings = this.getStringRegistry();
        if (strings == null) {
            result = "(" + key + ")";
        } else {
            try {
                result = strings.getString(key);
            }
            catch (MissingResourceException e) {
                result = null;
            }
        }
        if (result == null && this.m_parentManager != null) {
            result = this.m_parentManager.getString(key);
        }
        if (result == null) {
            result = "[" + key + "]";
        }
        return result;
    }

    public String getString(String key, Object ... arguments) {
        return MessageFormat.format(this.getString(key), arguments);
    }
}

