/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;

class Relationship {
    static final String ELEMENT_NAME = "relationship";
    static final String RELATED_ID_ATTRIBUTE_NAME = "relatedId";
    static final String TYPE_ATTRIBUTE_NAME = "type";
    static final int TYPE_REPLACED_BY_CODE = 1;
    static final int TYPE_WRAPPER_OF_CODE = 2;
    static final String[] sm_typeValues = new String[]{"none", "replacedBy", "wrapperOf"};
    private int m_type;
    private String m_relatedId;

    static List<Relationship> createInstances(IConfigurationElement relationshipParentElement) {
        if (relationshipParentElement == null) {
            return null;
        }
        IConfigurationElement[] elements = relationshipParentElement.getChildren(ELEMENT_NAME);
        if (elements.length < 1) {
            return null;
        }
        Vector<Relationship> instances = new Vector<Relationship>(elements.length);
        int i = 0;
        while (i < elements.length) {
            Relationship anInstance = new Relationship();
            try {
                anInstance.init(elements[i]);
            }
            catch (OdaException odaException) {
                anInstance = null;
            }
            if (anInstance != null) {
                instances.add(anInstance);
            }
            ++i;
        }
        return instances.isEmpty() ? null : instances;
    }

    private Relationship() {
    }

    private void init(IConfigurationElement relationshipElement) throws OdaException {
        this.m_relatedId = relationshipElement.getAttribute(RELATED_ID_ATTRIBUTE_NAME);
        if (this.m_relatedId == null || this.m_relatedId.length() == 0) {
            throw new OdaException(Messages.bind((String)Messages.manifest_NO_ATTRIBUTE_ID_DEFINED, (Object)RELATED_ID_ATTRIBUTE_NAME, (Object)ELEMENT_NAME));
        }
        this.setRelationshipType(relationshipElement.getAttribute(TYPE_ATTRIBUTE_NAME));
    }

    private void setRelationshipType(String typeAttributeValue) throws OdaException {
        if (typeAttributeValue == null || typeAttributeValue.length() == 0) {
            throw new OdaException();
        }
        int i = 1;
        while (i < sm_typeValues.length) {
            if (typeAttributeValue.equalsIgnoreCase(sm_typeValues[i])) {
                this.m_type = i;
                return;
            }
            ++i;
        }
        throw new OdaException();
    }

    boolean isDeprecated() {
        return this.m_type == 1;
    }

    boolean isWrapper() {
        return this.m_type == 2;
    }

    int getType() {
        return this.m_type;
    }

    String getRelatedId() {
        return this.m_relatedId;
    }
}

